/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import com.google.android.gms.internal.zzdon;
import com.google.android.gms.internal.zzdoo;
import com.google.android.gms.internal.zzdop;
import com.google.android.gms.internal.zzdrk;
import com.google.android.gms.internal.zzdro;
import com.google.android.gms.internal.zzdsc;
import com.google.android.gms.internal.zzdux;
import com.google.android.gms.internal.zzdvt;
import com.google.android.gms.internal.zzdvu;
import com.google.android.gms.internal.zzdvy;
import com.google.android.gms.internal.zzdwg;
import com.google.android.gms.internal.zzdxb;
import com.google.android.gms.internal.zzdxe;
import com.google.android.gms.internal.zzdxw;
import com.google.android.gms.internal.zzdya;
import com.google.android.gms.internal.zzdyc;
import com.google.android.gms.internal.zzdyo;
import com.google.android.gms.internal.zzdyw;
import com.google.android.gms.internal.zzdyx;
import com.google.android.gms.internal.zzdza;
import com.google.android.gms.internal.zzeac;
import com.google.android.gms.internal.zzeaj;
import com.google.android.gms.internal.zzeal;
import com.google.android.gms.internal.zzeao;
import com.google.firebase.database.DatabaseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class zzdom
implements zzdvt {
    private static final Charset zzfcd = Charset.forName("UTF-8");
    private final SQLiteDatabase zzlru;
    private final zzdxw zzlrv;
    private boolean zzlrw;
    private long zzlrx = 0L;

    public zzdom(Context context, zzdro zzdro2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.zzlrv = zzdro2.zzpm("Persistence");
        this.zzlru = zzdom.zzan(context, string2);
    }

    @Override
    public final void zza(zzdsc zzdsc2, zzdyx zzdyx2, long l) {
        this.zzbqc();
        long l2 = System.currentTimeMillis();
        byte[] byArray = zzdom.zzax(zzdyx2.getValue(true));
        this.zza(zzdsc2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlrv.zzbwk()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user overwrite in %dms", l3);
            this.zzlrv.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(zzdsc zzdsc2, zzdrk zzdrk2, long l) {
        this.zzbqc();
        long l2 = System.currentTimeMillis();
        byte[] byArray = zzdom.zzax(zzdrk2.zzci(true));
        this.zza(zzdsc2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlrv.zzbwk()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user merge in %dms", l3);
            this.zzlrv.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzbk(long l) {
        this.zzbqc();
        long l2 = System.currentTimeMillis();
        int n = this.zzlru.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlrv.zzbwk()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3);
            this.zzlrv.zzb(string, null, objectArray);
        }
    }

    @Override
    public final List<zzdux> zzbpy() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<zzdux> arrayList = new ArrayList<zzdux>();
        try (Cursor cursor = this.zzlru.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<zzdux> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                zzdux zzdux2;
                Iterable<zzdyw> iterable;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new zzdsc(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    ArrayList<byte[]> arrayList3 = new ArrayList<byte[]>();
                    do {
                        arrayList3.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = zzdom.zzao(arrayList3);
                }
                Object object = zzeac.zzpt((String)new String(byArray, zzfcd));
                if ("o".equals(string)) {
                    iterable = zzdza.zza(object, zzdyo.zzbxe());
                    zzdux2 = new zzdux(l2, (zzdsc)((Object)arrayList2), (zzdyx)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = zzdrk.zzae((Map)object);
                    zzdux2 = new zzdux(l2, (zzdsc)((Object)arrayList2), (zzdrk)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(zzdux2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzlrv.zzbwk()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Loaded %d writes in %dms", arrayList.size(), l2);
                this.zzlrv.zzb(string, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private final void zza(zzdsc zzdsc2, long l, String string, byte[] byArray) {
        this.zzbqc();
        this.zzlru.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = zzdom.zzd(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", zzdom.zzc(zzdsc2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.zzlru.insertWithOnConflict("writes", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(l));
        contentValues.put("path", zzdom.zzc(zzdsc2));
        contentValues.put("type", string);
        contentValues.put("part", null);
        contentValues.put("node", byArray);
        this.zzlru.insertWithOnConflict("writes", null, contentValues, 5);
    }

    @Override
    public final zzdyx zza(zzdsc zzdsc2) {
        return this.zzb(zzdsc2);
    }

    @Override
    public final void zza(zzdsc zzdsc2, zzdyx zzdyx2) {
        this.zzbqc();
        this.zza(zzdsc2, zzdyx2, false);
    }

    @Override
    public final void zzb(zzdsc zzdsc2, zzdyx zzdyx2) {
        this.zzbqc();
        this.zza(zzdsc2, zzdyx2, true);
    }

    private final void zza(zzdsc zzdsc2, zzdyx zzdyx2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", zzdsc2);
            n = this.zzc(zzdsc2, zzdyx2);
        } else {
            n2 = 0;
            n = 0;
            for (zzdyw zzdyw2 : zzdyx2) {
                n2 += this.zza("serverCache", zzdsc2.zza(zzdyw2.zzbxn()));
                n += this.zzc(zzdsc2.zza(zzdyw2.zzbxn()), zzdyw2.zzbpt());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzlrv.zzbwk()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, zzdsc2.toString(), l2);
            this.zzlrv.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(zzdsc zzdsc2, zzdrk zzdrk2) {
        this.zzbqc();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<zzdsc, zzdyx> entry : zzdrk2) {
            n2 += this.zza("serverCache", zzdsc2.zzh(entry.getKey()));
            n += this.zzc(zzdsc2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzlrv.zzbwk()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, zzdsc2.toString(), l2);
            this.zzlrv.zzb(string, null, objectArray);
        }
    }

    @Override
    public final long zzbpz() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.zzlru.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public final void zza(zzdvy zzdvy2) {
        this.zzbqc();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zzdvy2.id));
        contentValues.put("path", zzdom.zzc(zzdvy2.zzmey.zzbpw()));
        contentValues.put("queryParams", zzdvy2.zzmey.zzbvx().zzbvv());
        contentValues.put("lastUse", Long.valueOf(zzdvy2.zzmez));
        contentValues.put("complete", Boolean.valueOf(zzdvy2.complete));
        contentValues.put("active", Boolean.valueOf(zzdvy2.zzimj));
        this.zzlru.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzlrv.zzbwk()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Saved new tracked query in %dms", l2);
            this.zzlrv.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzbl(long l) {
        this.zzbqc();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzlru.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.zzlru.delete("trackedKeys", string3, new String[]{string});
    }

    @Override
    public final List<zzdvy> zzbqa() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zzdvy> arrayList = new ArrayList<zzdvy>();
        try (Cursor cursor = this.zzlru.query("trackedQueries", stringArray, null, null, null, null, "id");){
            Object[] objectArray;
            Object object;
            ArrayList<zzdvy> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new zzdsc(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = zzeac.zzps((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                object = map;
                ArrayList<zzdvy> arrayList3 = arrayList2;
                objectArray = zzdxb.zzag((Map<String, Object>)object);
                zzdxe zzdxe2 = new zzdxe((zzdsc)((Object)arrayList3), (zzdxb)objectArray);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zzdvy zzdvy2 = new zzdvy(l2, zzdxe2, l3, bl, bl2);
                arrayList.add(zzdvy2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzlrv.zzbwk()) {
                objectArray = new Object[]{};
                object = String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2);
                this.zzlrv.zzb((String)object, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public final void zzbm(long l) {
        this.zzbqc();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.zzlru.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlrv.zzbwk()) {
            Object[] objectArray = new Object[]{};
            String string2 = String.format("Reset active tracked queries in %dms", l3);
            this.zzlrv.zzb(string2, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<zzdya> set) {
        this.zzbqc();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzlru.delete("trackedKeys", string2, new String[]{string});
        for (zzdya zzdya2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzdya2.asString());
            this.zzlru.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlrv.zzbwk()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3);
            this.zzlrv.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<zzdya> set, Set<zzdya> set2) {
        this.zzbqc();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (zzdya zzdya2 : set2) {
            this.zzlru.delete("trackedKeys", string, new String[]{string2, zzdya2.asString()});
        }
        for (zzdya zzdya2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzdya2.asString());
            this.zzlru.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzlrv.zzbwk()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3);
            this.zzlrv.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final Set<zzdya> zzbn(long l) {
        return this.zze(Collections.singleton(l));
    }

    @Override
    public final Set<zzdya> zze(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = "id IN (";
        Object object = zzdom.zzq(set);
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.zzlru.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(zzdya.zzpq(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.zzlrv.zzbwk()) {
                Object[] objectArray = new Object[]{};
                String string4 = String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2);
                this.zzlrv.zzb(string4, null, objectArray);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public final void zza(zzdsc zzdsc2, zzdvu zzdvu2) {
        String string;
        String string2;
        String string3;
        Iterable<Object> iterable;
        Iterable<zzdya> iterable2;
        if (!zzdvu2.zzbur()) {
            return;
        }
        this.zzbqc();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzdsc2, new String[]{"rowid", "path"});
        zzdwg<Object> zzdwg2 = new zzdwg<Object>(null);
        zzdwg<Object> zzdwg3 = new zzdwg<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new zzdsc(cursor.getString(1));
            if (!zzdsc2.zzi((zzdsc)iterable2)) {
                iterable = String.valueOf(zzdsc2);
                string3 = String.valueOf(iterable2);
                string2 = new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string3).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string3).append(". Ignoring.").toString();
                this.zzlrv.zze(string2, null);
                continue;
            }
            iterable = zzdsc.zza(zzdsc2, (zzdsc)iterable2);
            if (zzdvu2.zzv((zzdsc)iterable)) {
                zzdwg2 = zzdwg2.zzb((zzdsc)iterable, l2);
                continue;
            }
            if (zzdvu2.zzw((zzdsc)iterable)) {
                zzdwg3 = zzdwg3.zzb((zzdsc)iterable, l2);
                continue;
            }
            string3 = String.valueOf(zzdsc2);
            string = String.valueOf(iterable2);
            string2 = new StringBuilder(88 + String.valueOf(string3).length() + String.valueOf(string).length()).append("We are pruning at ").append(string3).append(" and have data at ").append(string).append(" that isn't marked for pruning or keeping. Ignoring.").toString();
            this.zzlrv.zze(string2, null);
        }
        int n = 0;
        int n2 = 0;
        if (!zzdwg2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(zzdsc2, zzdsc.zzbtd(), zzdwg2, zzdwg3, zzdvu2, (List<zzeal<zzdsc, zzdyx>>)iterable2);
            iterable = zzdwg2.values();
            string = zzdom.zzq(iterable);
            string3 = new StringBuilder(11 + String.valueOf(string).length()).append("rowid IN (").append(string).append(")").toString();
            this.zzlru.delete("serverCache", string3, null);
            ArrayList arrayList = (ArrayList)iterable2;
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList.get(i);
                zzeal zzeal2 = (zzeal)e;
                this.zzc(zzdsc2.zzh((zzdsc)zzeal2.getFirst()), (zzdyx)zzeal2.zzbyh());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.zzlrv.zzbwk()) {
            Object[] objectArray = new Object[]{};
            string2 = String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3);
            this.zzlrv.zzb(string2, null, objectArray);
        }
    }

    private final void zza(zzdsc zzdsc2, zzdsc zzdsc3, zzdwg<Long> zzdwg2, zzdwg<Long> zzdwg3, zzdvu zzdvu2, List<zzeal<zzdsc, zzdyx>> list) {
        if (zzdwg2.getValue() != null) {
            int n = zzdvu2.zza(0, new zzdon(this, zzdwg3));
            if (n > 0) {
                zzdsc zzdsc4 = zzdsc2.zzh(zzdsc3);
                if (this.zzlrv.zzbwk()) {
                    Object[] objectArray = new Object[]{};
                    String string = String.format("Need to rewrite %d nodes below path %s", n, zzdsc4);
                    this.zzlrv.zzb(string, null, objectArray);
                }
                zzdyx zzdyx2 = this.zzb(zzdsc4);
                zzdvu2.zza(null, new zzdoo(this, zzdwg3, list, zzdsc3, zzdyx2));
            }
            return;
        }
        for (Map.Entry entry : zzdwg2.zzbuw()) {
            zzdya zzdya2 = (zzdya)entry.getKey();
            zzdvu zzdvu3 = zzdvu2.zzd((zzdya)entry.getKey());
            this.zza(zzdsc2, zzdsc3.zza(zzdya2), (zzdwg)entry.getValue(), zzdwg3.zze(zzdya2), zzdvu3, list);
        }
    }

    @Override
    public final void zzbqb() {
        this.zzbqc();
        long l = System.currentTimeMillis();
        int n = this.zzlru.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzlrv.zzbwk()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d (all) write(s) in %dms", n, l2);
            this.zzlrv.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void beginTransaction() {
        zzeao.zzb(!this.zzlrw, "runInTransaction called when an existing transaction is already in progress.");
        if (this.zzlrv.zzbwk()) {
            Object[] objectArray = new Object[]{};
            String string = "Starting transaction.";
            this.zzlrv.zzb("Starting transaction.", null, objectArray);
        }
        this.zzlru.beginTransaction();
        this.zzlrw = true;
        this.zzlrx = System.currentTimeMillis();
    }

    @Override
    public final void endTransaction() {
        this.zzlru.endTransaction();
        this.zzlrw = false;
        long l = System.currentTimeMillis() - this.zzlrx;
        if (this.zzlrv.zzbwk()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Transaction completed. Elapsed: %dms", l);
            this.zzlrv.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void setTransactionSuccessful() {
        this.zzlru.setTransactionSuccessful();
    }

    private static SQLiteDatabase zzan(Context context, String string) {
        zzdop zzdop2 = new zzdop(context, string);
        try {
            SQLiteDatabase sQLiteDatabase = zzdop2.getWritableDatabase();
            sQLiteDatabase.rawQuery("PRAGMA locking_mode = EXCLUSIVE", null).close();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.endTransaction();
            return sQLiteDatabase;
        }
        catch (SQLiteException sQLiteException) {
            SQLiteException sQLiteException2 = sQLiteException;
            if (sQLiteException instanceof SQLiteDatabaseLockedException) {
                String string2 = "Failed to gain exclusive lock to Firebase Database's offline persistence. This generally means you are using Firebase Database from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing FirebaseDatabase in your Application class. If you are intentionally using Firebase Database from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.";
                throw new DatabaseException(string2, sQLiteException2);
            }
            throw sQLiteException2;
        }
    }

    private final void zzbqc() {
        zzeao.zzb(this.zzlrw, "Transaction expected to already be in progress.");
    }

    private final int zzc(zzdsc zzdsc2, zzdyx zzdyx2) {
        long l = zzeaj.zzn(zzdyx2);
        if (zzdyx2 instanceof zzdyc && l > 16384L) {
            if (this.zzlrv.zzbwk()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", zzdsc2, l, 16384);
                this.zzlrv.zzb(string, null, objectArray);
            }
            int n = 0;
            for (zzdyw zzdyw2 : zzdyx2) {
                n += this.zzc(zzdsc2.zza(zzdyw2.zzbxn()), zzdyw2.zzbpt());
            }
            if (!zzdyx2.zzbwu().isEmpty()) {
                this.zzd(zzdsc2.zza(zzdya.zzbwo()), zzdyx2.zzbwu());
                ++n;
            }
            this.zzd(zzdsc2, zzdyo.zzbxe());
            return ++n;
        }
        this.zzd(zzdsc2, zzdyx2);
        return 1;
    }

    private static String zza(zzdsc zzdsc2, int n) {
        String string = String.valueOf(zzdom.zzc(zzdsc2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        if (string2.length() != 0) {
            return string.concat(string2);
        }
        return new String(string);
    }

    private final void zzd(zzdsc zzdsc2, zzdyx zzdyx2) {
        byte[] byArray = zzdom.zzax(zzdyx2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = zzdom.zzd(byArray, 262144);
            if (this.zzlrv.zzbwk()) {
                n = list.size();
                Object[] objectArray = new Object[]{};
                String string = new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString();
                this.zzlrv.zzb(string, null, objectArray);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", zzdom.zza(zzdsc2, n));
                contentValues.put("value", list.get(n));
                this.zzlru.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("path", zzdom.zzc(zzdsc2));
        contentValues.put("value", byArray);
        this.zzlru.insertWithOnConflict("serverCache", null, contentValues, 5);
    }

    /*
     * WARNING - void declaration
     */
    private final zzdyx zzb(zzdsc zzdsc2) {
        String string;
        Object[] objectArray;
        zzdsc zzdsc3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzdsc2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        zzdyx zzdyx2 = zzdyo.zzbxe();
        boolean bl = false;
        HashMap<zzdsc, void> hashMap = new HashMap<zzdsc, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                zzdsc3 = new zzdsc(((String)object2).substring(0, ((String)object2).length() - 10));
                int n = zzdom.zza(zzdsc3, arrayList, i);
                if (this.zzlrv.zzbwk()) {
                    objectArray = new Object[]{};
                    string = new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString();
                    this.zzlrv.zzb(string, null, objectArray);
                }
                zzdyx zzdyx3 = zzdom.zzam(zzdom.zzao(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                zzdyx zzdyx4 = zzdom.zzam((byte[])arrayList2.get(i));
                zzdsc3 = new zzdsc((String)arrayList.get(i));
            }
            if (zzdsc3.zzbtj() != null && zzdsc3.zzbtj().zzbwq()) {
                hashMap.put(zzdsc3, object);
                continue;
            }
            if (zzdsc3.zzi(zzdsc2)) {
                zzeao.zzb(!bl, "Descendants of path must come after ancestors.");
                zzdyx2 = object.zzan(zzdsc.zza(zzdsc3, zzdsc2));
                continue;
            }
            if (zzdsc2.zzi(zzdsc3)) {
                bl = true;
                object2 = zzdsc.zza(zzdsc2, zzdsc3);
                zzdyx2 = zzdyx2.zzl((zzdsc)object2, (zzdyx)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", zzdsc3, zzdsc2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            zzdsc3 = (zzdsc)entry.getKey();
            zzdyx2 = zzdyx2.zzl(zzdsc.zza(zzdsc2, zzdsc3), (zzdyx)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.zzlrv.zzbwk()) {
            objectArray = new Object[]{};
            string = String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), zzeaj.zzo(zzdyx2), zzdsc2, l7, l2, l4, l6);
            this.zzlrv.zzb(string, null, objectArray);
        }
        return zzdyx2;
    }

    private static int zza(zzdsc zzdsc2, List<String> list, int n) {
        int n2;
        String string = zzdom.zzc(zzdsc2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(zzdom.zza(zzdsc2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private final Cursor zza(zzdsc zzdsc2, String[] stringArray) {
        String[] stringArray2;
        String string = zzdom.zzc(zzdsc2);
        String string2 = zzdom.zzoz(string);
        String[] stringArray3 = stringArray2 = new String[zzdsc2.size() + 3];
        zzdsc zzdsc3 = zzdsc2;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!zzdsc3.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray3[n] = zzdom.zzc(zzdsc3);
            zzdsc3 = zzdsc3.zzbti();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray3[n] = zzdom.zzc(zzdsc.zzbtd());
        String string3 = String.valueOf(stringBuilder.toString());
        String string4 = String.valueOf(" OR (path > ? AND path < ?)");
        String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        stringArray2[zzdsc2.size() + 1] = string;
        stringArray2[zzdsc2.size() + 2] = string2;
        String string6 = "path";
        return this.zzlru.query("serverCache", stringArray, string5, stringArray2, null, null, string6);
    }

    private static String zzc(zzdsc zzdsc2) {
        if (zzdsc2.isEmpty()) {
            return "/";
        }
        return String.valueOf(zzdsc2.toString()).concat("/");
    }

    private static String zzoz(String string) {
        String string2 = string.substring(0, string.length() - 1);
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private final int zza(String string, zzdsc zzdsc2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = zzdom.zzc(zzdsc2);
        String string4 = zzdom.zzoz(string3);
        return this.zzlru.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzd(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / 262144 + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(262144, byArray.length - i * 262144);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * 262144, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private static byte[] zzao(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private static byte[] zzax(Object object) {
        try {
            return zzeac.zzbm((Object)object).getBytes(zzfcd);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private static zzdyx zzam(byte[] byArray) {
        try {
            return zzdza.zza(zzeac.zzpt((String)new String(byArray, zzfcd)), zzdyo.zzbxe());
        }
        catch (IOException iOException) {
            String string = new String(byArray, zzfcd);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private static String zzq(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }
}

