/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdto;
import com.google.android.gms.internal.zzdut;
import com.google.android.gms.internal.zzeag;
import com.google.android.gms.internal.zzeah;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class zzeaf
implements zzdto {
    private ScheduledThreadPoolExecutor zzmlk;

    protected ThreadFactory getThreadFactory() {
        return Executors.defaultThreadFactory();
    }

    protected zzdut zzbtc() {
        return zzdut.zzmcx;
    }

    public abstract void zzf(Throwable var1);

    public zzeaf() {
        zzeah zzeah2 = new zzeah(this, null);
        this.zzmlk = new zzeag(this, 1, zzeah2);
        this.zzmlk.setKeepAliveTime(3L, TimeUnit.SECONDS);
    }

    public final ScheduledExecutorService zzbra() {
        return this.zzmlk;
    }

    @Override
    public final void zzn(Runnable runnable) {
        this.zzmlk.execute(runnable);
    }

    @Override
    public final void shutdown() {
        this.zzmlk.setCorePoolSize(0);
    }

    @Override
    public final void restart() {
        this.zzmlk.setCorePoolSize(1);
    }

    public static String zzh(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            return "Firebase Database encountered an OutOfMemoryError. You may need to reduce the amount of data you are syncing to the client (e.g. by using queries or syncing a deeper path). See https://firebase.google.com/docs/database/ios/structure-data#best_practices_for_data_structure and https://firebase.google.com/docs/database/android/retrieve-data#filtering_data";
        }
        if (throwable instanceof DatabaseException) {
            return "";
        }
        String string = FirebaseDatabase.getSdkVersion();
        return new StringBuilder(104 + String.valueOf(string).length()).append("Uncaught exception in Firebase Database runloop (").append(string).append("). Please report to firebase-database-client@google.com").toString();
    }
}

