/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzdsc;
import com.google.android.gms.internal.zzdyq;
import com.google.android.gms.internal.zzdyw;
import com.google.android.gms.internal.zzdyx;
import com.google.android.gms.internal.zzeaq;
import com.google.android.gms.internal.zzear;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.GenericTypeIndicator;
import com.google.firebase.database.zza;
import java.util.Iterator;

public class DataSnapshot {
    private final zzdyq zzlpu;
    private final DatabaseReference zzlpv;

    DataSnapshot(DatabaseReference databaseReference, zzdyq zzdyq2) {
        this.zzlpu = zzdyq2;
        this.zzlpv = databaseReference;
    }

    public DataSnapshot child(String string) {
        DatabaseReference databaseReference = this.zzlpv.child(string);
        zzdyx zzdyx2 = this.zzlpu.zzbpt().zzan(new zzdsc(string));
        return new DataSnapshot(databaseReference, zzdyq.zzj(zzdyx2));
    }

    public boolean hasChild(String string) {
        if (this.zzlpv.getParent() == null) {
            zzeaq.zzpz(string);
        } else {
            zzeaq.zzpy(string);
        }
        return !this.zzlpu.zzbpt().zzan(new zzdsc(string)).isEmpty();
    }

    public boolean hasChildren() {
        return this.zzlpu.zzbpt().getChildCount() > 0;
    }

    public boolean exists() {
        return !this.zzlpu.zzbpt().isEmpty();
    }

    @Nullable
    public Object getValue() {
        return this.zzlpu.zzbpt().getValue();
    }

    @Nullable
    public Object getValue(boolean bl) {
        return this.zzlpu.zzbpt().getValue(bl);
    }

    @Nullable
    public <T> T getValue(Class<T> clazz) {
        return zzear.zza(this.zzlpu.zzbpt().getValue(), clazz);
    }

    @Nullable
    public <T> T getValue(GenericTypeIndicator<T> genericTypeIndicator) {
        return zzear.zza(this.zzlpu.zzbpt().getValue(), genericTypeIndicator);
    }

    public long getChildrenCount() {
        return this.zzlpu.zzbpt().getChildCount();
    }

    public DatabaseReference getRef() {
        return this.zzlpv;
    }

    public String getKey() {
        return this.zzlpv.getKey();
    }

    public Iterable<DataSnapshot> getChildren() {
        Iterator<zzdyw> iterator = this.zzlpu.iterator();
        return new zza(this, iterator);
    }

    public Object getPriority() {
        Object object = this.zzlpu.zzbpt().zzbwu().getValue();
        if (object instanceof Long) {
            return (double)((Long)object).longValue();
        }
        return object;
    }

    public String toString() {
        String string = this.zzlpv.getKey();
        String string2 = String.valueOf(this.zzlpu.zzbpt().getValue(true));
        return new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length()).append("DataSnapshot { key = ").append(string).append(", value = ").append(string2).append(" }").toString();
    }

    static /* synthetic */ DatabaseReference zza(DataSnapshot dataSnapshot) {
        return dataSnapshot.zzlpv;
    }
}

