/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.text.TextUtils;
import com.google.android.gms.internal.zzdrr;
import com.google.android.gms.internal.zzdsc;
import com.google.android.gms.internal.zzdsf;
import com.google.android.gms.internal.zzdti;
import com.google.android.gms.internal.zzdtj;
import com.google.android.gms.internal.zzeam;
import com.google.android.gms.internal.zzeao;
import com.google.android.gms.internal.zzeaq;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import com.google.firebase.database.zzg;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, Map<zzdti, FirebaseDatabase>> zzlql = new HashMap<String, Map<zzdti, FirebaseDatabase>>();
    private final FirebaseApp zzlqm;
    private final zzdti zzlqn;
    private final zzdrr zzlqo;
    private zzdsf zzlqp;

    public static FirebaseDatabase getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static FirebaseDatabase getInstance(String string) {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, string);
    }

    public static FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        Map<zzdti, FirebaseDatabase> map = zzlql.get(firebaseApp.getName());
        if (map == null) {
            map = new HashMap<zzdti, FirebaseDatabase>();
            zzlql.put(firebaseApp.getName(), map);
        }
        zzeam zzeam2 = zzeao.zzpu(string);
        if (!zzeam2.zzlqw.isEmpty()) {
            String string2 = zzeam2.zzlqw.toString();
            throw new DatabaseException(new StringBuilder(113 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Specified Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
        }
        FirebaseDatabase firebaseDatabase = map.get(zzeam2.zzlqn);
        if (firebaseDatabase == null) {
            zzdrr zzdrr2 = new zzdrr();
            if (!firebaseApp.zzbnw()) {
                zzdrr2.zzpo(firebaseApp.getName());
            }
            zzdrr2.zzd(firebaseApp);
            firebaseDatabase = new FirebaseDatabase(firebaseApp, zzeam2.zzlqn, zzdrr2);
            map.put(zzeam2.zzlqn, firebaseDatabase);
        }
        return firebaseDatabase;
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzdti zzdti2, zzdrr zzdrr2) {
        this.zzlqm = firebaseApp;
        this.zzlqn = zzdti2;
        this.zzlqo = zzdrr2;
    }

    public FirebaseApp getApp() {
        return this.zzlqm;
    }

    public DatabaseReference getReference() {
        this.zzbps();
        return new DatabaseReference(this.zzlqp, zzdsc.zzbtd());
    }

    public DatabaseReference getReference(String string) {
        this.zzbps();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzeaq.zzpz(string);
        zzdsc zzdsc2 = new zzdsc(string);
        return new DatabaseReference(this.zzlqp, zzdsc2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzbps();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzeam zzeam2 = zzeao.zzpu(string);
        if (!zzeam2.zzlqn.host.equals(this.zzlqp.zzbtl().host)) {
            String string2 = this.getReference().toString();
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.zzlqp, zzeam2.zzlqw);
    }

    public void purgeOutstandingWrites() {
        this.zzbps();
        this.zzlqp.zzn(new zzg(this));
    }

    public void goOnline() {
        this.zzbps();
        zzdtj.zzl(this.zzlqp);
    }

    public void goOffline() {
        this.zzbps();
        zzdtj.zzk(this.zzlqp);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzoy("setLogLevel");
        this.zzlqo.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzoy("setPersistenceEnabled");
        this.zzlqo.setPersistenceEnabled(bl);
    }

    public synchronized void setPersistenceCacheSizeBytes(long l) {
        this.zzoy("setPersistenceCacheSizeBytes");
        this.zzlqo.setPersistenceCacheSizeBytes(l);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private final void zzoy(String string) {
        if (this.zzlqp != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private final synchronized void zzbps() {
        if (this.zzlqp == null) {
            this.zzlqp = zzdtj.zza(this.zzlqo, this.zzlqn, this);
        }
    }

    static /* synthetic */ zzdsf zza(FirebaseDatabase firebaseDatabase) {
        return firebaseDatabase.zzlqp;
    }
}

