/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import com.google.android.gms.internal.zzdym;
import com.google.android.gms.internal.zzdyn;
import com.google.android.gms.internal.zzdyo;
import com.google.android.gms.internal.zzebj;
import com.google.android.gms.internal.zzebn;
import com.google.android.gms.internal.zzebv;
import com.google.android.gms.internal.zzeeo;
import com.google.android.gms.internal.zzefk;
import com.google.android.gms.internal.zzefl;
import com.google.android.gms.internal.zzefp;
import com.google.android.gms.internal.zzefx;
import com.google.android.gms.internal.zzegs;
import com.google.android.gms.internal.zzegv;
import com.google.android.gms.internal.zzehn;
import com.google.android.gms.internal.zzehr;
import com.google.android.gms.internal.zzeht;
import com.google.android.gms.internal.zzeif;
import com.google.android.gms.internal.zzein;
import com.google.android.gms.internal.zzeio;
import com.google.android.gms.internal.zzeir;
import com.google.android.gms.internal.zzejs;
import com.google.android.gms.internal.zzejz;
import com.google.android.gms.internal.zzekb;
import com.google.android.gms.internal.zzeke;
import com.google.firebase.database.DatabaseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class zzdyl
implements zzefk {
    private static final Charset zzfer = Charset.forName("UTF-8");
    private final SQLiteDatabase zzmgt;
    private final zzehn zzmgu;
    private boolean zzmgv;
    private long zzmgw = 0L;

    public zzdyl(Context context, zzebn zzebn2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.zzmgu = zzebn2.zzpf("Persistence");
        this.zzmgt = zzdyl.zzal(context, string2);
    }

    @Override
    public final void zza(zzebv zzebv2, zzeio zzeio2, long l) {
        this.zzbrh();
        long l2 = System.currentTimeMillis();
        byte[] byArray = zzdyl.zzbd(zzeio2.getValue(true));
        this.zza(zzebv2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmgu.zzbxn()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user overwrite in %dms", l3);
            this.zzmgu.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(zzebv zzebv2, zzebj zzebj2, long l) {
        this.zzbrh();
        long l2 = System.currentTimeMillis();
        byte[] byArray = zzdyl.zzbd(zzebj2.zzck(true));
        this.zza(zzebv2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmgu.zzbxn()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user merge in %dms", l3);
            this.zzmgu.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzbk(long l) {
        this.zzbrh();
        long l2 = System.currentTimeMillis();
        int n = this.zzmgt.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmgu.zzbxn()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3);
            this.zzmgu.zzb(string, null, objectArray);
        }
    }

    @Override
    public final List<zzeeo> zzbrd() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<zzeeo> arrayList = new ArrayList<zzeeo>();
        try (Cursor cursor = this.zzmgt.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<zzeeo> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                zzeeo zzeeo2;
                Iterable<zzein> iterable;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new zzebv(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    ArrayList<byte[]> arrayList3 = new ArrayList<byte[]>();
                    do {
                        arrayList3.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = zzdyl.zzaq(arrayList3);
                }
                Object object = zzejs.zzpm((String)new String(byArray, zzfer));
                if ("o".equals(string)) {
                    iterable = zzeir.zza(object, zzeif.zzbyh());
                    zzeeo2 = new zzeeo(l2, (zzebv)((Object)arrayList2), (zzeio)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = zzebj.zzaj((Map)object);
                    zzeeo2 = new zzeeo(l2, (zzebv)((Object)arrayList2), (zzebj)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(zzeeo2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzmgu.zzbxn()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Loaded %d writes in %dms", arrayList.size(), l2);
                this.zzmgu.zzb(string, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private final void zza(zzebv zzebv2, long l, String string, byte[] byArray) {
        this.zzbrh();
        this.zzmgt.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = zzdyl.zzf(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", zzdyl.zzc(zzebv2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.zzmgt.insertWithOnConflict("writes", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(l));
        contentValues.put("path", zzdyl.zzc(zzebv2));
        contentValues.put("type", string);
        contentValues.put("part", null);
        contentValues.put("node", byArray);
        this.zzmgt.insertWithOnConflict("writes", null, contentValues, 5);
    }

    @Override
    public final zzeio zza(zzebv zzebv2) {
        return this.zzb(zzebv2);
    }

    @Override
    public final void zza(zzebv zzebv2, zzeio zzeio2) {
        this.zzbrh();
        this.zza(zzebv2, zzeio2, false);
    }

    @Override
    public final void zzb(zzebv zzebv2, zzeio zzeio2) {
        this.zzbrh();
        this.zza(zzebv2, zzeio2, true);
    }

    private final void zza(zzebv zzebv2, zzeio zzeio2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", zzebv2);
            n = this.zzc(zzebv2, zzeio2);
        } else {
            n2 = 0;
            n = 0;
            for (zzein zzein2 : zzeio2) {
                n2 += this.zza("serverCache", zzebv2.zza(zzein2.zzbyq()));
                n += this.zzc(zzebv2.zza(zzein2.zzbyq()), zzein2.zzbqx());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmgu.zzbxn()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, zzebv2.toString(), l2);
            this.zzmgu.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(zzebv zzebv2, zzebj zzebj2) {
        this.zzbrh();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<zzebv, zzeio> entry : zzebj2) {
            n2 += this.zza("serverCache", zzebv2.zzh(entry.getKey()));
            n += this.zzc(zzebv2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmgu.zzbxn()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, zzebv2.toString(), l2);
            this.zzmgu.zzb(string, null, objectArray);
        }
    }

    @Override
    public final long zzbre() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.zzmgt.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public final void zza(zzefp zzefp2) {
        this.zzbrh();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zzefp2.id));
        contentValues.put("path", zzdyl.zzc(zzefp2.zzmtq.zzbra()));
        contentValues.put("queryParams", zzefp2.zzmtq.zzbxa().zzbwy());
        contentValues.put("lastUse", Long.valueOf(zzefp2.zzmtr));
        contentValues.put("complete", Boolean.valueOf(zzefp2.complete));
        contentValues.put("active", Boolean.valueOf(zzefp2.zzivn));
        this.zzmgt.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmgu.zzbxn()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Saved new tracked query in %dms", l2);
            this.zzmgu.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzbl(long l) {
        this.zzbrh();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzmgt.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.zzmgt.delete("trackedKeys", string3, new String[]{string});
    }

    @Override
    public final List<zzefp> zzbrf() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zzefp> arrayList = new ArrayList<zzefp>();
        try (Cursor cursor = this.zzmgt.query("trackedQueries", stringArray, null, null, null, null, "id");){
            Object[] objectArray;
            Object object;
            ArrayList<zzefp> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new zzebv(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = zzejs.zzpl((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                object = map;
                ArrayList<zzefp> arrayList3 = arrayList2;
                objectArray = zzegs.zzal((Map<String, Object>)object);
                zzegv zzegv2 = new zzegv((zzebv)((Object)arrayList3), (zzegs)objectArray);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zzefp zzefp2 = new zzefp(l2, zzegv2, l3, bl, bl2);
                arrayList.add(zzefp2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzmgu.zzbxn()) {
                objectArray = new Object[]{};
                object = String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2);
                this.zzmgu.zzb((String)object, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public final void zzbm(long l) {
        this.zzbrh();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.zzmgt.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmgu.zzbxn()) {
            Object[] objectArray = new Object[]{};
            String string2 = String.format("Reset active tracked queries in %dms", l3);
            this.zzmgu.zzb(string2, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<zzehr> set) {
        this.zzbrh();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzmgt.delete("trackedKeys", string2, new String[]{string});
        for (zzehr zzehr2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzehr2.asString());
            this.zzmgt.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmgu.zzbxn()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3);
            this.zzmgu.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<zzehr> set, Set<zzehr> set2) {
        this.zzbrh();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (zzehr zzehr2 : set2) {
            this.zzmgt.delete("trackedKeys", string, new String[]{string2, zzehr2.asString()});
        }
        for (zzehr zzehr2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzehr2.asString());
            this.zzmgt.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmgu.zzbxn()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3);
            this.zzmgu.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final Set<zzehr> zzbn(long l) {
        return this.zze(Collections.singleton(l));
    }

    @Override
    public final Set<zzehr> zze(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = "id IN (";
        Object object = zzdyl.zzr(set);
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.zzmgt.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(zzehr.zzpj(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.zzmgu.zzbxn()) {
                Object[] objectArray = new Object[]{};
                String string4 = String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2);
                this.zzmgu.zzb(string4, null, objectArray);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public final void zza(zzebv zzebv2, zzefl zzefl2) {
        String string;
        String string2;
        String string3;
        Iterable<Object> iterable;
        Iterable<zzehr> iterable2;
        if (!zzefl2.zzbvu()) {
            return;
        }
        this.zzbrh();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzebv2, new String[]{"rowid", "path"});
        zzefx<Object> zzefx2 = new zzefx<Object>(null);
        zzefx<Object> zzefx3 = new zzefx<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new zzebv(cursor.getString(1));
            if (!zzebv2.zzi((zzebv)iterable2)) {
                iterable = String.valueOf(zzebv2);
                string3 = String.valueOf(iterable2);
                string2 = new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string3).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string3).append(". Ignoring.").toString();
                this.zzmgu.zze(string2, null);
                continue;
            }
            iterable = zzebv.zza(zzebv2, (zzebv)iterable2);
            if (zzefl2.zzv((zzebv)iterable)) {
                zzefx2 = zzefx2.zzb((zzebv)iterable, l2);
                continue;
            }
            if (zzefl2.zzw((zzebv)iterable)) {
                zzefx3 = zzefx3.zzb((zzebv)iterable, l2);
                continue;
            }
            string3 = String.valueOf(zzebv2);
            string = String.valueOf(iterable2);
            string2 = new StringBuilder(88 + String.valueOf(string3).length() + String.valueOf(string).length()).append("We are pruning at ").append(string3).append(" and have data at ").append(string).append(" that isn't marked for pruning or keeping. Ignoring.").toString();
            this.zzmgu.zze(string2, null);
        }
        int n = 0;
        int n2 = 0;
        if (!zzefx2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(zzebv2, zzebv.zzbug(), zzefx2, zzefx3, zzefl2, (List<zzekb<zzebv, zzeio>>)iterable2);
            iterable = zzefx2.values();
            string = zzdyl.zzr(iterable);
            string3 = new StringBuilder(11 + String.valueOf(string).length()).append("rowid IN (").append(string).append(")").toString();
            this.zzmgt.delete("serverCache", string3, null);
            ArrayList arrayList = (ArrayList)iterable2;
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList.get(i);
                zzekb zzekb2 = (zzekb)e;
                this.zzc(zzebv2.zzh((zzebv)zzekb2.getFirst()), (zzeio)zzekb2.zzbzi());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.zzmgu.zzbxn()) {
            Object[] objectArray = new Object[]{};
            string2 = String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3);
            this.zzmgu.zzb(string2, null, objectArray);
        }
    }

    private final void zza(zzebv zzebv2, zzebv zzebv3, zzefx<Long> zzefx2, zzefx<Long> zzefx3, zzefl zzefl2, List<zzekb<zzebv, zzeio>> list) {
        if (zzefx2.getValue() != null) {
            int n = zzefl2.zza(0, new zzdym(this, zzefx3));
            if (n > 0) {
                zzebv zzebv4 = zzebv2.zzh(zzebv3);
                if (this.zzmgu.zzbxn()) {
                    Object[] objectArray = new Object[]{};
                    String string = String.format("Need to rewrite %d nodes below path %s", n, zzebv4);
                    this.zzmgu.zzb(string, null, objectArray);
                }
                zzeio zzeio2 = this.zzb(zzebv4);
                zzefl2.zza(null, new zzdyn(this, zzefx3, list, zzebv3, zzeio2));
            }
            return;
        }
        for (Map.Entry entry : zzefx2.zzbvz()) {
            zzehr zzehr2 = (zzehr)entry.getKey();
            zzefl zzefl3 = zzefl2.zzd((zzehr)entry.getKey());
            this.zza(zzebv2, zzebv3.zza(zzehr2), (zzefx)entry.getValue(), zzefx3.zze(zzehr2), zzefl3, list);
        }
    }

    @Override
    public final void zzbrg() {
        this.zzbrh();
        long l = System.currentTimeMillis();
        int n = this.zzmgt.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmgu.zzbxn()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d (all) write(s) in %dms", n, l2);
            this.zzmgu.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void beginTransaction() {
        zzeke.zzb(!this.zzmgv, "runInTransaction called when an existing transaction is already in progress.");
        if (this.zzmgu.zzbxn()) {
            Object[] objectArray = new Object[]{};
            String string = "Starting transaction.";
            this.zzmgu.zzb("Starting transaction.", null, objectArray);
        }
        this.zzmgt.beginTransaction();
        this.zzmgv = true;
        this.zzmgw = System.currentTimeMillis();
    }

    @Override
    public final void endTransaction() {
        this.zzmgt.endTransaction();
        this.zzmgv = false;
        long l = System.currentTimeMillis() - this.zzmgw;
        if (this.zzmgu.zzbxn()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Transaction completed. Elapsed: %dms", l);
            this.zzmgu.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void setTransactionSuccessful() {
        this.zzmgt.setTransactionSuccessful();
    }

    private static SQLiteDatabase zzal(Context context, String string) {
        zzdyo zzdyo2 = new zzdyo(context, string);
        try {
            SQLiteDatabase sQLiteDatabase = zzdyo2.getWritableDatabase();
            sQLiteDatabase.rawQuery("PRAGMA locking_mode = EXCLUSIVE", null).close();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.endTransaction();
            return sQLiteDatabase;
        }
        catch (SQLiteException sQLiteException) {
            SQLiteException sQLiteException2 = sQLiteException;
            if (sQLiteException instanceof SQLiteDatabaseLockedException) {
                String string2 = "Failed to gain exclusive lock to Firebase Database's offline persistence. This generally means you are using Firebase Database from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing FirebaseDatabase in your Application class. If you are intentionally using Firebase Database from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.";
                throw new DatabaseException(string2, sQLiteException2);
            }
            throw sQLiteException2;
        }
    }

    private final void zzbrh() {
        zzeke.zzb(this.zzmgv, "Transaction expected to already be in progress.");
    }

    private final int zzc(zzebv zzebv2, zzeio zzeio2) {
        long l = zzejz.zzn(zzeio2);
        if (zzeio2 instanceof zzeht && l > 16384L) {
            if (this.zzmgu.zzbxn()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", zzebv2, l, 16384);
                this.zzmgu.zzb(string, null, objectArray);
            }
            int n = 0;
            for (zzein zzein2 : zzeio2) {
                n += this.zzc(zzebv2.zza(zzein2.zzbyq()), zzein2.zzbqx());
            }
            if (!zzeio2.zzbxx().isEmpty()) {
                this.zzd(zzebv2.zza(zzehr.zzbxr()), zzeio2.zzbxx());
                ++n;
            }
            this.zzd(zzebv2, zzeif.zzbyh());
            return ++n;
        }
        this.zzd(zzebv2, zzeio2);
        return 1;
    }

    private static String zza(zzebv zzebv2, int n) {
        String string = String.valueOf(zzdyl.zzc(zzebv2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        if (string2.length() != 0) {
            return string.concat(string2);
        }
        return new String(string);
    }

    private final void zzd(zzebv zzebv2, zzeio zzeio2) {
        byte[] byArray = zzdyl.zzbd(zzeio2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = zzdyl.zzf(byArray, 262144);
            if (this.zzmgu.zzbxn()) {
                n = list.size();
                Object[] objectArray = new Object[]{};
                String string = new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString();
                this.zzmgu.zzb(string, null, objectArray);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", zzdyl.zza(zzebv2, n));
                contentValues.put("value", list.get(n));
                this.zzmgt.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("path", zzdyl.zzc(zzebv2));
        contentValues.put("value", byArray);
        this.zzmgt.insertWithOnConflict("serverCache", null, contentValues, 5);
    }

    /*
     * WARNING - void declaration
     */
    private final zzeio zzb(zzebv zzebv2) {
        String string;
        Object[] objectArray;
        zzebv zzebv3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzebv2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        zzeio zzeio2 = zzeif.zzbyh();
        boolean bl = false;
        HashMap<zzebv, void> hashMap = new HashMap<zzebv, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                zzebv3 = new zzebv(((String)object2).substring(0, ((String)object2).length() - 10));
                int n = zzdyl.zza(zzebv3, arrayList, i);
                if (this.zzmgu.zzbxn()) {
                    objectArray = new Object[]{};
                    string = new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString();
                    this.zzmgu.zzb(string, null, objectArray);
                }
                zzeio zzeio3 = zzdyl.zzam(zzdyl.zzaq(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                zzeio zzeio4 = zzdyl.zzam((byte[])arrayList2.get(i));
                zzebv3 = new zzebv((String)arrayList.get(i));
            }
            if (zzebv3.zzbum() != null && zzebv3.zzbum().zzbxt()) {
                hashMap.put(zzebv3, object);
                continue;
            }
            if (zzebv3.zzi(zzebv2)) {
                zzeke.zzb(!bl, "Descendants of path must come after ancestors.");
                zzeio2 = object.zzan(zzebv.zza(zzebv3, zzebv2));
                continue;
            }
            if (zzebv2.zzi(zzebv3)) {
                bl = true;
                object2 = zzebv.zza(zzebv2, zzebv3);
                zzeio2 = zzeio2.zzl((zzebv)object2, (zzeio)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", zzebv3, zzebv2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            zzebv3 = (zzebv)entry.getKey();
            zzeio2 = zzeio2.zzl(zzebv.zza(zzebv2, zzebv3), (zzeio)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.zzmgu.zzbxn()) {
            objectArray = new Object[]{};
            string = String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), zzejz.zzo(zzeio2), zzebv2, l7, l2, l4, l6);
            this.zzmgu.zzb(string, null, objectArray);
        }
        return zzeio2;
    }

    private static int zza(zzebv zzebv2, List<String> list, int n) {
        int n2;
        String string = zzdyl.zzc(zzebv2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(zzdyl.zza(zzebv2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private final Cursor zza(zzebv zzebv2, String[] stringArray) {
        String[] stringArray2;
        String string = zzdyl.zzc(zzebv2);
        String string2 = zzdyl.zzos(string);
        String[] stringArray3 = stringArray2 = new String[zzebv2.size() + 3];
        zzebv zzebv3 = zzebv2;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!zzebv3.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray3[n] = zzdyl.zzc(zzebv3);
            zzebv3 = zzebv3.zzbul();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray3[n] = zzdyl.zzc(zzebv.zzbug());
        String string3 = String.valueOf(stringBuilder.toString());
        String string4 = String.valueOf(" OR (path > ? AND path < ?)");
        String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        stringArray2[zzebv2.size() + 1] = string;
        stringArray2[zzebv2.size() + 2] = string2;
        String string6 = "path";
        return this.zzmgt.query("serverCache", stringArray, string5, stringArray2, null, null, string6);
    }

    private static String zzc(zzebv zzebv2) {
        if (zzebv2.isEmpty()) {
            return "/";
        }
        return String.valueOf(zzebv2.toString()).concat("/");
    }

    private static String zzos(String string) {
        String string2 = string.substring(0, string.length() - 1);
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private final int zza(String string, zzebv zzebv2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = zzdyl.zzc(zzebv2);
        String string4 = zzdyl.zzos(string3);
        return this.zzmgt.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzf(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / 262144 + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(262144, byArray.length - i * 262144);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * 262144, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private static byte[] zzaq(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private static byte[] zzbd(Object object) {
        try {
            return zzejs.zzbs((Object)object).getBytes(zzfer);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private static zzeio zzam(byte[] byArray) {
        try {
            return zzeir.zza(zzejs.zzpm((String)new String(byArray, zzfer)), zzeif.zzbyh());
        }
        catch (IOException iOException) {
            String string = new String(byArray, zzfer);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private static String zzr(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }
}

