/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzebv;
import com.google.android.gms.internal.zzeep;
import com.google.android.gms.internal.zzehr;
import com.google.android.gms.internal.zzeif;
import com.google.android.gms.internal.zzeio;
import com.google.android.gms.internal.zzeir;
import com.google.android.gms.internal.zzeiu;
import com.google.android.gms.internal.zzeke;
import com.google.firebase.database.DatabaseException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class zzekg {
    private static final Pattern zznak = Pattern.compile("[\\[\\]\\.#$]");
    private static final Pattern zznal = Pattern.compile("[\\[\\]\\.#\\$\\/\\u0000-\\u001F\\u007F]");

    public static void zzpr(String string) throws DatabaseException {
        String string2 = string;
        if (!(!zznak.matcher(string2).find())) {
            throw new DatabaseException(new StringBuilder(101 + String.valueOf(string).length()).append("Invalid Firebase Database path: ").append(string).append(". Firebase Database paths must not contain '.', '#', '$', '[', or ']'").toString());
        }
    }

    public static void zzps(String string) throws DatabaseException {
        if (string.startsWith(".info")) {
            zzekg.zzpr(string.substring(5));
            return;
        }
        if (string.startsWith("/.info")) {
            zzekg.zzpr(string.substring(6));
            return;
        }
        zzekg.zzpr(string);
    }

    public static void zzpt(String string) throws DatabaseException {
        String string2;
        if (string != null && !((string2 = string).equals(".info") || !zznal.matcher(string2).find())) {
            throw new DatabaseException(new StringBuilder(68 + String.valueOf(string).length()).append("Invalid key: ").append(string).append(". Keys must not contain '/', '.', '#', '$', '[', or ']'").toString());
        }
    }

    public static void zzbu(Object object) {
        double d;
        if (object instanceof Map) {
            Map map = (Map)object;
            if (map.containsKey(".sv")) {
                return;
            }
            for (Map.Entry entry : map.entrySet()) {
                String string;
                String string2 = string = (String)entry.getKey();
                if (!(string != null && string2.length() > 0 && (string2.equals(".value") || string2.equals(".priority") || !string2.startsWith(".") && !zznal.matcher(string2).find()))) {
                    throw new DatabaseException(new StringBuilder(68 + String.valueOf(string).length()).append("Invalid key: ").append(string).append(". Keys must not contain '/', '.', '#', '$', '[', or ']'").toString());
                }
                zzekg.zzbu(entry.getValue());
            }
            return;
        }
        if (object instanceof List) {
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                zzekg.zzbu(iterator.next());
            }
            return;
        }
        if ((object instanceof Double || object instanceof Float) && (Double.isInfinite(d = ((Double)object).doubleValue()) || Double.isNaN(d))) {
            throw new DatabaseException("Invalid value: Value cannot be NaN, Inf or -Inf.");
        }
    }

    public static void zzao(zzebv zzebv2) throws DatabaseException {
        zzehr zzehr2 = zzebv2.zzbuj();
        if (!(zzehr2 == null || !zzehr2.asString().startsWith("."))) {
            String string = String.valueOf(zzebv2.toString());
            throw new DatabaseException(string.length() != 0 ? "Invalid write location: ".concat(string) : new String("Invalid write location: "));
        }
    }

    public static Map<zzebv, zzeio> zzb(zzebv zzebv2, Map<String, Object> map) throws DatabaseException {
        String string;
        Object object;
        TreeMap<zzebv, zzeio> treeMap = new TreeMap<zzebv, zzeio>();
        for (Map.Entry<String, Object> object2 : map.entrySet()) {
            Object object3;
            zzebv zzebv3 = new zzebv(object2.getKey());
            object = object2.getValue();
            zzeep.zza(zzebv2.zzh(zzebv3), object);
            string = !zzebv3.isEmpty() ? zzebv3.zzbum().asString() : "";
            if (string.equals(".sv") || string.equals(".value")) {
                object3 = String.valueOf(zzebv3);
                throw new DatabaseException(new StringBuilder(40 + String.valueOf(object3).length() + String.valueOf(string).length()).append("Path '").append((String)object3).append("' contains disallowed child name: ").append(string).toString());
            }
            object3 = string.equals(".priority") ? zzeiu.zzc(zzebv3, object) : zzeir.zza(object, zzeif.zzbyh());
            zzekg.zzbu(object);
            treeMap.put(zzebv3, (zzeio)object3);
        }
        Object object4 = null;
        for (zzebv zzebv3 : treeMap.keySet()) {
            zzeke.zzcm(object4 == null || ((zzebv)object4).zzj(zzebv3) < 0);
            if (object4 != null && ((zzebv)object4).zzi(zzebv3)) {
                object = String.valueOf(object4);
                string = String.valueOf(zzebv3);
                throw new DatabaseException(new StringBuilder(42 + String.valueOf(object).length() + String.valueOf(string).length()).append("Path '").append((String)object).append("' is an ancestor of '").append(string).append("' in an update.").toString());
            }
            object4 = zzebv3;
        }
        return treeMap;
    }
}

