/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzdtf;
import com.google.firebase.database.DatabaseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class DatabaseError {
    public static final int DATA_STALE = -1;
    public static final int OPERATION_FAILED = -2;
    public static final int PERMISSION_DENIED = -3;
    public static final int DISCONNECTED = -4;
    public static final int EXPIRED_TOKEN = -6;
    public static final int INVALID_TOKEN = -7;
    public static final int MAX_RETRIES = -8;
    public static final int OVERRIDDEN_BY_SET = -9;
    public static final int UNAVAILABLE = -10;
    public static final int USER_CODE_EXCEPTION = -11;
    public static final int NETWORK_ERROR = -24;
    public static final int WRITE_CANCELED = -25;
    public static final int UNKNOWN_ERROR = -999;
    private static final Map<Integer, String> zzmey = new HashMap<Integer, String>();
    private static final Map<String, Integer> zzmez;
    private final int code;
    private final String message;
    private final String zzmfa;

    public static DatabaseError zzoq(String string) {
        String string2 = string;
        Integer n = zzmez.get(string2.toLowerCase());
        if (n == null) {
            n = -999;
        }
        String string3 = zzmey.get(n);
        return new DatabaseError(n, string3, null);
    }

    public static DatabaseError zzbc(String string, String string2) {
        String string3 = string2;
        String string4 = string;
        Integer n = zzmez.get(string4.toLowerCase());
        if (n == null) {
            n = -999;
        }
        String string5 = string3 == null ? zzmey.get(n) : string3;
        return new DatabaseError(n, string5, null);
    }

    public static DatabaseError zzgg(int n) {
        if (!zzmey.containsKey(-25)) {
            throw new IllegalArgumentException(new StringBuilder(49).append("Invalid Firebase Database error code: -25").toString());
        }
        String string = zzmey.get(-25);
        return new DatabaseError(-25, string, null);
    }

    public static DatabaseError fromException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        zzdtf.zza((Throwable)throwable, (PrintWriter)printWriter);
        String string = String.valueOf(zzmey.get(-11));
        String string2 = String.valueOf(stringWriter.toString());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        return new DatabaseError(-11, string3);
    }

    private DatabaseError(int n, String string) {
        this(-11, string, null);
    }

    private DatabaseError(int n, String string, String string2) {
        this.code = n;
        this.message = string;
        this.zzmfa = "";
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.zzmfa;
    }

    public String toString() {
        String string = String.valueOf(this.message);
        if (string.length() != 0) {
            return "DatabaseError: ".concat(string);
        }
        return new String("DatabaseError: ");
    }

    public DatabaseException toException() {
        String string = String.valueOf(this.message);
        return new DatabaseException(string.length() != 0 ? "Firebase Database error: ".concat(string) : new String("Firebase Database error: "));
    }

    static {
        zzmey.put(-1, "The transaction needs to be run again with current data");
        zzmey.put(-2, "The server indicated that this operation failed");
        zzmey.put(-3, "This client does not have permission to perform this operation");
        zzmey.put(-4, "The operation had to be aborted due to a network disconnect");
        zzmey.put(-6, "The supplied auth token has expired");
        zzmey.put(-7, "The supplied auth token was invalid");
        zzmey.put(-8, "The transaction had too many retries");
        zzmey.put(-9, "The transaction was overridden by a subsequent set");
        zzmey.put(-10, "The service is unavailable");
        zzmey.put(-11, "User code called from the Firebase Database runloop threw an exception:\n");
        zzmey.put(-24, "The operation could not be performed due to a network error");
        zzmey.put(-25, "The write was canceled by the user.");
        zzmey.put(-999, "An unknown error occurred");
        zzmez = new HashMap<String, Integer>();
        zzmez.put("datastale", -1);
        zzmez.put("failure", -2);
        zzmez.put("permission_denied", -3);
        zzmez.put("disconnected", -4);
        zzmez.put("expired_token", -6);
        zzmez.put("invalid_token", -7);
        zzmez.put("maxretries", -8);
        zzmez.put("overriddenbyset", -9);
        zzmez.put("unavailable", -10);
        zzmez.put("network_error", -24);
        zzmez.put("write_canceled", -25);
    }
}

