/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzebj;
import com.google.android.gms.internal.zzebq;
import com.google.android.gms.internal.zzebv;
import com.google.android.gms.internal.zzeby;
import com.google.android.gms.internal.zzedc;
import com.google.android.gms.internal.zzeep;
import com.google.android.gms.internal.zzehr;
import com.google.android.gms.internal.zzeio;
import com.google.android.gms.internal.zzeir;
import com.google.android.gms.internal.zzeiu;
import com.google.android.gms.internal.zzekb;
import com.google.android.gms.internal.zzekd;
import com.google.android.gms.internal.zzeke;
import com.google.android.gms.internal.zzekg;
import com.google.android.gms.internal.zzekh;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.zzc;
import com.google.firebase.database.zzd;
import com.google.firebase.database.zze;
import com.google.firebase.database.zzf;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzebq zzmfb;

    DatabaseReference(zzeby zzeby2, zzebv zzebv2) {
        super(zzeby2, zzebv2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzmfv.isEmpty()) {
            zzekg.zzps(string);
        } else {
            zzekg.zzpr(string);
        }
        zzebv zzebv2 = this.zzmfv.zzh(new zzebv(string));
        return new DatabaseReference(this.zzmfo, zzebv2);
    }

    public DatabaseReference push() {
        zzehr zzehr2 = zzehr.zzpj(zzekd.zzby(this.zzmfo.zzbup()));
        return new DatabaseReference(this.zzmfo, this.zzmfv.zza(zzehr2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzeiu.zzc(this.zzmfv, null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzeiu.zzc(this.zzmfv, object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzeiu.zzc(this.zzmfv, null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzeiu.zzc(this.zzmfv, object2), completionListener);
    }

    private final Task<Void> zza(Object object, zzeio zzeio2, CompletionListener completionListener) {
        zzekg.zzao(this.zzmfv);
        zzeep.zza(this.zzmfv, object);
        Object object2 = zzekh.zzbv(object);
        zzekg.zzbu(object2);
        zzeio zzeio3 = zzeir.zza(object2, zzeio2);
        zzekb<Task<Void>, CompletionListener> zzekb2 = zzeke.zzb(completionListener);
        this.zzmfo.zzo(new zzc(this, zzeio3, zzekb2));
        return zzekb2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzeiu.zzc(this.zzmfv, object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzeiu.zzc(this.zzmfv, object), completionListener);
    }

    private final Task<Void> zza(zzeio zzeio2, CompletionListener completionListener) {
        zzekg.zzao(this.zzmfv);
        zzekb<Task<Void>, CompletionListener> zzekb2 = zzeke.zzb(completionListener);
        this.zzmfo.zzo(new zzd(this, zzeio2, zzekb2));
        return zzekb2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private final Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<String, Object> map2 = zzekh.zzam(map);
        zzebj zzebj2 = zzebj.zzak(zzekg.zzb(this.zzmfv, map2));
        zzekb<Task<Void>, CompletionListener> zzekb2 = zzeke.zzb(completionListener);
        this.zzmfo.zzo(new zze(this, zzebj2, zzekb2, map2));
        return zzekb2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzekg.zzao(this.zzmfv);
        return new OnDisconnect(this.zzmfo, this.zzmfv);
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(Transaction.Handler handler, boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzekg.zzao(this.zzmfv);
        this.zzmfo.zzo(new zzf(this, handler, bl));
    }

    public static void goOffline() {
        zzedc.zzd(DatabaseReference.zzbqv());
    }

    public static void goOnline() {
        zzedc.zze(DatabaseReference.zzbqv());
    }

    public FirebaseDatabase getDatabase() {
        return this.zzmfo.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzmfo.toString();
        }
        try {
            String string = databaseReference.toString();
            String string2 = URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20");
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzebv zzebv2 = this.zzmfv.zzbul();
        if (zzebv2 != null) {
            return new DatabaseReference(this.zzmfo, zzebv2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzmfo, new zzebv(""));
    }

    public String getKey() {
        if (this.zzmfv.isEmpty()) {
            return null;
        }
        return this.zzmfv.zzbum().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzebq zzbqv() {
        if (zzmfb == null) {
            zzmfb = new zzebq();
        }
        return zzmfb;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

