/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.text.TextUtils;
import com.google.android.gms.internal.zzebq;
import com.google.android.gms.internal.zzebv;
import com.google.android.gms.internal.zzeby;
import com.google.android.gms.internal.zzedb;
import com.google.android.gms.internal.zzedc;
import com.google.android.gms.internal.zzekc;
import com.google.android.gms.internal.zzeke;
import com.google.android.gms.internal.zzekg;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import com.google.firebase.database.zzg;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, Map<zzedb, FirebaseDatabase>> zzmfk = new HashMap<String, Map<zzedb, FirebaseDatabase>>();
    private final FirebaseApp zzmfl;
    private final zzedb zzmfm;
    private final zzebq zzmfn;
    private zzeby zzmfo;

    public static FirebaseDatabase getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static FirebaseDatabase getInstance(String string) {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, string);
    }

    public static FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        Map<zzedb, FirebaseDatabase> map = zzmfk.get(firebaseApp.getName());
        if (map == null) {
            map = new HashMap<zzedb, FirebaseDatabase>();
            zzmfk.put(firebaseApp.getName(), map);
        }
        zzekc zzekc2 = zzeke.zzpn(string);
        if (!zzekc2.zzmfv.isEmpty()) {
            String string2 = zzekc2.zzmfv.toString();
            throw new DatabaseException(new StringBuilder(113 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Specified Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
        }
        FirebaseDatabase firebaseDatabase = map.get(zzekc2.zzmfm);
        if (firebaseDatabase == null) {
            zzebq zzebq2 = new zzebq();
            if (!firebaseApp.zzbox()) {
                zzebq2.zzph(firebaseApp.getName());
            }
            zzebq2.zzd(firebaseApp);
            firebaseDatabase = new FirebaseDatabase(firebaseApp, zzekc2.zzmfm, zzebq2);
            map.put(zzekc2.zzmfm, firebaseDatabase);
        }
        return firebaseDatabase;
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzedb zzedb2, zzebq zzebq2) {
        this.zzmfl = firebaseApp;
        this.zzmfm = zzedb2;
        this.zzmfn = zzebq2;
    }

    public FirebaseApp getApp() {
        return this.zzmfl;
    }

    public DatabaseReference getReference() {
        this.zzbqw();
        return new DatabaseReference(this.zzmfo, zzebv.zzbug());
    }

    public DatabaseReference getReference(String string) {
        this.zzbqw();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzekg.zzps(string);
        zzebv zzebv2 = new zzebv(string);
        return new DatabaseReference(this.zzmfo, zzebv2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzbqw();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzekc zzekc2 = zzeke.zzpn(string);
        if (!zzekc2.zzmfm.host.equals(this.zzmfo.zzbuo().host)) {
            String string2 = this.getReference().toString();
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.zzmfo, zzekc2.zzmfv);
    }

    public void purgeOutstandingWrites() {
        this.zzbqw();
        this.zzmfo.zzo(new zzg(this));
    }

    public void goOnline() {
        this.zzbqw();
        zzedc.zzl(this.zzmfo);
    }

    public void goOffline() {
        this.zzbqw();
        zzedc.zzk(this.zzmfo);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzor("setLogLevel");
        this.zzmfn.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzor("setPersistenceEnabled");
        this.zzmfn.setPersistenceEnabled(bl);
    }

    public synchronized void setPersistenceCacheSizeBytes(long l) {
        this.zzor("setPersistenceCacheSizeBytes");
        this.zzmfn.setPersistenceCacheSizeBytes(l);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private final void zzor(String string) {
        if (this.zzmfo != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private final synchronized void zzbqw() {
        if (this.zzmfo == null) {
            this.zzmfo = zzedc.zza(this.zzmfn, this.zzmfm, this);
        }
    }

    static /* synthetic */ zzeby zza(FirebaseDatabase firebaseDatabase) {
        return firebaseDatabase.zzmfo;
    }
}

