/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzebh;
import com.google.android.gms.internal.zzebs;
import com.google.android.gms.internal.zzebv;
import com.google.android.gms.internal.zzeby;
import com.google.android.gms.internal.zzeeq;
import com.google.android.gms.internal.zzeev;
import com.google.android.gms.internal.zzegs;
import com.google.android.gms.internal.zzegv;
import com.google.android.gms.internal.zzehq;
import com.google.android.gms.internal.zzehr;
import com.google.android.gms.internal.zzeie;
import com.google.android.gms.internal.zzeif;
import com.google.android.gms.internal.zzeii;
import com.google.android.gms.internal.zzeio;
import com.google.android.gms.internal.zzeis;
import com.google.android.gms.internal.zzeit;
import com.google.android.gms.internal.zzeiu;
import com.google.android.gms.internal.zzeiw;
import com.google.android.gms.internal.zzeiy;
import com.google.android.gms.internal.zzeke;
import com.google.android.gms.internal.zzekg;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;
import com.google.firebase.database.zzp;
import com.google.firebase.database.zzq;
import com.google.firebase.database.zzr;
import com.google.firebase.database.zzs;

public class Query {
    protected final zzeby zzmfo;
    protected final zzebv zzmfv;
    private zzegs zzmfz;
    private final boolean zzmga;

    private Query(zzeby zzeby2, zzebv zzebv2, zzegs zzegs2, boolean bl) throws DatabaseException {
        this.zzmfo = zzeby2;
        this.zzmfv = zzebv2;
        this.zzmfz = zzegs2;
        this.zzmga = bl;
        zzegs zzegs3 = zzegs2;
        zzeke.zzb(!zzegs3.zzbwl() || !zzegs3.zzbwo() || !zzegs3.zzbwr() || zzegs3.zzbws(), "Validation of queries failed.");
    }

    Query(zzeby zzeby2, zzebv zzebv2) {
        this.zzmfo = zzeby2;
        this.zzmfv = zzebv2;
        this.zzmfz = zzegs.zzmvh;
        this.zzmga = false;
    }

    private static void zza(zzegs zzegs2) {
        if (zzegs2.zzbwt().equals(zzeii.zzbyn())) {
            zzeio zzeio2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzegs2.zzbwl()) {
                zzeio2 = zzegs2.zzbwm();
                if (zzegs2.zzbwn() != zzehr.zzbxp() || !(zzeio2 instanceof zzeiw)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzegs2.zzbwo()) {
                zzeio2 = zzegs2.zzbwp();
                if (zzegs2.zzbwq() != zzehr.zzbxq() || !(zzeio2 instanceof zzeiw)) {
                    throw new IllegalArgumentException(string);
                }
            }
            return;
        }
        if (zzegs2.zzbwt().equals(zzeit.zzbyr()) && (zzegs2.zzbwl() && !zzeiu.zzl(zzegs2.zzbwm()) || zzegs2.zzbwo() && !zzeiu.zzl(zzegs2.zzbwp()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private static void zzb(zzegs zzegs2) {
        if (zzegs2.zzbwl() && zzegs2.zzbwo() && zzegs2.zzbwr() && !zzegs2.zzbws()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private final void zzbqy() {
        if (this.zzmfz.zzbwl()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.zzmfz.zzbwo()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private final void zzbqz() {
        if (this.zzmga) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzeeq(this.zzmfo, valueEventListener, this.zzbrb()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzebh(this.zzmfo, childEventListener, this.zzbrb()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(ValueEventListener valueEventListener) {
        this.zzb(new zzeeq(this.zzmfo, new zzp(this, valueEventListener), this.zzbrb()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzeeq(this.zzmfo, valueEventListener, this.zzbrb()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzebh(this.zzmfo, childEventListener, this.zzbrb()));
    }

    private final void zza(zzebs zzebs2) {
        zzeev.zzbvh().zzj(zzebs2);
        this.zzmfo.zzo(new zzq(this, zzebs2));
    }

    private final void zzb(zzebs zzebs2) {
        zzeev.zzbvh().zzi(zzebs2);
        this.zzmfo.zzo(new zzr(this, zzebs2));
    }

    public void keepSynced(boolean bl) {
        if (!this.zzmfv.isEmpty() && this.zzmfv.zzbuj().equals(zzehr.zzbxs())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.zzmfo.zzo(new zzs(this, bl));
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzeio zzeio2 = string != null ? new zzeiw(string, zzeif.zzbyh()) : zzeif.zzbyh();
        return this.zza(zzeio2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzeie(d, zzeif.zzbyh()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzehq(bl, zzeif.zzbyh()), string);
    }

    private final Query zza(zzeio zzeio2, String string) {
        zzekg.zzpt(string);
        if (!zzeio2.zzbxw() && !zzeio2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.zzmfz.zzbwl()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzehr zzehr2 = string != null ? zzehr.zzpj(string) : null;
        zzegs zzegs2 = this.zzmfz.zza(zzeio2, zzehr2);
        Query.zzb(zzegs2);
        Query.zza(zzegs2);
        return new Query(this.zzmfo, this.zzmfv, zzegs2, this.zzmga);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzeio zzeio2 = string != null ? new zzeiw(string, zzeif.zzbyh()) : zzeif.zzbyh();
        return this.zzb(zzeio2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzeie(d, zzeif.zzbyh()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzehq(bl, zzeif.zzbyh()), string);
    }

    private final Query zzb(zzeio zzeio2, String string) {
        zzehr zzehr2;
        zzekg.zzpt(string);
        if (!zzeio2.zzbxw() && !zzeio2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzehr zzehr3 = zzehr2 = string != null ? zzehr.zzpj(string) : null;
        if (this.zzmfz.zzbwo()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzegs zzegs2 = this.zzmfz.zzb(zzeio2, zzehr2);
        Query.zzb(zzegs2);
        Query.zza(zzegs2);
        return new Query(this.zzmfo, this.zzmfv, zzegs2, this.zzmga);
    }

    public Query equalTo(String string) {
        this.zzbqy();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzbqy();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzbqy();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzbqy();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzbqy();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzbqy();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzmfz.zzbwr()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzmfo, this.zzmfv, this.zzmfz.zzgi(n), this.zzmga);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzmfz.zzbwr()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzmfo, this.zzmfv, this.zzmfz.zzgj(n), this.zzmga);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzekg.zzpr(string);
        this.zzbqz();
        zzebv zzebv2 = new zzebv(string);
        if (zzebv2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzeis zzeis2 = new zzeis(zzebv2);
        return new Query(this.zzmfo, this.zzmfv, this.zzmfz.zza(zzeis2), true);
    }

    public Query orderByPriority() {
        this.zzbqz();
        zzegs zzegs2 = this.zzmfz.zza(zzeit.zzbyr());
        Query.zza(zzegs2);
        return new Query(this.zzmfo, this.zzmfv, zzegs2, true);
    }

    public Query orderByKey() {
        this.zzbqz();
        zzegs zzegs2 = this.zzmfz.zza(zzeii.zzbyn());
        Query.zza(zzegs2);
        return new Query(this.zzmfo, this.zzmfv, zzegs2, true);
    }

    public Query orderByValue() {
        this.zzbqz();
        return new Query(this.zzmfo, this.zzmfv, this.zzmfz.zza(zzeiy.zzbys()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.zzmfo, this.zzmfv);
    }

    public final zzebv zzbra() {
        return this.zzmfv;
    }

    public final zzegv zzbrb() {
        return new zzegv(this.zzmfv, this.zzmfz);
    }
}

