/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzecw;
import com.google.android.gms.internal.zzedh;
import com.google.android.gms.internal.zzedk;
import com.google.android.gms.internal.zzedn;
import com.google.android.gms.internal.zzegf;
import com.google.android.gms.internal.zzegk;
import com.google.android.gms.internal.zzeih;
import com.google.android.gms.internal.zzeik;
import com.google.android.gms.internal.zzejf;
import com.google.android.gms.internal.zzejg;
import com.google.android.gms.internal.zzejt;
import com.google.android.gms.internal.zzeju;
import com.google.android.gms.internal.zzejx;
import com.google.android.gms.internal.zzekd;
import com.google.android.gms.internal.zzekh;
import com.google.android.gms.internal.zzeki;
import com.google.android.gms.internal.zzekj;
import com.google.android.gms.internal.zzekl;
import com.google.android.gms.internal.zzekn;
import com.google.android.gms.internal.zzelt;
import com.google.android.gms.internal.zzelv;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;
import com.google.firebase.database.zzp;
import com.google.firebase.database.zzq;
import com.google.firebase.database.zzr;
import com.google.firebase.database.zzs;

public class Query {
    protected final zzedn zzmkl;
    protected final zzedk zzmks;
    private zzeih zzmkw;
    private final boolean zzmkx;

    private Query(zzedn zzedn2, zzedk zzedk2, zzeih zzeih2, boolean bl) throws DatabaseException {
        this.zzmkl = zzedn2;
        this.zzmks = zzedk2;
        this.zzmkw = zzeih2;
        this.zzmkx = bl;
        zzeih zzeih3 = zzeih2;
        zzelt.zzb(!zzeih3.zzbyj() || !zzeih3.zzbym() || !zzeih3.zzbyp() || zzeih3.zzbyq(), "Validation of queries failed.");
    }

    Query(zzedn zzedn2, zzedk zzedk2) {
        this.zzmkl = zzedn2;
        this.zzmks = zzedk2;
        this.zzmkw = zzeih.zznae;
        this.zzmkx = false;
    }

    private static void zza(zzeih zzeih2) {
        if (zzeih2.zzbyr().equals(zzejx.zzcal())) {
            zzekd zzekd2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzeih2.zzbyj()) {
                zzekd2 = zzeih2.zzbyk();
                if (zzeih2.zzbyl() != zzejg.zzbzn() || !(zzekd2 instanceof zzekl)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzeih2.zzbym()) {
                zzekd2 = zzeih2.zzbyn();
                if (zzeih2.zzbyo() != zzejg.zzbzo() || !(zzekd2 instanceof zzekl)) {
                    throw new IllegalArgumentException(string);
                }
            }
            return;
        }
        if (zzeih2.zzbyr().equals(zzeki.zzcap()) && (zzeih2.zzbyj() && !zzekj.zzl(zzeih2.zzbyk()) || zzeih2.zzbym() && !zzekj.zzl(zzeih2.zzbyn()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private static void zzb(zzeih zzeih2) {
        if (zzeih2.zzbyj() && zzeih2.zzbym() && zzeih2.zzbyp() && !zzeih2.zzbyq()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private final void zzbsw() {
        if (this.zzmkw.zzbyj()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.zzmkw.zzbym()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private final void zzbsx() {
        if (this.zzmkx) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzegf(this.zzmkl, valueEventListener, this.zzbsz()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzecw(this.zzmkl, childEventListener, this.zzbsz()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(ValueEventListener valueEventListener) {
        this.zzb(new zzegf(this.zzmkl, new zzp(this, valueEventListener), this.zzbsz()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzegf(this.zzmkl, valueEventListener, this.zzbsz()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzecw(this.zzmkl, childEventListener, this.zzbsz()));
    }

    private final void zza(zzedh zzedh2) {
        zzegk.zzbxf().zzj(zzedh2);
        this.zzmkl.zzo(new zzq(this, zzedh2));
    }

    private final void zzb(zzedh zzedh2) {
        zzegk.zzbxf().zzi(zzedh2);
        this.zzmkl.zzo(new zzr(this, zzedh2));
    }

    public void keepSynced(boolean bl) {
        if (!this.zzmks.isEmpty() && this.zzmks.zzbwh().equals(zzejg.zzbzq())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.zzmkl.zzo(new zzs(this, bl));
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzekd zzekd2 = string != null ? new zzekl(string, zzeju.zzcaf()) : zzeju.zzcaf();
        return this.zza(zzekd2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzejt(d, zzeju.zzcaf()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzejf(bl, zzeju.zzcaf()), string);
    }

    private final Query zza(zzekd zzekd2, String string) {
        zzelv.zzqj(string);
        if (!zzekd2.zzbzu() && !zzekd2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.zzmkw.zzbyj()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzejg zzejg2 = string != null ? zzejg.zzpz(string) : null;
        zzeih zzeih2 = this.zzmkw.zza(zzekd2, zzejg2);
        Query.zzb(zzeih2);
        Query.zza(zzeih2);
        return new Query(this.zzmkl, this.zzmks, zzeih2, this.zzmkx);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzekd zzekd2 = string != null ? new zzekl(string, zzeju.zzcaf()) : zzeju.zzcaf();
        return this.zzb(zzekd2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzejt(d, zzeju.zzcaf()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzejf(bl, zzeju.zzcaf()), string);
    }

    private final Query zzb(zzekd zzekd2, String string) {
        zzejg zzejg2;
        zzelv.zzqj(string);
        if (!zzekd2.zzbzu() && !zzekd2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzejg zzejg3 = zzejg2 = string != null ? zzejg.zzpz(string) : null;
        if (this.zzmkw.zzbym()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzeih zzeih2 = this.zzmkw.zzb(zzekd2, zzejg2);
        Query.zzb(zzeih2);
        Query.zza(zzeih2);
        return new Query(this.zzmkl, this.zzmks, zzeih2, this.zzmkx);
    }

    public Query equalTo(String string) {
        this.zzbsw();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzbsw();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzbsw();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzbsw();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzbsw();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzbsw();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzmkw.zzbyp()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzmkl, this.zzmks, this.zzmkw.zzgr(n), this.zzmkx);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzmkw.zzbyp()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzmkl, this.zzmks, this.zzmkw.zzgs(n), this.zzmkx);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzelv.zzqh(string);
        this.zzbsx();
        zzedk zzedk2 = new zzedk(string);
        if (zzedk2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzekh zzekh2 = new zzekh(zzedk2);
        return new Query(this.zzmkl, this.zzmks, this.zzmkw.zza(zzekh2), true);
    }

    public Query orderByPriority() {
        this.zzbsx();
        zzeih zzeih2 = this.zzmkw.zza(zzeki.zzcap());
        Query.zza(zzeih2);
        return new Query(this.zzmkl, this.zzmks, zzeih2, true);
    }

    public Query orderByKey() {
        this.zzbsx();
        zzeih zzeih2 = this.zzmkw.zza(zzejx.zzcal());
        Query.zza(zzeih2);
        return new Query(this.zzmkl, this.zzmks, zzeih2, true);
    }

    public Query orderByValue() {
        this.zzbsx();
        return new Query(this.zzmkl, this.zzmks, this.zzmkw.zza(zzekn.zzcaq()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.zzmkl, this.zzmks);
    }

    public final zzedk zzbsy() {
        return this.zzmks;
    }

    public final zzeik zzbsz() {
        return new zzeik(this.zzmks, this.zzmkw);
    }
}

