/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.text.TextUtils;
import com.google.android.gms.internal.zzegp;
import com.google.android.gms.internal.zzegu;
import com.google.android.gms.internal.zzegx;
import com.google.android.gms.internal.zzeia;
import com.google.android.gms.internal.zzeib;
import com.google.android.gms.internal.zzepb;
import com.google.android.gms.internal.zzepd;
import com.google.android.gms.internal.zzepf;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import com.google.firebase.database.zzg;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, Map<zzeia, FirebaseDatabase>> zza = new HashMap<String, Map<zzeia, FirebaseDatabase>>();
    private final FirebaseApp zzb;
    private final zzeia zzc;
    private final zzegp zzd;
    private zzegx zze;

    public static FirebaseDatabase getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static FirebaseDatabase getInstance(String string) {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(firebaseApp, string);
    }

    public static FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        return FirebaseDatabase.getInstance(firebaseApp, firebaseApp.getOptions().getDatabaseUrl());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        Map<zzeia, FirebaseDatabase> map = zza.get(firebaseApp.getName());
        if (map == null) {
            map = new HashMap<zzeia, FirebaseDatabase>();
            zza.put(firebaseApp.getName(), map);
        }
        zzepb zzepb2 = zzepd.zza(string);
        if (!zzepb2.zzb.zzh()) {
            String string2 = zzepb2.zzb.toString();
            throw new DatabaseException(new StringBuilder(113 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Specified Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
        }
        FirebaseDatabase firebaseDatabase = map.get(zzepb2.zza);
        if (firebaseDatabase == null) {
            zzegp zzegp2 = new zzegp();
            if (!firebaseApp.zzb()) {
                zzegp2.zzc(firebaseApp.getName());
            }
            zzegp2.zza(firebaseApp);
            firebaseDatabase = new FirebaseDatabase(firebaseApp, zzepb2.zza, zzegp2);
            map.put(zzepb2.zza, firebaseDatabase);
        }
        return firebaseDatabase;
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzeia zzeia2, zzegp zzegp2) {
        this.zzb = firebaseApp;
        this.zzc = zzeia2;
        this.zzd = zzegp2;
    }

    public FirebaseApp getApp() {
        return this.zzb;
    }

    public DatabaseReference getReference() {
        this.zza();
        return new DatabaseReference(this.zze, zzegu.zza());
    }

    public DatabaseReference getReference(String string) {
        this.zza();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzepf.zzb(string);
        zzegu zzegu2 = new zzegu(string);
        return new DatabaseReference(this.zze, zzegu2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zza();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzepb zzepb2 = zzepd.zza(string);
        if (!zzepb2.zza.zza.equals(this.zze.zzd().zza)) {
            String string2 = this.getReference().toString();
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.zze, zzepb2.zzb);
    }

    public void purgeOutstandingWrites() {
        this.zza();
        this.zze.zza(new zzg(this));
    }

    public void goOnline() {
        this.zza();
        zzeib.zzb(this.zze);
    }

    public void goOffline() {
        this.zza();
        zzeib.zza(this.zze);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zza("setLogLevel");
        this.zzd.zza(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zza("setPersistenceEnabled");
        this.zzd.zza(bl);
    }

    public synchronized void setPersistenceCacheSizeBytes(long l) {
        this.zza("setPersistenceCacheSizeBytes");
        this.zzd.zza(l);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private final void zza(String string) {
        if (this.zze != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private final synchronized void zza() {
        if (this.zze == null) {
            this.zze = zzeib.zza(this.zzd, this.zzc, this);
        }
    }

    static /* synthetic */ zzegx zza(FirebaseDatabase firebaseDatabase) {
        return firebaseDatabase.zze;
    }
}

