/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import com.google.android.gms.internal.zzedl;
import com.google.android.gms.internal.zzedm;
import com.google.android.gms.internal.zzedn;
import com.google.android.gms.internal.zzegi;
import com.google.android.gms.internal.zzegm;
import com.google.android.gms.internal.zzegu;
import com.google.android.gms.internal.zzejn;
import com.google.android.gms.internal.zzekj;
import com.google.android.gms.internal.zzekk;
import com.google.android.gms.internal.zzeko;
import com.google.android.gms.internal.zzekw;
import com.google.android.gms.internal.zzelr;
import com.google.android.gms.internal.zzelu;
import com.google.android.gms.internal.zzemm;
import com.google.android.gms.internal.zzemq;
import com.google.android.gms.internal.zzems;
import com.google.android.gms.internal.zzene;
import com.google.android.gms.internal.zzenm;
import com.google.android.gms.internal.zzenn;
import com.google.android.gms.internal.zzenq;
import com.google.android.gms.internal.zzeor;
import com.google.android.gms.internal.zzeoy;
import com.google.android.gms.internal.zzepa;
import com.google.android.gms.internal.zzepd;
import com.google.firebase.database.DatabaseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class zzedk
implements zzekj {
    private static final Charset zzfnl = Charset.forName("UTF-8");
    private final SQLiteDatabase zzmxy;
    private final zzemm zzmxz;
    private boolean zzmya;
    private long zzmyb = 0L;

    public zzedk(Context context, zzegm zzegm2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.zzmxz = zzegm2.zzqb("Persistence");
        this.zzmxy = zzedk.zzah(context, string2);
    }

    @Override
    public final void zza(zzegu zzegu2, zzenn zzenn2, long l) {
        this.zzbvo();
        long l2 = System.currentTimeMillis();
        byte[] byArray = zzedk.zzbi(zzenn2.getValue(true));
        this.zza(zzegu2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmxz.zzcbu()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user overwrite in %dms", l3);
            this.zzmxz.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(zzegu zzegu2, zzegi zzegi2, long l) {
        this.zzbvo();
        long l2 = System.currentTimeMillis();
        byte[] byArray = zzedk.zzbi(zzegi2.zzcu(true));
        this.zza(zzegu2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmxz.zzcbu()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user merge in %dms", l3);
            this.zzmxz.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzbm(long l) {
        this.zzbvo();
        long l2 = System.currentTimeMillis();
        int n = this.zzmxy.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmxz.zzcbu()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3);
            this.zzmxz.zzb(string, null, objectArray);
        }
    }

    @Override
    public final List<zzejn> zzbvk() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<zzejn> arrayList = new ArrayList<zzejn>();
        try (Cursor cursor = this.zzmxy.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<zzejn> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                zzejn zzejn2;
                Iterable<zzenm> iterable;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new zzegu(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    ArrayList<byte[]> arrayList3 = new ArrayList<byte[]>();
                    do {
                        arrayList3.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = zzedk.zzat(arrayList3);
                }
                Object object = zzeor.zzqi((String)new String(byArray, zzfnl));
                if ("o".equals(string)) {
                    iterable = zzenq.zza(object, zzene.zzcco());
                    zzejn2 = new zzejn(l2, (zzegu)((Object)arrayList2), (zzenn)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = zzegi.zzam((Map)object);
                    zzejn2 = new zzejn(l2, (zzegu)((Object)arrayList2), (zzegi)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(zzejn2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzmxz.zzcbu()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Loaded %d writes in %dms", arrayList.size(), l2);
                this.zzmxz.zzb(string, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private final void zza(zzegu zzegu2, long l, String string, byte[] byArray) {
        this.zzbvo();
        this.zzmxy.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = zzedk.zzh(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", zzedk.zzc(zzegu2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.zzmxy.insertWithOnConflict("writes", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(l));
        contentValues.put("path", zzedk.zzc(zzegu2));
        contentValues.put("type", string);
        contentValues.put("part", null);
        contentValues.put("node", byArray);
        this.zzmxy.insertWithOnConflict("writes", null, contentValues, 5);
    }

    @Override
    public final zzenn zza(zzegu zzegu2) {
        return this.zzb(zzegu2);
    }

    @Override
    public final void zza(zzegu zzegu2, zzenn zzenn2) {
        this.zzbvo();
        this.zza(zzegu2, zzenn2, false);
    }

    @Override
    public final void zzb(zzegu zzegu2, zzenn zzenn2) {
        this.zzbvo();
        this.zza(zzegu2, zzenn2, true);
    }

    private final void zza(zzegu zzegu2, zzenn zzenn2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", zzegu2);
            n = this.zzc(zzegu2, zzenn2);
        } else {
            n2 = 0;
            n = 0;
            for (zzenm zzenm2 : zzenn2) {
                n2 += this.zza("serverCache", zzegu2.zza(zzenm2.zzccx()));
                n += this.zzc(zzegu2.zza(zzenm2.zzccx()), zzenm2.zzbve());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmxz.zzcbu()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, zzegu2.toString(), l2);
            this.zzmxz.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(zzegu zzegu2, zzegi zzegi2) {
        this.zzbvo();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<zzegu, zzenn> entry : zzegi2) {
            n2 += this.zza("serverCache", zzegu2.zzh(entry.getKey()));
            n += this.zzc(zzegu2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmxz.zzcbu()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, zzegu2.toString(), l2);
            this.zzmxz.zzb(string, null, objectArray);
        }
    }

    @Override
    public final long zzbvl() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.zzmxy.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public final void zza(zzeko zzeko2) {
        this.zzbvo();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zzeko2.id));
        contentValues.put("path", zzedk.zzc(zzeko2.zznkr.zzbvh()));
        contentValues.put("queryParams", zzeko2.zznkr.zzcbh().zzcbf());
        contentValues.put("lastUse", Long.valueOf(zzeko2.zznks));
        contentValues.put("complete", Boolean.valueOf(zzeko2.complete));
        contentValues.put("active", Boolean.valueOf(zzeko2.zzjgp));
        this.zzmxy.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmxz.zzcbu()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Saved new tracked query in %dms", l2);
            this.zzmxz.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzbn(long l) {
        this.zzbvo();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzmxy.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.zzmxy.delete("trackedKeys", string3, new String[]{string});
    }

    @Override
    public final List<zzeko> zzbvm() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zzeko> arrayList = new ArrayList<zzeko>();
        try (Cursor cursor = this.zzmxy.query("trackedQueries", stringArray, null, null, null, null, "id");){
            Object[] objectArray;
            Object object;
            ArrayList<zzeko> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new zzegu(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = zzeor.zzqh((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                object = map;
                ArrayList<zzeko> arrayList3 = arrayList2;
                objectArray = zzelr.zzao((Map<String, Object>)object);
                zzelu zzelu2 = new zzelu((zzegu)((Object)arrayList3), (zzelr)objectArray);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zzeko zzeko2 = new zzeko(l2, zzelu2, l3, bl, bl2);
                arrayList.add(zzeko2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzmxz.zzcbu()) {
                objectArray = new Object[]{};
                object = String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2);
                this.zzmxz.zzb((String)object, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public final void zzbo(long l) {
        this.zzbvo();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.zzmxy.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmxz.zzcbu()) {
            Object[] objectArray = new Object[]{};
            String string2 = String.format("Reset active tracked queries in %dms", l3);
            this.zzmxz.zzb(string2, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<zzemq> set) {
        this.zzbvo();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzmxy.delete("trackedKeys", string2, new String[]{string});
        for (zzemq zzemq2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzemq2.asString());
            this.zzmxy.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmxz.zzcbu()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3);
            this.zzmxz.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<zzemq> set, Set<zzemq> set2) {
        this.zzbvo();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (zzemq zzemq2 : set2) {
            this.zzmxy.delete("trackedKeys", string, new String[]{string2, zzemq2.asString()});
        }
        for (zzemq zzemq2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzemq2.asString());
            this.zzmxy.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmxz.zzcbu()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3);
            this.zzmxz.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final Set<zzemq> zzbp(long l) {
        return this.zzg(Collections.singleton(l));
    }

    @Override
    public final Set<zzemq> zzg(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = zzedk.zzr(set);
        String string2 = new StringBuilder(8 + String.valueOf(string).length()).append("id IN (").append(string).append(")").toString();
        string = this.zzmxy.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        HashSet<zzemq> hashSet = new HashSet<zzemq>();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                hashSet.add(zzemq.zzqf(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.zzmxz.zzcbu()) {
                Object[] objectArray = new Object[]{};
                String string4 = String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", hashSet.size(), set.toString(), l2);
                this.zzmxz.zzb(string4, null, objectArray);
            }
            HashSet<zzemq> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public final void zza(zzegu zzegu2, zzekk zzekk2) {
        String string;
        String string2;
        String string3;
        Iterable<Object> iterable;
        Iterable<zzemq> iterable2;
        if (!zzekk2.zzcab()) {
            return;
        }
        this.zzbvo();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzegu2, new String[]{"rowid", "path"});
        zzekw<Object> zzekw2 = new zzekw<Object>(null);
        zzekw<Object> zzekw3 = new zzekw<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new zzegu(cursor.getString(1));
            if (!zzegu2.zzi((zzegu)iterable2)) {
                iterable = String.valueOf(zzegu2);
                string3 = String.valueOf(iterable2);
                string2 = new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string3).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string3).append(". Ignoring.").toString();
                this.zzmxz.zzf(string2, null);
                continue;
            }
            iterable = zzegu.zza(zzegu2, (zzegu)iterable2);
            if (zzekk2.zzv((zzegu)iterable)) {
                zzekw2 = zzekw2.zzb((zzegu)iterable, l2);
                continue;
            }
            if (zzekk2.zzw((zzegu)iterable)) {
                zzekw3 = zzekw3.zzb((zzegu)iterable, l2);
                continue;
            }
            string3 = String.valueOf(zzegu2);
            string = String.valueOf(iterable2);
            string2 = new StringBuilder(88 + String.valueOf(string3).length() + String.valueOf(string).length()).append("We are pruning at ").append(string3).append(" and have data at ").append(string).append(" that isn't marked for pruning or keeping. Ignoring.").toString();
            this.zzmxz.zzf(string2, null);
        }
        int n = 0;
        int n2 = 0;
        if (!zzekw2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(zzegu2, zzegu.zzbyn(), zzekw2, zzekw3, zzekk2, (List<zzepa<zzegu, zzenn>>)iterable2);
            iterable = zzekw2.values();
            string = zzedk.zzr(iterable);
            string3 = new StringBuilder(11 + String.valueOf(string).length()).append("rowid IN (").append(string).append(")").toString();
            this.zzmxy.delete("serverCache", string3, null);
            ArrayList arrayList = (ArrayList)iterable2;
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList.get(i);
                zzepa zzepa2 = (zzepa)e;
                this.zzc(zzegu2.zzh((zzegu)zzepa2.getFirst()), (zzenn)zzepa2.zzcdp());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.zzmxz.zzcbu()) {
            Object[] objectArray = new Object[]{};
            string2 = String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3);
            this.zzmxz.zzb(string2, null, objectArray);
        }
    }

    private final void zza(zzegu zzegu2, zzegu zzegu3, zzekw<Long> zzekw2, zzekw<Long> zzekw3, zzekk zzekk2, List<zzepa<zzegu, zzenn>> list) {
        if (zzekw2.getValue() != null) {
            int n = zzekk2.zza(0, new zzedl(this, zzekw3));
            if (n > 0) {
                zzegu zzegu4 = zzegu2.zzh(zzegu3);
                if (this.zzmxz.zzcbu()) {
                    Object[] objectArray = new Object[]{};
                    String string = String.format("Need to rewrite %d nodes below path %s", n, zzegu4);
                    this.zzmxz.zzb(string, null, objectArray);
                }
                zzenn zzenn2 = this.zzb(zzegu4);
                zzekk2.zza(null, new zzedm(this, zzekw3, list, zzegu3, zzenn2));
            }
            return;
        }
        for (Map.Entry entry : zzekw2.zzcag()) {
            zzemq zzemq2 = (zzemq)entry.getKey();
            zzekk zzekk3 = zzekk2.zzd((zzemq)entry.getKey());
            this.zza(zzegu2, zzegu3.zza(zzemq2), (zzekw)entry.getValue(), zzekw3.zze(zzemq2), zzekk3, list);
        }
    }

    @Override
    public final void zzbvn() {
        this.zzbvo();
        long l = System.currentTimeMillis();
        int n = this.zzmxy.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmxz.zzcbu()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d (all) write(s) in %dms", n, l2);
            this.zzmxz.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void beginTransaction() {
        zzepd.zzb(!this.zzmya, "runInTransaction called when an existing transaction is already in progress.");
        if (this.zzmxz.zzcbu()) {
            Object[] objectArray = new Object[]{};
            String string = "Starting transaction.";
            this.zzmxz.zzb("Starting transaction.", null, objectArray);
        }
        this.zzmxy.beginTransaction();
        this.zzmya = true;
        this.zzmyb = System.currentTimeMillis();
    }

    @Override
    public final void endTransaction() {
        this.zzmxy.endTransaction();
        this.zzmya = false;
        long l = System.currentTimeMillis() - this.zzmyb;
        if (this.zzmxz.zzcbu()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Transaction completed. Elapsed: %dms", l);
            this.zzmxz.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void setTransactionSuccessful() {
        this.zzmxy.setTransactionSuccessful();
    }

    private static SQLiteDatabase zzah(Context context, String string) {
        zzedn zzedn2 = new zzedn(context, string);
        try {
            SQLiteDatabase sQLiteDatabase = zzedn2.getWritableDatabase();
            sQLiteDatabase.rawQuery("PRAGMA locking_mode = EXCLUSIVE", null).close();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.endTransaction();
            return sQLiteDatabase;
        }
        catch (SQLiteException sQLiteException) {
            SQLiteException sQLiteException2 = sQLiteException;
            if (sQLiteException instanceof SQLiteDatabaseLockedException) {
                String string2 = "Failed to gain exclusive lock to Firebase Database's offline persistence. This generally means you are using Firebase Database from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing FirebaseDatabase in your Application class. If you are intentionally using Firebase Database from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.";
                throw new DatabaseException(string2, sQLiteException2);
            }
            throw sQLiteException2;
        }
    }

    private final void zzbvo() {
        zzepd.zzb(this.zzmya, "Transaction expected to already be in progress.");
    }

    private final int zzc(zzegu zzegu2, zzenn zzenn2) {
        long l = zzeoy.zzn(zzenn2);
        if (zzenn2 instanceof zzems && l > 16384L) {
            if (this.zzmxz.zzcbu()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", zzegu2, l, 16384);
                this.zzmxz.zzb(string, null, objectArray);
            }
            int n = 0;
            for (zzenm zzenm2 : zzenn2) {
                n += this.zzc(zzegu2.zza(zzenm2.zzccx()), zzenm2.zzbve());
            }
            if (!zzenn2.zzcce().isEmpty()) {
                this.zzd(zzegu2.zza(zzemq.zzcby()), zzenn2.zzcce());
                ++n;
            }
            this.zzd(zzegu2, zzene.zzcco());
            return ++n;
        }
        this.zzd(zzegu2, zzenn2);
        return 1;
    }

    private static String zza(zzegu zzegu2, int n) {
        String string = String.valueOf(zzedk.zzc(zzegu2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        if (string2.length() != 0) {
            return string.concat(string2);
        }
        return new String(string);
    }

    private final void zzd(zzegu zzegu2, zzenn zzenn2) {
        byte[] byArray = zzedk.zzbi(zzenn2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = zzedk.zzh(byArray, 262144);
            if (this.zzmxz.zzcbu()) {
                n = list.size();
                Object[] objectArray = new Object[]{};
                String string = new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString();
                this.zzmxz.zzb(string, null, objectArray);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", zzedk.zza(zzegu2, n));
                contentValues.put("value", list.get(n));
                this.zzmxy.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("path", zzedk.zzc(zzegu2));
        contentValues.put("value", byArray);
        this.zzmxy.insertWithOnConflict("serverCache", null, contentValues, 5);
    }

    /*
     * WARNING - void declaration
     */
    private final zzenn zzb(zzegu zzegu2) {
        String string;
        Object[] objectArray;
        zzegu zzegu3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzegu2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        zzenn zzenn2 = zzene.zzcco();
        boolean bl = false;
        HashMap<zzegu, void> hashMap = new HashMap<zzegu, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                zzegu3 = new zzegu(((String)object2).substring(0, ((String)object2).length() - 10));
                int n = zzedk.zza(zzegu3, arrayList, i);
                if (this.zzmxz.zzcbu()) {
                    objectArray = new Object[]{};
                    string = new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString();
                    this.zzmxz.zzb(string, null, objectArray);
                }
                zzenn zzenn3 = zzedk.zzan(zzedk.zzat(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                zzenn zzenn4 = zzedk.zzan((byte[])arrayList2.get(i));
                zzegu3 = new zzegu((String)arrayList.get(i));
            }
            if (zzegu3.zzbyt() != null && zzegu3.zzbyt().zzcca()) {
                hashMap.put(zzegu3, object);
                continue;
            }
            if (zzegu3.zzi(zzegu2)) {
                zzepd.zzb(!bl, "Descendants of path must come after ancestors.");
                zzenn2 = object.zzan(zzegu.zza(zzegu3, zzegu2));
                continue;
            }
            if (zzegu2.zzi(zzegu3)) {
                bl = true;
                object2 = zzegu.zza(zzegu2, zzegu3);
                zzenn2 = zzenn2.zzl((zzegu)object2, (zzenn)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", zzegu3, zzegu2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            zzegu3 = (zzegu)entry.getKey();
            zzenn2 = zzenn2.zzl(zzegu.zza(zzegu2, zzegu3), (zzenn)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.zzmxz.zzcbu()) {
            objectArray = new Object[]{};
            string = String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), zzeoy.zzo(zzenn2), zzegu2, l7, l2, l4, l6);
            this.zzmxz.zzb(string, null, objectArray);
        }
        return zzenn2;
    }

    private static int zza(zzegu zzegu2, List<String> list, int n) {
        int n2;
        String string = zzedk.zzc(zzegu2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(zzedk.zza(zzegu2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private final Cursor zza(zzegu zzegu2, String[] stringArray) {
        String[] stringArray2;
        String string = zzedk.zzc(zzegu2);
        String string2 = zzedk.zzpo(string);
        String[] stringArray3 = stringArray2 = new String[zzegu2.size() + 3];
        zzegu zzegu3 = zzegu2;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!zzegu3.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray3[n] = zzedk.zzc(zzegu3);
            zzegu3 = zzegu3.zzbys();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray3[n] = zzedk.zzc(zzegu.zzbyn());
        String string3 = String.valueOf(stringBuilder.toString());
        String string4 = String.valueOf(" OR (path > ? AND path < ?)");
        String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        stringArray2[zzegu2.size() + 1] = string;
        stringArray2[zzegu2.size() + 2] = string2;
        String string6 = "path";
        return this.zzmxy.query("serverCache", stringArray, string5, stringArray2, null, null, string6);
    }

    private static String zzc(zzegu zzegu2) {
        if (zzegu2.isEmpty()) {
            return "/";
        }
        return String.valueOf(zzegu2.toString()).concat("/");
    }

    private static String zzpo(String string) {
        String string2 = string.substring(0, string.length() - 1);
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private final int zza(String string, zzegu zzegu2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = zzedk.zzc(zzegu2);
        String string4 = zzedk.zzpo(string3);
        return this.zzmxy.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzh(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / 262144 + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(262144, byArray.length - i * 262144);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * 262144, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private static byte[] zzat(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private static byte[] zzbi(Object object) {
        try {
            return zzeor.zzbx((Object)object).getBytes(zzfnl);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private static zzenn zzan(byte[] byArray) {
        try {
            return zzenq.zza(zzeor.zzqi((String)new String(byArray, zzfnl)), zzene.zzcco());
        }
        catch (IOException iOException) {
            String string = new String(byArray, zzfnl);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private static String zzr(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }
}

