/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzegu;
import com.google.android.gms.internal.zzeng;
import com.google.android.gms.internal.zzenm;
import com.google.android.gms.internal.zzenn;
import com.google.android.gms.internal.zzepf;
import com.google.android.gms.internal.zzepg;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.GenericTypeIndicator;
import com.google.firebase.database.zza;
import java.util.Iterator;

public class DataSnapshot {
    private final zzeng zzmvy;
    private final DatabaseReference zzmvz;

    DataSnapshot(DatabaseReference databaseReference, zzeng zzeng2) {
        this.zzmvy = zzeng2;
        this.zzmvz = databaseReference;
    }

    public DataSnapshot child(String string) {
        DatabaseReference databaseReference = this.zzmvz.child(string);
        zzenn zzenn2 = this.zzmvy.zzbve().zzan(new zzegu(string));
        return new DataSnapshot(databaseReference, zzeng.zzj(zzenn2));
    }

    public boolean hasChild(String string) {
        if (this.zzmvz.getParent() == null) {
            zzepf.zzqo(string);
        } else {
            zzepf.zzqn(string);
        }
        return !this.zzmvy.zzbve().zzan(new zzegu(string)).isEmpty();
    }

    public boolean hasChildren() {
        return this.zzmvy.zzbve().getChildCount() > 0;
    }

    public boolean exists() {
        return !this.zzmvy.zzbve().isEmpty();
    }

    @Nullable
    public Object getValue() {
        return this.zzmvy.zzbve().getValue();
    }

    @Nullable
    public Object getValue(boolean bl) {
        return this.zzmvy.zzbve().getValue(bl);
    }

    @Nullable
    public <T> T getValue(Class<T> clazz) {
        return zzepg.zza(this.zzmvy.zzbve().getValue(), clazz);
    }

    @Nullable
    public <T> T getValue(GenericTypeIndicator<T> genericTypeIndicator) {
        return zzepg.zza(this.zzmvy.zzbve().getValue(), genericTypeIndicator);
    }

    public long getChildrenCount() {
        return this.zzmvy.zzbve().getChildCount();
    }

    public DatabaseReference getRef() {
        return this.zzmvz;
    }

    public String getKey() {
        return this.zzmvz.getKey();
    }

    public Iterable<DataSnapshot> getChildren() {
        Iterator<zzenm> iterator = this.zzmvy.iterator();
        return new zza(this, iterator);
    }

    public Object getPriority() {
        Object object = this.zzmvy.zzbve().zzcce().getValue();
        if (object instanceof Long) {
            return (double)((Long)object).longValue();
        }
        return object;
    }

    public String toString() {
        String string = this.zzmvz.getKey();
        String string2 = String.valueOf(this.zzmvy.zzbve().getValue(true));
        return new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length()).append("DataSnapshot { key = ").append(string).append(", value = ").append(string2).append(" }").toString();
    }

    static /* synthetic */ DatabaseReference zza(DataSnapshot dataSnapshot) {
        return dataSnapshot.zzmvz;
    }
}

