/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabaseComponent;
import com.google.firebase.database.Logger;
import com.google.firebase.database.core.DatabaseConfig;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.Repo;
import com.google.firebase.database.core.RepoInfo;
import com.google.firebase.database.core.RepoManager;
import com.google.firebase.database.core.utilities.ParsedUrl;
import com.google.firebase.database.core.utilities.Utilities;
import com.google.firebase.database.core.utilities.Validation;

@PublicApi
public class FirebaseDatabase {
    private static final String SDK_VERSION = "3.0.0";
    private final FirebaseApp app;
    private final RepoInfo repoInfo;
    private final DatabaseConfig config;
    private Repo repo;

    @NonNull
    @PublicApi
    public static FirebaseDatabase getInstance() {
        FirebaseApp instance = FirebaseApp.getInstance();
        if (instance == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(instance, instance.getOptions().getDatabaseUrl());
    }

    @NonNull
    @PublicApi
    public static FirebaseDatabase getInstance(@NonNull String url) {
        FirebaseApp instance = FirebaseApp.getInstance();
        if (instance == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(instance, url);
    }

    @NonNull
    @PublicApi
    public static FirebaseDatabase getInstance(@NonNull FirebaseApp app) {
        return FirebaseDatabase.getInstance(app, app.getOptions().getDatabaseUrl());
    }

    @NonNull
    @PublicApi
    public static synchronized FirebaseDatabase getInstance(@NonNull FirebaseApp app, @NonNull String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        ParsedUrl parsedUrl = Utilities.parseUrl(url);
        if (!parsedUrl.path.isEmpty()) {
            throw new DatabaseException("Specified Database URL '" + url + "' is invalid. It should point to the root of a Firebase Database but it includes a path: " + parsedUrl.path.toString());
        }
        Preconditions.checkNotNull((Object)app, (Object)"Provided FirebaseApp must not be null.");
        FirebaseDatabaseComponent component = (FirebaseDatabaseComponent)app.get(FirebaseDatabaseComponent.class);
        Preconditions.checkNotNull((Object)component, (Object)"Firebase Database component is not present.");
        return component.get(parsedUrl.repoInfo);
    }

    static FirebaseDatabase createForTests(FirebaseApp app, RepoInfo repoInfo, DatabaseConfig config) {
        FirebaseDatabase db = new FirebaseDatabase(app, repoInfo, config);
        db.ensureRepo();
        return db;
    }

    FirebaseDatabase(FirebaseApp app, RepoInfo repoInfo, DatabaseConfig config) {
        this.app = app;
        this.repoInfo = repoInfo;
        this.config = config;
    }

    @NonNull
    @PublicApi
    public FirebaseApp getApp() {
        return this.app;
    }

    @NonNull
    @PublicApi
    public DatabaseReference getReference() {
        this.ensureRepo();
        return new DatabaseReference(this.repo, Path.getEmptyPath());
    }

    @NonNull
    @PublicApi
    public DatabaseReference getReference(@NonNull String path) {
        this.ensureRepo();
        if (path == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        Validation.validateRootPathString(path);
        Path childPath = new Path(path);
        return new DatabaseReference(this.repo, childPath);
    }

    @NonNull
    @PublicApi
    public DatabaseReference getReferenceFromUrl(@NonNull String url) {
        this.ensureRepo();
        if (url == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        ParsedUrl parsedUrl = Utilities.parseUrl(url);
        if (!parsedUrl.repoInfo.host.equals(this.repo.getRepoInfo().host)) {
            throw new DatabaseException("Invalid URL (" + url + ") passed to getReference().  URL was expected to match configured Database URL: " + this.getReference().toString());
        }
        return new DatabaseReference(this.repo, parsedUrl.path);
    }

    @PublicApi
    public void purgeOutstandingWrites() {
        this.ensureRepo();
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                FirebaseDatabase.this.repo.purgeOutstandingWrites();
            }
        });
    }

    @PublicApi
    public void goOnline() {
        this.ensureRepo();
        RepoManager.resume(this.repo);
    }

    @PublicApi
    public void goOffline() {
        this.ensureRepo();
        RepoManager.interrupt(this.repo);
    }

    @PublicApi
    public synchronized void setLogLevel(@NonNull Logger.Level logLevel) {
        this.assertUnfrozen("setLogLevel");
        this.config.setLogLevel(logLevel);
    }

    @PublicApi
    public synchronized void setPersistenceEnabled(boolean isEnabled) {
        this.assertUnfrozen("setPersistenceEnabled");
        this.config.setPersistenceEnabled(isEnabled);
    }

    @PublicApi
    public synchronized void setPersistenceCacheSizeBytes(long cacheSizeInBytes) {
        this.assertUnfrozen("setPersistenceCacheSizeBytes");
        this.config.setPersistenceCacheSizeBytes(cacheSizeInBytes);
    }

    @NonNull
    @PublicApi
    public static String getSdkVersion() {
        return SDK_VERSION;
    }

    private void assertUnfrozen(String methodCalled) {
        if (this.repo != null) {
            throw new DatabaseException("Calls to " + methodCalled + "() must be made before any other usage of FirebaseDatabase instance.");
        }
    }

    private synchronized void ensureRepo() {
        if (this.repo == null) {
            this.repo = RepoManager.createRepo(this.config, this.repoInfo, this);
        }
    }

    DatabaseConfig getConfig() {
        return this.config;
    }
}

