/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.android;

import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.internal.IdTokenListener;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.database.android.AndroidAuthTokenProvider$1$$Lambda$1;
import com.google.firebase.database.android.AndroidAuthTokenProvider$1$$Lambda$2;
import com.google.firebase.database.android.AndroidAuthTokenProvider$1$$Lambda$3;
import com.google.firebase.database.android.AndroidAuthTokenProvider$1$$Lambda$4;
import com.google.firebase.database.android.AndroidAuthTokenProvider$2$$Lambda$1;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.internal.InternalTokenResult;
import com.google.firebase.internal.api.FirebaseNoSignedInUserException;
import java.util.concurrent.ExecutorService;

public abstract class AndroidAuthTokenProvider
implements AuthTokenProvider {
    public static AuthTokenProvider forAuthenticatedAccess(final @NonNull InternalAuthProvider authProvider) {
        return new AuthTokenProvider(){

            @Override
            public void getToken(boolean forceRefresh, @NonNull AuthTokenProvider.GetTokenCompletionListener listener) {
                Task getTokenResult = authProvider.getAccessToken(forceRefresh);
                getTokenResult.addOnSuccessListener(AndroidAuthTokenProvider$1$$Lambda$1.lambdaFactory$(listener)).addOnFailureListener(AndroidAuthTokenProvider$1$$Lambda$2.lambdaFactory$(listener));
            }

            @Override
            public void addTokenChangeListener(ExecutorService executorService, AuthTokenProvider.TokenChangeListener tokenListener) {
                IdTokenListener idTokenListener = AndroidAuthTokenProvider$1$$Lambda$3.lambdaFactory$(executorService, tokenListener);
                authProvider.addIdTokenListener(idTokenListener);
            }

            @Override
            public void removeTokenChangeListener(AuthTokenProvider.TokenChangeListener tokenListener) {
            }

            static /* synthetic */ void lambda$addTokenChangeListener$3(ExecutorService executorService, AuthTokenProvider.TokenChangeListener tokenListener, InternalTokenResult tokenResult) {
                executorService.execute(AndroidAuthTokenProvider$1$$Lambda$4.lambdaFactory$(tokenListener, tokenResult));
            }

            static /* synthetic */ void lambda$addTokenChangeListener$2(AuthTokenProvider.TokenChangeListener tokenListener, InternalTokenResult tokenResult) {
                tokenListener.onTokenChange(tokenResult.getToken());
            }

            static /* synthetic */ void lambda$getToken$1(AuthTokenProvider.GetTokenCompletionListener listener, Exception e) {
                if (AndroidAuthTokenProvider.isUnauthenticatedUsage(e)) {
                    listener.onSuccess(null);
                } else {
                    listener.onError(e.getMessage());
                }
            }

            static /* synthetic */ void lambda$getToken$0(AuthTokenProvider.GetTokenCompletionListener listener, GetTokenResult result) {
                listener.onSuccess(result.getToken());
            }
        };
    }

    public static AuthTokenProvider forUnauthenticatedAccess() {
        return new AuthTokenProvider(){

            @Override
            public void getToken(boolean forceRefresh, AuthTokenProvider.GetTokenCompletionListener listener) {
                listener.onSuccess(null);
            }

            @Override
            public void addTokenChangeListener(ExecutorService executorService, AuthTokenProvider.TokenChangeListener listener) {
                executorService.execute(AndroidAuthTokenProvider$2$$Lambda$1.lambdaFactory$(listener));
            }

            @Override
            public void removeTokenChangeListener(AuthTokenProvider.TokenChangeListener listener) {
            }

            static /* synthetic */ void lambda$addTokenChangeListener$0(AuthTokenProvider.TokenChangeListener listener) {
                listener.onTokenChange(null);
            }
        };
    }

    private static boolean isUnauthenticatedUsage(Exception e) {
        return e instanceof FirebaseApiNotAvailableException || e instanceof FirebaseNoSignedInUserException;
    }
}

