/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.google.android.gms.internal.zzaes;
import com.google.android.gms.internal.zzaeu;
import com.google.android.gms.internal.zzafa;
import com.google.android.gms.internal.zzafn;
import com.google.android.gms.internal.zzage;
import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzagg;
import com.google.android.gms.internal.zzagi;
import com.google.android.gms.internal.zzagu;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzahj;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzaht;
import com.google.android.gms.internal.zzahu;
import com.google.android.gms.internal.zzahv;
import com.google.android.gms.internal.zzaim;
import com.google.android.gms.internal.zzaiq;
import com.google.android.gms.internal.zzais;
import com.google.android.gms.internal.zzaiv;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class zzadq
implements zzage {
    private static final Charset zzaiI = Charset.forName("UTF-8");
    private final SQLiteDatabase zzbHU;
    private final zzahf zzbHV;
    private boolean zzbHW;
    private long zzbHX = 0L;

    public zzadq(Context context, zzaeu zzaeu2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        zza zza2 = new zza(context, string2);
        this.zzbHU = zza2.getWritableDatabase();
        this.zzbHV = zzaeu2.zzib("Persistence");
    }

    @Override
    public void zza(zzafa zzafa2, zzahu zzahu2, long l) {
        this.zzPt();
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.zzac(zzahu2.getValue(true));
        this.zza(zzafa2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh(String.format("Persisted user overwrite in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zza(zzafa zzafa2, zzaes zzaes2, long l) {
        this.zzPt();
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.zzac(zzaes2.zzaQ(true));
        this.zza(zzafa2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh(String.format("Persisted user merge in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zzat(long l) {
        this.zzPt();
        long l2 = System.currentTimeMillis();
        int n = this.zzbHU.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh(String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3), new Object[0]);
        }
    }

    @Override
    public List<zzafn> zzPp() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<zzafn> arrayList = new ArrayList<zzafn>();
        try (Cursor cursor = this.zzbHU.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<zzafn> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                zzafn zzafn2;
                Iterable<zzaht> iterable;
                Object object;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new zzafa(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    object = new ArrayList<byte[]>();
                    do {
                        object.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = this.zzO((List<byte[]>)object);
                }
                object = new String(byArray, zzaiI);
                Object object2 = zzaim.zzik((String)object);
                if ("o".equals(string)) {
                    iterable = zzahv.zzaq(object2);
                    zzafn2 = new zzafn(l2, (zzafa)((Object)arrayList2), (zzahu)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = zzaes.zzax((Map)object2);
                    zzafn2 = new zzafn(l2, (zzafa)((Object)arrayList2), (zzaes)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(zzafn2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzbHV.zzTe()) {
                this.zzbHV.zzh(String.format("Loaded %d writes in %dms", arrayList.size(), l2), new Object[0]);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private void zza(zzafa zzafa2, long l, String string, byte[] byArray) {
        this.zzPt();
        this.zzbHU.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = zzadq.zzb(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", zzadq.zzc(zzafa2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.zzbHU.insertWithOnConflict("writes", null, contentValues, 5);
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("path", zzadq.zzc(zzafa2));
            contentValues.put("type", string);
            contentValues.put("part", null);
            contentValues.put("node", byArray);
            this.zzbHU.insertWithOnConflict("writes", null, contentValues, 5);
        }
    }

    @Override
    public zzahu zza(zzafa zzafa2) {
        return this.zzb(zzafa2);
    }

    @Override
    public void zza(zzafa zzafa2, zzahu zzahu2) {
        this.zzPt();
        this.zza(zzafa2, zzahu2, false);
    }

    @Override
    public void zzb(zzafa zzafa2, zzahu zzahu2) {
        this.zzPt();
        this.zza(zzafa2, zzahu2, true);
    }

    private void zza(zzafa zzafa2, zzahu zzahu2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", zzafa2);
            n = this.zzc(zzafa2, zzahu2);
        } else {
            n2 = 0;
            n = 0;
            for (zzaht zzaht2 : zzahu2) {
                n2 += this.zza("serverCache", zzafa2.zza(zzaht2.zzTK()));
                n += this.zzc(zzafa2.zza(zzaht2.zzTK()), zzaht2.zzPj());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh(String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, zzafa2.toString(), l2), new Object[0]);
        }
    }

    @Override
    public void zza(zzafa zzafa2, zzaes zzaes2) {
        this.zzPt();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<zzafa, zzahu> entry : zzaes2) {
            n2 += this.zza("serverCache", zzafa2.zzh(entry.getKey()));
            n += this.zzc(zzafa2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh(String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, zzafa2.toString(), l2), new Object[0]);
        }
    }

    @Override
    public long zzPq() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.zzbHU.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public void zza(zzagg zzagg2) {
        this.zzPt();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zzagg2.id));
        contentValues.put("path", zzadq.zzc(zzagg2.zzbOQ.zzPn()));
        contentValues.put("queryParams", zzagg2.zzbOQ.zzSR().zzSP());
        contentValues.put("lastUse", Long.valueOf(zzagg2.zzbOR));
        contentValues.put("complete", Boolean.valueOf(zzagg2.zzbOS));
        contentValues.put("active", Boolean.valueOf(zzagg2.zzbOT));
        this.zzbHU.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh(String.format("Saved new tracked query in %dms", l2), new Object[0]);
        }
    }

    @Override
    public void zzau(long l) {
        this.zzPt();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzbHU.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.zzbHU.delete("trackedKeys", string3, new String[]{string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<zzagg> zzPr() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zzagg> arrayList = new ArrayList<zzagg>();
        try (Cursor cursor = this.zzbHU.query("trackedQueries", stringArray, null, null, null, null, "id");){
            ArrayList<zzagg> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new zzafa(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = zzaim.zzij((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                zzagu zzagu2 = zzagu.zzb(arrayList2, map);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zzagg zzagg2 = new zzagg(l2, zzagu2, l3, bl, bl2);
                arrayList.add(zzagg2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzbHV.zzTe()) {
                this.zzbHV.zzh(String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2), new Object[0]);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public void zzav(long l) {
        this.zzPt();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.zzbHU.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh(String.format("Reset active tracked queries in %dms", l3), new Object[0]);
        }
    }

    @Override
    public void zza(long l, Set<zzahi> set) {
        this.zzPt();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzbHU.delete("trackedKeys", string2, new String[]{string});
        for (zzahi zzahi2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzahi2.asString());
            this.zzbHU.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh(String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3), new Object[0]);
        }
    }

    @Override
    public void zza(long l, Set<zzahi> set, Set<zzahi> set2) {
        this.zzPt();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (zzahi zzahi2 : set2) {
            this.zzbHU.delete("trackedKeys", string, new String[]{string2, zzahi2.asString()});
        }
        for (zzahi zzahi2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzahi2.asString());
            this.zzbHU.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh(String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3), new Object[0]);
        }
    }

    @Override
    public Set<zzahi> zzaw(long l) {
        return this.zzg(Collections.singleton(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<zzahi> zzg(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = String.valueOf("id IN (");
        Object object = String.valueOf(this.zzk(set));
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.zzbHU.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(zzahi.zzig(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.zzbHV.zzTe()) {
                this.zzbHV.zzh(String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2), new Object[0]);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public void zza(zzafa zzafa2, zzagf zzagf2) {
        Object object;
        String string;
        Iterable<Object> iterable;
        Iterable<zzahi> iterable2;
        if (!zzagf2.zzSj()) {
            return;
        }
        this.zzPt();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzafa2, new String[]{"rowid", "path"});
        zzagi<Object> zzagi2 = new zzagi<Object>(null);
        zzagi<Object> zzagi3 = new zzagi<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new zzafa(cursor.getString(1));
            if (!zzafa2.zzi((zzafa)iterable2)) {
                iterable = String.valueOf(zzafa2);
                string = String.valueOf(iterable2);
                this.zzbHV.warn(new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string).append(". Ignoring.").toString());
                continue;
            }
            iterable = zzafa.zza(zzafa2, (zzafa)iterable2);
            if (zzagf2.zzw((zzafa)iterable)) {
                zzagi2 = zzagi2.zzb((zzafa)iterable, l2);
                continue;
            }
            if (zzagf2.zzx((zzafa)iterable)) {
                zzagi3 = zzagi3.zzb((zzafa)iterable, l2);
                continue;
            }
            string = String.valueOf(zzafa2);
            object = String.valueOf(iterable2);
            this.zzbHV.warn(new StringBuilder(88 + String.valueOf(string).length() + String.valueOf(object).length()).append("We are pruning at ").append(string).append(" and have data at ").append((String)object).append(" that isn't marked for pruning or keeping. Ignoring.").toString());
        }
        int n = 0;
        int n2 = 0;
        if (!zzagi2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(zzafa2, zzafa.zzRq(), zzagi2, zzagi3, zzagf2, (List<zzais<zzafa, zzahu>>)iterable2);
            iterable = zzagi2.values();
            object = String.valueOf(this.zzk((Collection<Long>)iterable));
            string = new StringBuilder(11 + String.valueOf(object).length()).append("rowid IN (").append((String)object).append(")").toString();
            this.zzbHU.delete("serverCache", string, null);
            for (zzais zzais2 : iterable2) {
                this.zzc(zzafa2.zzh((zzafa)zzais2.getFirst()), (zzahu)zzais2.zzUj());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh(String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3), new Object[0]);
        }
    }

    private void zza(zzafa zzafa2, final zzafa zzafa3, zzagi<Long> zzagi2, final zzagi<Long> zzagi3, zzagf zzagf2, final List<zzais<zzafa, zzahu>> list) {
        if (zzagi2.getValue() != null) {
            int n = zzagf2.zza(0, new zzagi.zza<Void, Integer>(){

                @Override
                public Integer zza(zzafa zzafa2, Void void_, Integer n) {
                    return zzagi3.zzK(zzafa2) == null ? n + 1 : n;
                }
            });
            if (n > 0) {
                zzafa zzafa4 = zzafa2.zzh(zzafa3);
                if (this.zzbHV.zzTe()) {
                    this.zzbHV.zzh(String.format("Need to rewrite %d nodes below path %s", n, zzafa4), new Object[0]);
                }
                final zzahu zzahu2 = this.zzb(zzafa4);
                zzagf2.zza(null, new zzagi.zza<Void, Void>(){

                    @Override
                    public Void zza(zzafa zzafa2, Void void_, Void void_2) {
                        if (zzagi3.zzK(zzafa2) == null) {
                            list.add(new zzais<zzafa, zzahu>(zzafa3.zzh(zzafa2), zzahu2.zzO(zzafa2)));
                        }
                        return null;
                    }
                });
            }
        } else {
            for (Map.Entry<zzahi, zzagi<Long>> entry : zzagi2.zzSp()) {
                zzahi zzahi2 = entry.getKey();
                zzagf zzagf3 = zzagf2.zzd(entry.getKey());
                this.zza(zzafa2, zzafa3.zza(zzahi2), entry.getValue(), zzagi3.zze(zzahi2), zzagf3, list);
            }
        }
    }

    @Override
    public void zzPs() {
        this.zzPt();
        long l = System.currentTimeMillis();
        int n = this.zzbHU.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh(String.format("Deleted %d (all) write(s) in %dms", n, l2), new Object[0]);
        }
    }

    @Override
    public void beginTransaction() {
        zzaiv.zzb(!this.zzbHW, "runInTransaction called when an existing transaction is already in progress.");
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh("Starting transaction.", new Object[0]);
        }
        this.zzbHU.beginTransaction();
        this.zzbHW = true;
        this.zzbHX = System.currentTimeMillis();
    }

    @Override
    public void endTransaction() {
        this.zzbHU.endTransaction();
        this.zzbHW = false;
        long l = System.currentTimeMillis() - this.zzbHX;
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh(String.format("Transaction completed. Elapsed: %dms", l), new Object[0]);
        }
    }

    @Override
    public void setTransactionSuccessful() {
        this.zzbHU.setTransactionSuccessful();
    }

    private void zzPt() {
        zzaiv.zzb(this.zzbHW, "Transaction expected to already be in progress.");
    }

    private int zzc(zzafa zzafa2, zzahu zzahu2) {
        long l = zzaiq.zzs(zzahu2);
        if (zzahu2 instanceof zzahj && l > 16384L) {
            if (this.zzbHV.zzTe()) {
                this.zzbHV.zzh(String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", zzafa2, l, 16384), new Object[0]);
            }
            int n = 0;
            for (zzaht zzaht2 : zzahu2) {
                n += this.zzc(zzafa2.zza(zzaht2.zzTK()), zzaht2.zzPj());
            }
            if (!zzahu2.zzTp().isEmpty()) {
                this.zzd(zzafa2.zza(zzahi.zzTj()), zzahu2.zzTp());
                ++n;
            }
            this.zzd(zzafa2, zzahn.zzTA());
            return ++n;
        }
        this.zzd(zzafa2, zzahu2);
        return 1;
    }

    private String zza(zzafa zzafa2, int n) {
        String string = String.valueOf(zzadq.zzc(zzafa2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    private void zzd(zzafa zzafa2, zzahu zzahu2) {
        byte[] byArray = this.zzac(zzahu2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = zzadq.zzb(byArray, 262144);
            if (this.zzbHV.zzTe()) {
                n = list.size();
                this.zzbHV.zzh(new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString(), new Object[0]);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", this.zza(zzafa2, n));
                contentValues.put("value", list.get(n));
                this.zzbHU.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
        } else {
            ContentValues contentValues = new ContentValues();
            contentValues.put("path", zzadq.zzc(zzafa2));
            contentValues.put("value", byArray);
            this.zzbHU.insertWithOnConflict("serverCache", null, contentValues, 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private zzahu zzb(zzafa zzafa2) {
        zzafa zzafa3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzafa2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        zzahu zzahu2 = zzahn.zzTA();
        boolean bl = false;
        HashMap<zzafa, void> hashMap = new HashMap<zzafa, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                zzafa3 = new zzafa(((String)object2).substring(0, ((String)object2).length() - ".part-0000".length()));
                int n = this.zza(zzafa3, arrayList, i);
                if (this.zzbHV.zzTe()) {
                    this.zzbHV.zzh(new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString(), new Object[0]);
                }
                zzahu zzahu3 = this.zzH(this.zzO(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                zzahu zzahu4 = this.zzH((byte[])arrayList2.get(i));
                zzafa3 = new zzafa((String)arrayList.get(i));
            }
            if (zzafa3.zzRw() != null && zzafa3.zzRw().zzTl()) {
                hashMap.put(zzafa3, object);
                continue;
            }
            if (zzafa3.zzi(zzafa2)) {
                zzaiv.zzb(!bl, "Descendants of path must come after ancestors.");
                zzahu2 = object.zzO(zzafa.zza(zzafa3, zzafa2));
                continue;
            }
            if (zzafa2.zzi(zzafa3)) {
                bl = true;
                object2 = zzafa.zza(zzafa2, zzafa3);
                zzahu2 = zzahu2.zzl((zzafa)object2, (zzahu)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", zzafa3, zzafa2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            zzafa3 = (zzafa)entry.getKey();
            zzahu2 = zzahu2.zzl(zzafa.zza(zzafa2, zzafa3), (zzahu)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh(String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), zzaiq.zzt(zzahu2), zzafa2, l7, l2, l4, l6), new Object[0]);
        }
        return zzahu2;
    }

    private int zza(zzafa zzafa2, List<String> list, int n) {
        int n2;
        String string = zzadq.zzc(zzafa2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(this.zza(zzafa2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private Cursor zza(zzafa zzafa2, String[] stringArray) {
        String string = zzadq.zzc(zzafa2);
        String string2 = zzadq.zzhO(string);
        String[] stringArray2 = new String[zzafa2.size() + 3];
        String string3 = zzadq.zzb(zzafa2, stringArray2);
        String string4 = String.valueOf(string3);
        String string5 = String.valueOf(" OR (path > ? AND path < ?)");
        string3 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        stringArray2[zzafa2.size() + 1] = string;
        stringArray2[zzafa2.size() + 2] = string2;
        String string6 = "path";
        return this.zzbHU.query("serverCache", stringArray, string3, stringArray2, null, null, string6);
    }

    private static String zzc(zzafa zzafa2) {
        if (zzafa2.isEmpty()) {
            return "/";
        }
        return String.valueOf(zzafa2.toString()).concat("/");
    }

    private static String zzhO(String string) {
        assert (string.endsWith("/")) : "Path keys must end with a '/'";
        String string2 = String.valueOf(string.substring(0, string.length() - 1));
        int n = 48;
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private static String zzb(zzafa zzafa2, String[] stringArray) {
        assert (stringArray.length >= zzafa2.size() + 1);
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!zzafa2.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray[n] = zzadq.zzc(zzafa2);
            zzafa2 = zzafa2.zzRv();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray[n] = zzadq.zzc(zzafa.zzRq());
        return stringBuilder.toString();
    }

    private int zza(String string, zzafa zzafa2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = zzadq.zzc(zzafa2);
        String string4 = zzadq.zzhO(string3);
        return this.zzbHU.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzb(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / n + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(n, byArray.length - i * n);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * n, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private byte[] zzO(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private byte[] zzac(Object object) {
        try {
            return zzaim.zzas((Object)object).getBytes(zzaiI);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private zzahu zzH(byte[] byArray) {
        try {
            Object object = zzaim.zzik((String)new String(byArray, zzaiI));
            return zzahv.zzaq(object);
        }
        catch (IOException iOException) {
            String string = new String(byArray, zzaiI);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private String zzk(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }

    private static class zza
    extends SQLiteOpenHelper {
        public zza(Context context, String string) {
            super(context, string, null, 2);
        }

        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            sQLiteDatabase.execSQL("CREATE TABLE serverCache (path TEXT PRIMARY KEY, value BLOB);");
            sQLiteDatabase.execSQL("CREATE TABLE writes (id INTEGER, path TEXT, type TEXT, part INTEGER, node BLOB, UNIQUE (id, part));");
            sQLiteDatabase.execSQL("CREATE TABLE trackedQueries (id INTEGER PRIMARY KEY, path TEXT, queryParams TEXT, lastUse INTEGER, complete INTEGER, active INTEGER);");
            sQLiteDatabase.execSQL("CREATE TABLE trackedKeys (id INTEGER, key TEXT);");
        }

        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            assert (n2 == 2) : "Why is onUpgrade() called with a different version?";
            if (n > 1) {
                throw new AssertionError((Object)new StringBuilder(40).append("We don't handle upgrading to ").append(n2).toString());
            }
            this.zzc(sQLiteDatabase, "serverCache");
            sQLiteDatabase.execSQL("CREATE TABLE serverCache (path TEXT PRIMARY KEY, value BLOB);");
            this.zzc(sQLiteDatabase, "complete");
            sQLiteDatabase.execSQL("CREATE TABLE trackedKeys (id INTEGER, key TEXT);");
            sQLiteDatabase.execSQL("CREATE TABLE trackedQueries (id INTEGER PRIMARY KEY, path TEXT, queryParams TEXT, lastUse INTEGER, complete INTEGER, active INTEGER);");
        }

        private void zzc(SQLiteDatabase sQLiteDatabase, String string) {
            String string2 = String.valueOf(string);
            sQLiteDatabase.execSQL(string2.length() != 0 ? "DROP TABLE IF EXISTS ".concat(string2) : new String("DROP TABLE IF EXISTS "));
        }
    }
}

