/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzaev;
import com.google.android.gms.internal.zzafa;
import com.google.android.gms.internal.zzafc;
import com.google.android.gms.internal.zzafd;
import com.google.android.gms.internal.zzafe;
import com.google.android.gms.internal.zzait;
import com.google.android.gms.internal.zzaiv;
import com.google.android.gms.internal.zzaiw;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, FirebaseDatabase> zzbHk = new HashMap<String, FirebaseDatabase>();
    private final FirebaseApp zzbHl;
    private final zzafd zzbHm;
    private final zzaev zzbHn;
    private zzafc zzbHo;

    public static FirebaseDatabase getInstance() {
        return FirebaseDatabase.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        if (!zzbHk.containsKey(firebaseApp.getName())) {
            String string = firebaseApp.getOptions().getDatabaseUrl();
            if (string == null) {
                throw new DatabaseException("Failed to get FirebaseDatabase instance: FirebaseApp object has no DatabaseURL in its FirebaseOptions object.");
            }
            zzait zzait2 = zzaiv.zzil(string);
            if (!zzait2.zzbHw.isEmpty()) {
                String string2 = String.valueOf(zzait2.zzbHw.toString());
                throw new DatabaseException(new StringBuilder(114 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Configured Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
            }
            zzaev zzaev2 = new zzaev();
            if (!firebaseApp.zzNU()) {
                zzaev2.zzie(firebaseApp.getName());
            }
            zzaev2.zze(firebaseApp);
            zzbHk.put(firebaseApp.getName(), new FirebaseDatabase(firebaseApp, zzait2.zzbHm, zzaev2));
        }
        return zzbHk.get(firebaseApp.getName());
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzafd zzafd2, zzaev zzaev2) {
        this.zzbHl = firebaseApp;
        this.zzbHm = zzafd2;
        this.zzbHn = zzaev2;
    }

    public FirebaseApp getApp() {
        return this.zzbHl;
    }

    public DatabaseReference getReference() {
        this.zzPi();
        return new DatabaseReference(this.zzbHo, zzafa.zzRq());
    }

    public DatabaseReference getReference(String string) {
        this.zzPi();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzaiw.zzir(string);
        zzafa zzafa2 = new zzafa(string);
        return new DatabaseReference(this.zzbHo, zzafa2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzPi();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzait zzait2 = zzaiv.zzil(string);
        if (!zzait2.zzbHm.zzbJa.equals(this.zzbHo.zzRz().zzbJa)) {
            String string2 = String.valueOf(this.getReference().toString());
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.zzbHo, zzait2.zzbHw);
    }

    public void purgeOutstandingWrites() {
        this.zzPi();
        this.zzbHo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                FirebaseDatabase.this.zzbHo.purgeOutstandingWrites();
            }
        });
    }

    public void goOnline() {
        this.zzPi();
        zzafe.zzl(this.zzbHo);
    }

    public void goOffline() {
        this.zzPi();
        zzafe.zzk(this.zzbHo);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzhM("setLogLevel");
        this.zzbHn.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzhM("setPersistenceEnabled");
        this.zzbHn.setPersistenceEnabled(bl);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private void zzhM(String string) {
        if (this.zzbHo != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private synchronized void zzPi() {
        if (this.zzbHo == null) {
            this.zzbHo = zzafe.zza(this.zzbHn, this.zzbHm, this);
        }
    }
}

