/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzaer;
import com.google.android.gms.internal.zzaew;
import com.google.android.gms.internal.zzafa;
import com.google.android.gms.internal.zzafc;
import com.google.android.gms.internal.zzafp;
import com.google.android.gms.internal.zzafs;
import com.google.android.gms.internal.zzagt;
import com.google.android.gms.internal.zzagu;
import com.google.android.gms.internal.zzahh;
import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzahm;
import com.google.android.gms.internal.zzahn;
import com.google.android.gms.internal.zzahq;
import com.google.android.gms.internal.zzahu;
import com.google.android.gms.internal.zzahw;
import com.google.android.gms.internal.zzahx;
import com.google.android.gms.internal.zzahy;
import com.google.android.gms.internal.zzaia;
import com.google.android.gms.internal.zzaib;
import com.google.android.gms.internal.zzaiv;
import com.google.android.gms.internal.zzaiw;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;

public class Query {
    protected final zzafc zzbHo;
    protected final zzafa zzbHw;
    protected final zzagt zzbHz;
    private final boolean zzbHA;

    Query(zzafc zzafc2, zzafa zzafa2, zzagt zzagt2, boolean bl) throws DatabaseException {
        this.zzbHo = zzafc2;
        this.zzbHw = zzafa2;
        this.zzbHz = zzagt2;
        this.zzbHA = bl;
        zzaiv.zzb(zzagt2.isValid(), "Validation of queries failed.");
    }

    Query(zzafc zzafc2, zzafa zzafa2) {
        this.zzbHo = zzafc2;
        this.zzbHw = zzafa2;
        this.zzbHz = zzagt.zzbPK;
        this.zzbHA = false;
    }

    private void zza(zzagt zzagt2) {
        if (zzagt2.zzSK().equals(zzahq.zzTH())) {
            zzahi zzahi2;
            zzahu zzahu2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzagt2.zzSC()) {
                zzahu2 = zzagt2.zzSD();
                zzahi2 = zzagt2.zzSE();
                if (zzahi2 != zzahi.zzTh() || !(zzahu2 instanceof zzaia)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzagt2.zzSF()) {
                zzahu2 = zzagt2.zzSG();
                zzahi2 = zzagt2.zzSH();
                if (zzahi2 != zzahi.zzTi() || !(zzahu2 instanceof zzaia)) {
                    throw new IllegalArgumentException(string);
                }
            }
        } else if (zzagt2.zzSK().equals(zzahx.zzTL()) && (zzagt2.zzSC() && !zzahy.zzp(zzagt2.zzSD()) || zzagt2.zzSF() && !zzahy.zzp(zzagt2.zzSG()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private void zzb(zzagt zzagt2) {
        if (zzagt2.zzSC() && zzagt2.zzSF() && zzagt2.zzSI() && !zzagt2.zzSJ()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private void zzPl() {
        if (this.zzbHz.zzSC()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.zzbHz.zzSF()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private void zzPm() {
        if (this.zzbHA) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzafp(this.zzbHo, valueEventListener, this.zzPo()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzaer(this.zzbHo, childEventListener, this.zzPo()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(final ValueEventListener valueEventListener) {
        this.zzb(new zzafp(this.zzbHo, new ValueEventListener(){

            @Override
            public void onDataChange(DataSnapshot dataSnapshot) {
                Query.this.removeEventListener(this);
                valueEventListener.onDataChange(dataSnapshot);
            }

            @Override
            public void onCancelled(DatabaseError databaseError) {
                valueEventListener.onCancelled(databaseError);
            }
        }, this.zzPo()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzafp(this.zzbHo, valueEventListener, this.zzPo()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzaer(this.zzbHo, childEventListener, this.zzPo()));
    }

    private void zza(final zzaew zzaew2) {
        zzafs.zzRV().zzk(zzaew2);
        this.zzbHo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                Query.this.zzbHo.zze(zzaew2);
            }
        });
    }

    private void zzb(final zzaew zzaew2) {
        zzafs.zzRV().zzi(zzaew2);
        this.zzbHo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                Query.this.zzbHo.zzf(zzaew2);
            }
        });
    }

    public void keepSynced(final boolean bl) {
        if (!this.zzbHw.isEmpty() && this.zzbHw.zzRt().equals(zzahi.zzTk())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.zzbHo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                Query.this.zzbHo.zza(Query.this.zzPo(), bl);
            }
        });
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzahu zzahu2 = string != null ? new zzaia(string, zzahy.zzTM()) : zzahn.zzTA();
        return this.zza(zzahu2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzahm(d, zzahy.zzTM()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzahh(bl, zzahy.zzTM()), string);
    }

    private Query zza(zzahu zzahu2, String string) {
        zzaiw.zziu(string);
        if (!zzahu2.zzTo() && !zzahu2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.zzbHz.zzSC()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzahi zzahi2 = string != null ? zzahi.zzig(string) : null;
        zzagt zzagt2 = this.zzbHz.zza(zzahu2, zzahi2);
        this.zzb(zzagt2);
        this.zza(zzagt2);
        assert (zzagt2.isValid());
        return new Query(this.zzbHo, this.zzbHw, zzagt2, this.zzbHA);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzahu zzahu2 = string != null ? new zzaia(string, zzahy.zzTM()) : zzahn.zzTA();
        return this.zzb(zzahu2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzahm(d, zzahy.zzTM()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzahh(bl, zzahy.zzTM()), string);
    }

    private Query zzb(zzahu zzahu2, String string) {
        zzahi zzahi2;
        zzaiw.zziu(string);
        if (!zzahu2.zzTo() && !zzahu2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzahi zzahi3 = zzahi2 = string != null ? zzahi.zzig(string) : null;
        if (this.zzbHz.zzSF()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzagt zzagt2 = this.zzbHz.zzb(zzahu2, zzahi2);
        this.zzb(zzagt2);
        this.zza(zzagt2);
        assert (zzagt2.isValid());
        return new Query(this.zzbHo, this.zzbHw, zzagt2, this.zzbHA);
    }

    public Query equalTo(String string) {
        this.zzPl();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzPl();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzPl();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzPl();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzPl();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzPl();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzbHz.zzSI()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzbHo, this.zzbHw, this.zzbHz.zznC(n), this.zzbHA);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzbHz.zzSI()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzbHo, this.zzbHw, this.zzbHz.zznD(n), this.zzbHA);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzaiw.zziq(string);
        this.zzPm();
        zzafa zzafa2 = new zzafa(string);
        if (zzafa2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzahw zzahw2 = new zzahw(zzafa2);
        return new Query(this.zzbHo, this.zzbHw, this.zzbHz.zza(zzahw2), true);
    }

    public Query orderByPriority() {
        this.zzPm();
        zzagt zzagt2 = this.zzbHz.zza(zzahx.zzTL());
        this.zza(zzagt2);
        return new Query(this.zzbHo, this.zzbHw, zzagt2, true);
    }

    public Query orderByKey() {
        this.zzPm();
        zzagt zzagt2 = this.zzbHz.zza(zzahq.zzTH());
        this.zza(zzagt2);
        return new Query(this.zzbHo, this.zzbHw, zzagt2, true);
    }

    public Query orderByValue() {
        this.zzPm();
        return new Query(this.zzbHo, this.zzbHw, this.zzbHz.zza(zzaib.zzTN()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.zzbHo, this.zzPn());
    }

    public zzafa zzPn() {
        return this.zzbHw;
    }

    public zzagu zzPo() {
        return new zzagu(this.zzbHw, this.zzbHz);
    }
}

