/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.internal.aed;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.dynamiclinks.ShortDynamicLink;
import com.google.firebase.dynamiclinks.zza;

public final class DynamicLink {
    private final Bundle zzcmI;

    DynamicLink(Bundle bundle) {
        this.zzcmI = bundle;
    }

    public final Uri getUri() {
        Bundle bundle = this.zzcmI;
        aed.zzE(bundle);
        Uri uri = (Uri)bundle.getParcelable("dynamicLink");
        if (uri == null) {
            Uri.Builder builder = new Uri.Builder();
            builder.scheme("https");
            builder.authority(bundle.getString("domain"));
            Bundle bundle2 = bundle.getBundle("parameters");
            for (String string : bundle2.keySet()) {
                Object object = bundle2.get(string);
                if (object == null) continue;
                builder.appendQueryParameter(string, object.toString());
            }
            uri = builder.build();
        }
        return uri;
    }

    public static final class SocialMetaTagParameters {
        final Bundle zzbPM;

        private SocialMetaTagParameters(Bundle bundle) {
            this.zzbPM = bundle;
        }

        /* synthetic */ SocialMetaTagParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPM = new Bundle();

            public final Builder setTitle(String string) {
                this.zzbPM.putString("st", string);
                return this;
            }

            public final Builder setDescription(String string) {
                this.zzbPM.putString("sd", string);
                return this;
            }

            public final Builder setImageUrl(Uri uri) {
                this.zzbPM.putParcelable("si", (Parcelable)uri);
                return this;
            }

            public final SocialMetaTagParameters build() {
                return new SocialMetaTagParameters(this.zzbPM, null);
            }
        }
    }

    public static final class ItunesConnectAnalyticsParameters {
        final Bundle zzbPM;

        private ItunesConnectAnalyticsParameters(Bundle bundle) {
            this.zzbPM = bundle;
        }

        /* synthetic */ ItunesConnectAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPM = new Bundle();

            public final Builder setProviderToken(String string) {
                this.zzbPM.putString("pt", string);
                return this;
            }

            public final Builder setAffiliateToken(String string) {
                this.zzbPM.putString("at", string);
                return this;
            }

            public final Builder setCampaignToken(String string) {
                this.zzbPM.putString("ct", string);
                return this;
            }

            public final ItunesConnectAnalyticsParameters build() {
                return new ItunesConnectAnalyticsParameters(this.zzbPM, null);
            }
        }
    }

    public static final class GoogleAnalyticsParameters {
        Bundle zzbPM;

        private GoogleAnalyticsParameters(Bundle bundle) {
            this.zzbPM = bundle;
        }

        /* synthetic */ GoogleAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPM = new Bundle();

            public Builder() {
            }

            public Builder(String string, String string2, String string3) {
                this.zzbPM.putString("utm_source", string);
                this.zzbPM.putString("utm_medium", string2);
                this.zzbPM.putString("utm_campaign", string3);
            }

            public final Builder setSource(String string) {
                this.zzbPM.putString("utm_source", string);
                return this;
            }

            public final Builder setMedium(String string) {
                this.zzbPM.putString("utm_medium", string);
                return this;
            }

            public final Builder setCampaign(String string) {
                this.zzbPM.putString("utm_campaign", string);
                return this;
            }

            public final Builder setTerm(String string) {
                this.zzbPM.putString("utm_term", string);
                return this;
            }

            public final Builder setContent(String string) {
                this.zzbPM.putString("utm_content", string);
                return this;
            }

            public final GoogleAnalyticsParameters build() {
                return new GoogleAnalyticsParameters(this.zzbPM, null);
            }
        }
    }

    public static final class IosParameters {
        final Bundle zzbPM;

        private IosParameters(Bundle bundle) {
            this.zzbPM = bundle;
        }

        /* synthetic */ IosParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPM = new Bundle();

            public Builder(@NonNull String string) {
                this.zzbPM.putString("ibi", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zzbPM.putParcelable("ifl", (Parcelable)uri);
                return this;
            }

            public final Builder setCustomScheme(String string) {
                this.zzbPM.putString("ius", string);
                return this;
            }

            public final Builder setIpadFallbackUrl(Uri uri) {
                this.zzbPM.putParcelable("ipfl", (Parcelable)uri);
                return this;
            }

            public final Builder setIpadBundleId(String string) {
                this.zzbPM.putString("ipbi", string);
                return this;
            }

            public final Builder setAppStoreId(String string) {
                this.zzbPM.putString("isi", string);
                return this;
            }

            public final Builder setMinimumVersion(String string) {
                this.zzbPM.putString("imv", string);
                return this;
            }

            public final IosParameters build() {
                return new IosParameters(this.zzbPM, null);
            }
        }
    }

    public static final class AndroidParameters {
        final Bundle zzbPM;

        private AndroidParameters(Bundle bundle) {
            this.zzbPM = bundle;
        }

        /* synthetic */ AndroidParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPM;

            public Builder() {
                if (FirebaseApp.getInstance() == null) {
                    throw new IllegalStateException("FirebaseApp not initialized.");
                }
                this.zzbPM = new Bundle();
                this.zzbPM.putString("apn", FirebaseApp.getInstance().getApplicationContext().getPackageName());
            }

            public Builder(@NonNull String string) {
                this.zzbPM = new Bundle();
                this.zzbPM.putString("apn", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zzbPM.putParcelable("afl", (Parcelable)uri);
                return this;
            }

            public final Builder setMinimumVersion(int n) {
                this.zzbPM.putInt("amv", n);
                return this;
            }

            public final AndroidParameters build() {
                return new AndroidParameters(this.zzbPM, null);
            }
        }
    }

    public static final class Builder {
        private final aed zzcmJ;
        private final Bundle zzcmI;
        private final Bundle zzcmK;

        public Builder(aed aed2) {
            this.zzcmJ = aed2;
            this.zzcmI = new Bundle();
            if (FirebaseApp.getInstance() != null) {
                this.zzcmI.putString("apiKey", FirebaseApp.getInstance().getOptions().getApiKey());
            }
            this.zzcmK = new Bundle();
            this.zzcmI.putBundle("parameters", this.zzcmK);
        }

        public final Builder setLongLink(@NonNull Uri uri) {
            this.zzcmI.putParcelable("dynamicLink", (Parcelable)uri);
            return this;
        }

        public final Builder setLink(@NonNull Uri uri) {
            this.zzcmK.putParcelable("link", (Parcelable)uri);
            return this;
        }

        public final Builder setDynamicLinkDomain(@NonNull String string) {
            this.zzcmI.putString("domain", string);
            return this;
        }

        public final Builder setAndroidParameters(AndroidParameters androidParameters) {
            this.zzcmK.putAll(androidParameters.zzbPM);
            return this;
        }

        public final Builder setIosParameters(IosParameters iosParameters) {
            this.zzcmK.putAll(iosParameters.zzbPM);
            return this;
        }

        public final Builder setGoogleAnalyticsParameters(GoogleAnalyticsParameters googleAnalyticsParameters) {
            this.zzcmK.putAll(googleAnalyticsParameters.zzbPM);
            return this;
        }

        public final Builder setItunesConnectAnalyticsParameters(ItunesConnectAnalyticsParameters itunesConnectAnalyticsParameters) {
            this.zzcmK.putAll(itunesConnectAnalyticsParameters.zzbPM);
            return this;
        }

        public final Builder setSocialMetaTagParameters(SocialMetaTagParameters socialMetaTagParameters) {
            this.zzcmK.putAll(socialMetaTagParameters.zzbPM);
            return this;
        }

        public final DynamicLink buildDynamicLink() {
            aed.zzE(this.zzcmI);
            return new DynamicLink(this.zzcmI);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink() {
            this.zzJX();
            return this.zzcmJ.zzD(this.zzcmI);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink(int n) {
            this.zzJX();
            this.zzcmI.putInt("suffix", n);
            return this.zzcmJ.zzD(this.zzcmI);
        }

        private final void zzJX() {
            if (this.zzcmI.getString("apiKey") == null) {
                throw new IllegalArgumentException("Missing API key. Set with setApiKey().");
            }
        }
    }
}

