/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.internal.zzdzm;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.dynamiclinks.ShortDynamicLink;
import com.google.firebase.dynamiclinks.zza;

public final class DynamicLink {
    private final Bundle zzmhp;

    DynamicLink(Bundle bundle) {
        this.zzmhp = bundle;
    }

    public final Uri getUri() {
        Bundle bundle = this.zzmhp;
        zzdzm.zzaa(bundle);
        Uri uri = (Uri)bundle.getParcelable("dynamicLink");
        if (uri == null) {
            Uri.Builder builder = new Uri.Builder();
            builder.scheme("https");
            builder.authority(bundle.getString("domain"));
            Bundle bundle2 = bundle.getBundle("parameters");
            for (String string : bundle2.keySet()) {
                Object object = bundle2.get(string);
                if (object == null) continue;
                builder.appendQueryParameter(string, object.toString());
            }
            uri = builder.build();
        }
        return uri;
    }

    public static final class NavigationInfoParameters {
        final Bundle zzkna;

        private NavigationInfoParameters(Bundle bundle) {
            this.zzkna = bundle;
        }

        /* synthetic */ NavigationInfoParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzkna = new Bundle();

            public Builder() {
            }

            public final Builder setForcedRedirectEnabled(boolean bl) {
                this.zzkna.putInt("efr", bl ? 1 : 0);
                return this;
            }

            public final NavigationInfoParameters build() {
                return new NavigationInfoParameters(this.zzkna, null);
            }
        }
    }

    public static final class SocialMetaTagParameters {
        final Bundle zzkna;

        private SocialMetaTagParameters(Bundle bundle) {
            this.zzkna = bundle;
        }

        /* synthetic */ SocialMetaTagParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzkna = new Bundle();

            public Builder() {
            }

            public final Builder setTitle(String string) {
                this.zzkna.putString("st", string);
                return this;
            }

            public final Builder setDescription(String string) {
                this.zzkna.putString("sd", string);
                return this;
            }

            public final Builder setImageUrl(Uri uri) {
                this.zzkna.putParcelable("si", (Parcelable)uri);
                return this;
            }

            public final SocialMetaTagParameters build() {
                return new SocialMetaTagParameters(this.zzkna, null);
            }
        }
    }

    public static final class ItunesConnectAnalyticsParameters {
        final Bundle zzkna;

        private ItunesConnectAnalyticsParameters(Bundle bundle) {
            this.zzkna = bundle;
        }

        /* synthetic */ ItunesConnectAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzkna = new Bundle();

            public Builder() {
            }

            public final Builder setProviderToken(String string) {
                this.zzkna.putString("pt", string);
                return this;
            }

            public final Builder setAffiliateToken(String string) {
                this.zzkna.putString("at", string);
                return this;
            }

            public final Builder setCampaignToken(String string) {
                this.zzkna.putString("ct", string);
                return this;
            }

            public final ItunesConnectAnalyticsParameters build() {
                return new ItunesConnectAnalyticsParameters(this.zzkna, null);
            }
        }
    }

    public static final class GoogleAnalyticsParameters {
        Bundle zzkna;

        private GoogleAnalyticsParameters(Bundle bundle) {
            this.zzkna = bundle;
        }

        /* synthetic */ GoogleAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzkna = new Bundle();

            public Builder() {
            }

            public Builder(String string, String string2, String string3) {
                this.zzkna.putString("utm_source", string);
                this.zzkna.putString("utm_medium", string2);
                this.zzkna.putString("utm_campaign", string3);
            }

            public final Builder setSource(String string) {
                this.zzkna.putString("utm_source", string);
                return this;
            }

            public final Builder setMedium(String string) {
                this.zzkna.putString("utm_medium", string);
                return this;
            }

            public final Builder setCampaign(String string) {
                this.zzkna.putString("utm_campaign", string);
                return this;
            }

            public final Builder setTerm(String string) {
                this.zzkna.putString("utm_term", string);
                return this;
            }

            public final Builder setContent(String string) {
                this.zzkna.putString("utm_content", string);
                return this;
            }

            public final GoogleAnalyticsParameters build() {
                return new GoogleAnalyticsParameters(this.zzkna, null);
            }
        }
    }

    public static final class IosParameters {
        final Bundle zzkna;

        private IosParameters(Bundle bundle) {
            this.zzkna = bundle;
        }

        /* synthetic */ IosParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzkna = new Bundle();

            public Builder(@NonNull String string) {
                this.zzkna.putString("ibi", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zzkna.putParcelable("ifl", (Parcelable)uri);
                return this;
            }

            public final Builder setCustomScheme(String string) {
                this.zzkna.putString("ius", string);
                return this;
            }

            public final Builder setIpadFallbackUrl(Uri uri) {
                this.zzkna.putParcelable("ipfl", (Parcelable)uri);
                return this;
            }

            public final Builder setIpadBundleId(String string) {
                this.zzkna.putString("ipbi", string);
                return this;
            }

            public final Builder setAppStoreId(String string) {
                this.zzkna.putString("isi", string);
                return this;
            }

            public final Builder setMinimumVersion(String string) {
                this.zzkna.putString("imv", string);
                return this;
            }

            public final IosParameters build() {
                return new IosParameters(this.zzkna, null);
            }
        }
    }

    public static final class AndroidParameters {
        final Bundle zzkna;

        private AndroidParameters(Bundle bundle) {
            this.zzkna = bundle;
        }

        /* synthetic */ AndroidParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzkna;

            public Builder() {
                if (FirebaseApp.getInstance() == null) {
                    throw new IllegalStateException("FirebaseApp not initialized.");
                }
                this.zzkna = new Bundle();
                this.zzkna.putString("apn", FirebaseApp.getInstance().getApplicationContext().getPackageName());
            }

            public Builder(@NonNull String string) {
                this.zzkna = new Bundle();
                this.zzkna.putString("apn", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zzkna.putParcelable("afl", (Parcelable)uri);
                return this;
            }

            public final Builder setMinimumVersion(int n) {
                this.zzkna.putInt("amv", n);
                return this;
            }

            public final AndroidParameters build() {
                return new AndroidParameters(this.zzkna, null);
            }
        }
    }

    public static final class Builder {
        private final zzdzm zzmhq;
        private final Bundle zzmhp;
        private final Bundle zzmhr;

        public Builder(zzdzm zzdzm2) {
            this.zzmhq = zzdzm2;
            this.zzmhp = new Bundle();
            if (FirebaseApp.getInstance() != null) {
                this.zzmhp.putString("apiKey", FirebaseApp.getInstance().getOptions().getApiKey());
            }
            this.zzmhr = new Bundle();
            this.zzmhp.putBundle("parameters", this.zzmhr);
        }

        public final Builder setLongLink(@NonNull Uri uri) {
            this.zzmhp.putParcelable("dynamicLink", (Parcelable)uri);
            return this;
        }

        public final Builder setLink(@NonNull Uri uri) {
            this.zzmhr.putParcelable("link", (Parcelable)uri);
            return this;
        }

        public final Builder setDynamicLinkDomain(@NonNull String string) {
            this.zzmhp.putString("domain", string);
            return this;
        }

        public final Builder setAndroidParameters(AndroidParameters androidParameters) {
            this.zzmhr.putAll(androidParameters.zzkna);
            return this;
        }

        public final Builder setIosParameters(IosParameters iosParameters) {
            this.zzmhr.putAll(iosParameters.zzkna);
            return this;
        }

        public final Builder setGoogleAnalyticsParameters(GoogleAnalyticsParameters googleAnalyticsParameters) {
            this.zzmhr.putAll(googleAnalyticsParameters.zzkna);
            return this;
        }

        public final Builder setItunesConnectAnalyticsParameters(ItunesConnectAnalyticsParameters itunesConnectAnalyticsParameters) {
            this.zzmhr.putAll(itunesConnectAnalyticsParameters.zzkna);
            return this;
        }

        public final Builder setSocialMetaTagParameters(SocialMetaTagParameters socialMetaTagParameters) {
            this.zzmhr.putAll(socialMetaTagParameters.zzkna);
            return this;
        }

        public final Builder setNavigationInfoParameters(NavigationInfoParameters navigationInfoParameters) {
            this.zzmhr.putAll(navigationInfoParameters.zzkna);
            return this;
        }

        public final DynamicLink buildDynamicLink() {
            zzdzm.zzaa(this.zzmhp);
            return new DynamicLink(this.zzmhp);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink() {
            this.zzbxz();
            return this.zzmhq.zzz(this.zzmhp);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink(int n) {
            this.zzbxz();
            this.zzmhp.putInt("suffix", n);
            return this.zzmhq.zzz(this.zzmhp);
        }

        private final void zzbxz() {
            if (this.zzmhp.getString("apiKey") == null) {
                throw new IllegalArgumentException("Missing API key. Set with setApiKey().");
            }
        }
    }
}

