/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks.internal;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.dynamiclinks.internal.DynamicLinkDataCreator;

@SafeParcelable.Class(creator="DynamicLinkDataCreator")
public class DynamicLinkData
extends AbstractSafeParcelable {
    @SafeParcelable.Field(id=1, getter="getDynamicLink")
    @Nullable
    private String dynamicLink;
    @SafeParcelable.Field(id=2, getter="getDeepLink")
    @Nullable
    private String deepLink;
    @SafeParcelable.Field(id=3, getter="getMinVersion")
    private int minVersion;
    @SafeParcelable.Field(id=4, getter="getClickTimestamp")
    private long clickTimestamp = 0L;
    @SafeParcelable.Field(id=5, getter="getExtensionBundle")
    @Nullable
    private Bundle extensionBundle = null;
    @SafeParcelable.Field(id=6, getter="getRedirectUrl")
    @Nullable
    private Uri redirectUrl;
    public static final Parcelable.Creator<DynamicLinkData> CREATOR = new DynamicLinkDataCreator();

    @Nullable
    public String getDynamicLink() {
        return this.dynamicLink;
    }

    public void setDynamicLink(String dynamicLink) {
        this.dynamicLink = dynamicLink;
    }

    @Nullable
    public String getDeepLink() {
        return this.deepLink;
    }

    public void setDeepLink(String deepLink) {
        this.deepLink = deepLink;
    }

    public int getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(int minVersion) {
        this.minVersion = minVersion;
    }

    public long getClickTimestamp() {
        return this.clickTimestamp;
    }

    public void setClickTimestamp(long timestamp) {
        this.clickTimestamp = timestamp;
    }

    public Bundle getExtensionBundle() {
        return this.extensionBundle == null ? new Bundle() : this.extensionBundle;
    }

    public void setRedirectUrl(Uri redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    @Nullable
    public Uri getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setExtensionData(Bundle bundle) {
        this.extensionBundle = bundle;
    }

    @SafeParcelable.Constructor
    public DynamicLinkData(@Nullable @SafeParcelable.Param(id=1) String dynamicLink, @Nullable @SafeParcelable.Param(id=2) String deepLink, @SafeParcelable.Param(id=3) int minVersion, @SafeParcelable.Param(id=4) long clickTimestamp, @Nullable @SafeParcelable.Param(id=5) Bundle extensions, @Nullable @SafeParcelable.Param(id=6) Uri redirectUrl) {
        this.dynamicLink = dynamicLink;
        this.deepLink = deepLink;
        this.minVersion = minVersion;
        this.clickTimestamp = clickTimestamp;
        this.extensionBundle = extensions;
        this.redirectUrl = redirectUrl;
    }

    public void writeToParcel(Parcel dest, int flags) {
        DynamicLinkDataCreator.writeToParcel(this, dest, flags);
    }
}

