/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.firebase.dynamiclinks.internal.IDynamicLinksCallbacks;
import com.google.firebase.dynamiclinks.internal.IDynamicLinksService;

public class DynamicLinksClient
extends GmsClient<IDynamicLinksService> {
    public static final String ACTION_START_SERVICE = "com.google.firebase.dynamiclinks.service.START";
    public static final String SERVICE_DESCRIPTOR = "com.google.firebase.dynamiclinks.internal.IDynamicLinksService";
    private static final int DYNAMIC_LINKS_API_VALUE = 131;
    private static final int V17 = 12451000;

    public DynamicLinksClient(Context context, Looper looper, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectedListener, GoogleApiClient.OnConnectionFailedListener connectionFailedListener) {
        super(context, looper, 131, clientSettings, connectedListener, connectionFailedListener);
    }

    @NonNull
    protected String getStartServiceAction() {
        return ACTION_START_SERVICE;
    }

    @NonNull
    protected String getServiceDescriptor() {
        return SERVICE_DESCRIPTOR;
    }

    @Nullable
    protected IDynamicLinksService createServiceInterface(IBinder binder) {
        return IDynamicLinksService.Stub.asInterface(binder);
    }

    void getDynamicLink(IDynamicLinksCallbacks.Stub callback, @Nullable String dynamicLink) {
        try {
            ((IDynamicLinksService)this.getService()).getDynamicLink(callback, dynamicLink);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void createShortDynamicLink(IDynamicLinksCallbacks.Stub callback, Bundle parameters) {
        try {
            ((IDynamicLinksService)this.getService()).createShortDynamicLink(callback, parameters);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getMinApkVersion() {
        return 12451000;
    }

    public boolean usesClientTelemetry() {
        return true;
    }
}

