/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.google.a.a.a.a.zza;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.QueryDocumentSnapshot;
import com.google.firebase.firestore.b.zzak;
import com.google.firebase.firestore.b.zzb;
import com.google.firebase.firestore.d.zzc;
import com.google.firebase.firestore.d.zzg;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class DocumentChange {
    private final Type zza;
    private final QueryDocumentSnapshot zzb;
    private final int zzc;
    private final int zzd;

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    private DocumentChange(QueryDocumentSnapshot document, Type type, int oldIndex, int newIndex) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.zza = var2_2;
        this.zzb = var1_1;
        this.zzc = var3_3;
        this.zzd = newIndex;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof DocumentChange) {
            DocumentChange documentChange;
            documentChange = documentChange;
            return this.zza.equals((Object)documentChange.zza) && this.zzb.equals(documentChange.zzb) && this.zzc == documentChange.zzc && this.zzd == documentChange.zzd;
        }
        return false;
    }

    public int hashCode() {
        int n = this.zza.hashCode();
        n = n * 31 + this.zzb.hashCode();
        n = n * 31 + this.zzc;
        n = n * 31 + this.zzd;
        return n;
    }

    @NonNull
    public Type getType() {
        return this.zza;
    }

    @NonNull
    public QueryDocumentSnapshot getDocument() {
        return this.zzb;
    }

    public int getOldIndex() {
        return this.zzc;
    }

    public int getNewIndex() {
        return this.zzd;
    }

    static List<DocumentChange> zza(FirebaseFirestore firebaseFirestore, MetadataChanges metadataChanges, zzak zzak2) {
        ArrayList<DocumentChange> arrayList = new ArrayList<DocumentChange>();
        if (zzak2.zzc().zzb()) {
            int n = 0;
            zzc zzc2 = null;
            for (zzb zzb2 : zzak2.zzd()) {
                zzc zzc3 = zzb2.zza();
                QueryDocumentSnapshot queryDocumentSnapshot = QueryDocumentSnapshot.zzb(firebaseFirestore, zzc3, zzak2.zze());
                com.google.a.a.a.a.zza.zza(zzb2.zzb() == zzb.zza.zzb, "Invalid added event for first snapshot", new Object[0]);
                com.google.a.a.a.a.zza.zza(zzc2 == null || zzak2.zza().zzl().compare(zzc2, zzc3) < 0, "Got added events in wrong order", new Object[0]);
                arrayList.add(new DocumentChange(queryDocumentSnapshot, Type.ADDED, -1, n++));
                zzc2 = zzc3;
            }
        } else {
            zzg zzg2 = zzak2.zzc();
            for (zzb zzb3 : zzak2.zzd()) {
                int n;
                int n2;
                Type type;
                if (metadataChanges == MetadataChanges.EXCLUDE && zzb3.zzb() == zzb.zza.zzd) continue;
                zzc zzc4 = zzb3.zza();
                QueryDocumentSnapshot queryDocumentSnapshot = QueryDocumentSnapshot.zzb(firebaseFirestore, zzc4, zzak2.zze());
                switch (zzb3.zzb()) {
                    case zzb: {
                        type = Type.ADDED;
                        break;
                    }
                    case zzd: 
                    case zzc: {
                        type = Type.MODIFIED;
                        break;
                    }
                    case zza: {
                        type = Type.REMOVED;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown view change type: " + (Object)((Object)zzb3.zzb()));
                    }
                }
                Type type2 = type;
                if (type != Type.ADDED) {
                    n2 = zzg2.zzc(zzc4.zzd());
                    com.google.a.a.a.a.zza.zza(n2 >= 0, "Index for document not found", new Object[0]);
                    zzg2 = zzg2.zzd(zzc4.zzd());
                } else {
                    n2 = -1;
                }
                if (type2 != Type.REMOVED) {
                    n = (zzg2 = zzg2.zza(zzc4)).zzc(zzc4.zzd());
                    com.google.a.a.a.a.zza.zza(n >= 0, "Index for document not found", new Object[0]);
                } else {
                    n = -1;
                }
                arrayList.add(new DocumentChange(queryDocumentSnapshot, type2, n2, n));
            }
        }
        return arrayList;
    }

    public static enum Type {
        ADDED,
        MODIFIED,
        REMOVED;

    }
}

