/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import android.support.annotation.NonNull;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Preconditions;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.Source;
import com.google.firebase.firestore.UserDataConverter;
import com.google.firebase.firestore.b.zzak;
import com.google.firebase.firestore.b.zzd;
import com.google.firebase.firestore.b.zzx;
import com.google.firebase.firestore.b.zzy;
import com.google.firebase.firestore.d.a.zza;
import com.google.firebase.firestore.d.a.zzi;
import com.google.firebase.firestore.d.zze;
import com.google.firebase.firestore.d.zzl;
import com.google.firebase.firestore.g.zzh;
import com.google.firebase.firestore.g.zzj;
import com.google.firebase.firestore.g.zzp;
import com.google.firebase.firestore.g.zzs;
import com.google.firebase.firestore.zzb;
import com.google.firebase.firestore.zzc;
import com.google.firebase.firestore.zzd;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class DocumentReference {
    private final zze zza;
    private final FirebaseFirestore zzb;

    /*
     * WARNING - void declaration
     */
    DocumentReference(zze key, FirebaseFirestore firestore) {
        void var2_2;
        void var1_1;
        this.zza = (zze)Preconditions.checkNotNull((Object)var1_1);
        this.zzb = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static DocumentReference forPath(zzl path, FirebaseFirestore firestore) {
        void var1_1;
        zzl zzl2;
        if (path.zzg() % 2 != 0) {
            throw new IllegalArgumentException("Invalid document reference. Document references must have an even number of segments, but " + path.zzf() + " has " + path.zzg());
        }
        return new DocumentReference(zze.zza(zzl2), (FirebaseFirestore)var1_1);
    }

    final zze zza() {
        return this.zza;
    }

    @NonNull
    public FirebaseFirestore getFirestore() {
        return this.zzb;
    }

    @NonNull
    public String getId() {
        return this.zza.zzd().zzc();
    }

    @NonNull
    public CollectionReference getParent() {
        return new CollectionReference((zzl)this.zza.zzd().zzb(), this.zzb);
    }

    @NonNull
    public String getPath() {
        return this.zza.zzd().zzf();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public CollectionReference collection(@NonNull String collectionPath) {
        void var1_1;
        Preconditions.checkNotNull((Object)collectionPath, (Object)"Provided collection path must not be null.");
        return new CollectionReference(this.zza.zzd().zza(zzl.zzb((String)var1_1)), this.zzb);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> set(@NonNull Map<String, Object> data) {
        void var1_1;
        return this.set((Map<String, Object>)var1_1, SetOptions.zza);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> set(@NonNull Map<String, Object> data, @NonNull SetOptions options) {
        UserDataConverter.ParsedDocumentData parsedDocumentData;
        void var2_2;
        Preconditions.checkNotNull(data, (Object)"Provided data must not be null.");
        Preconditions.checkNotNull((Object)options, (Object)"Provided options must not be null.");
        parsedDocumentData = options.isMerge() ? this.zzb.zzc().parseMergeData(data, var2_2.getFieldMask()) : this.zzb.zzc().parseSetData((Map<String, Object>)((Object)parsedDocumentData));
        return this.zzb.zza().zza(parsedDocumentData.toMutationList(this.zza, zzi.zza)).continueWith(zzj.zzb, zzs.zzc());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> set(@NonNull Object pojo) {
        void var1_1;
        DocumentReference documentReference = this;
        return documentReference.set(documentReference.zzb.zzc().convertPOJO(var1_1), SetOptions.zza);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> set(@NonNull Object pojo, @NonNull SetOptions options) {
        void var2_2;
        void var1_1;
        DocumentReference documentReference = this;
        return documentReference.set(documentReference.zzb.zzc().convertPOJO(var1_1), (SetOptions)var2_2);
    }

    @NonNull
    public Task<Void> update(@NonNull Map<String, Object> data) {
        UserDataConverter.ParsedUpdateData parsedUpdateData;
        parsedUpdateData = this.zzb.zzc().parseUpdateData((Map<String, Object>)((Object)parsedUpdateData));
        return this.zza(parsedUpdateData);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> update(@NonNull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        void var3_3;
        void var2_2;
        UserDataConverter.ParsedUpdateData parsedUpdateData;
        parsedUpdateData = this.zzb.zzc().parseUpdateData(zzs.zza(1, parsedUpdateData, var2_2, (Object[])var3_3));
        return this.zza(parsedUpdateData);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> update(@NonNull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        void var3_3;
        void var2_2;
        UserDataConverter.ParsedUpdateData parsedUpdateData;
        parsedUpdateData = this.zzb.zzc().parseUpdateData(zzs.zza(1, parsedUpdateData, var2_2, (Object[])var3_3));
        return this.zza(parsedUpdateData);
    }

    private Task<Void> zza(@NonNull UserDataConverter.ParsedUpdateData parsedUpdateData) {
        return this.zzb.zza().zza(parsedUpdateData.toMutationList(this.zza, zzi.zza(true))).continueWith(zzj.zzb, zzs.zzc());
    }

    @NonNull
    public Task<Void> delete() {
        return this.zzb.zza().zza(Collections.singletonList(new zza(this.zza, zzi.zza))).continueWith(zzj.zzb, zzs.zzc());
    }

    @NonNull
    public Task<DocumentSnapshot> get() {
        return this.get(Source.DEFAULT);
    }

    @NonNull
    public Task<DocumentSnapshot> get(Source source) {
        Object object;
        if (source == Source.CACHE) {
            return this.zzb.zza().zza(this.zza).continueWith(zzj.zzb, (Continuation)new zzb(this));
        }
        void var2_2 = object;
        object = this;
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        TaskCompletionSource taskCompletionSource2 = new TaskCompletionSource();
        zzd.zza zza2 = new zzd.zza();
        new zzd.zza().zza = true;
        zza2.zzb = true;
        zza2.zzc = true;
        object = ((DocumentReference)object).zza(zzj.zzb, zza2, null, new zzc(taskCompletionSource, taskCompletionSource2, (Source)var2_2));
        taskCompletionSource2.setResult(object);
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull EventListener<DocumentSnapshot> listener) {
        void var1_1;
        return this.addSnapshotListener(MetadataChanges.EXCLUDE, (EventListener<DocumentSnapshot>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull EventListener<DocumentSnapshot> listener) {
        void var2_2;
        void var1_1;
        return this.addSnapshotListener((Executor)var1_1, MetadataChanges.EXCLUDE, (EventListener<DocumentSnapshot>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull EventListener<DocumentSnapshot> listener) {
        void var2_2;
        void var1_1;
        return this.addSnapshotListener((Activity)var1_1, MetadataChanges.EXCLUDE, (EventListener<DocumentSnapshot>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull MetadataChanges metadataChanges, @NonNull EventListener<DocumentSnapshot> listener) {
        void var2_2;
        void var1_1;
        return this.addSnapshotListener(zzj.zza, (MetadataChanges)var1_1, (EventListener<DocumentSnapshot>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull MetadataChanges metadataChanges, @NonNull EventListener<DocumentSnapshot> listener) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)executor, (Object)"Provided executor must not be null.");
        Preconditions.checkNotNull((Object)((Object)metadataChanges), (Object)"Provided MetadataChanges value must not be null.");
        Preconditions.checkNotNull(listener, (Object)"Provided EventListener must not be null.");
        return this.zza((Executor)var1_1, DocumentReference.zza((MetadataChanges)var2_2), null, (EventListener<DocumentSnapshot>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull MetadataChanges metadataChanges, @NonNull EventListener<DocumentSnapshot> listener) {
        void var3_3;
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull((Object)activity, (Object)"Provided activity must not be null.");
        Preconditions.checkNotNull((Object)((Object)metadataChanges), (Object)"Provided MetadataChanges value must not be null.");
        Preconditions.checkNotNull(listener, (Object)"Provided EventListener must not be null.");
        return this.zza(zzj.zza, DocumentReference.zza((MetadataChanges)var2_2), (Activity)var1_1, (EventListener<DocumentSnapshot>)var3_3);
    }

    private ListenerRegistration zza(Executor object, zzd.zza object2, @Nullable Activity activity, EventListener<DocumentSnapshot> object3) {
        object = new zzh((Executor)object, new zzd(this, (EventListener)object3));
        object3 = this.zzb();
        object2 = this.zzb.zza().zza((zzx)object3, (zzd.zza)object2, (EventListener<zzak>)object);
        return new zzp(this.zzb.zza(), (zzy)object2, activity, (zzh<zzak>)object);
    }

    public boolean equals(Object o) {
        DocumentReference documentReference;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        documentReference = documentReference;
        return this.zza.equals(documentReference.zza) && this.zzb.equals(documentReference.zzb);
    }

    public int hashCode() {
        int n = this.zza.hashCode();
        n = n * 31 + this.zzb.hashCode();
        return n;
    }

    private zzx zzb() {
        return zzx.zza(this.zza.zzd());
    }

    private static zzd.zza zza(MetadataChanges metadataChanges) {
        zzd.zza zza2 = new zzd.zza();
        new zzd.zza().zza = metadataChanges == MetadataChanges.INCLUDE;
        zza2.zzb = metadataChanges == MetadataChanges.INCLUDE;
        zza2.zzc = false;
        return zza2;
    }

    final /* synthetic */ void zza(EventListener eventListener, zzak object, FirebaseFirestoreException object2) {
        if (object != null) {
            com.google.a.a.a.a.zza.zza(((zzak)object).zzb().zza() <= 1, "Too many documents returned on a document query", new Object[0]);
            object2 = ((zzak)object).zzb().zzb(this.zza);
            object = object2 != null ? DocumentSnapshot.zza(this.zzb, (com.google.firebase.firestore.d.zzc)object2, ((zzak)object).zze()) : DocumentSnapshot.zza(this.zzb, this.zza, ((zzak)object).zze());
            eventListener.onEvent(object, null);
            return;
        }
        com.google.a.a.a.a.zza.zza(object2 != null, "Got event without value or error set", new Object[0]);
        eventListener.onEvent(null, (FirebaseFirestoreException)((Object)object2));
    }

    static final /* synthetic */ void zza(TaskCompletionSource taskCompletionSource, TaskCompletionSource object, Source source, DocumentSnapshot documentSnapshot, FirebaseFirestoreException firebaseFirestoreException) {
        block6: {
            if (firebaseFirestoreException != null) {
                taskCompletionSource.setException((Exception)((Object)firebaseFirestoreException));
                return;
            }
            try {
                object = (ListenerRegistration)Tasks.await((Task)object.getTask());
                object.remove();
                if (!documentSnapshot.exists() && documentSnapshot.getMetadata().isFromCache()) {
                    taskCompletionSource.setException((Exception)((Object)new FirebaseFirestoreException("Failed to get document because the client is offline.", FirebaseFirestoreException.Code.UNAVAILABLE)));
                    break block6;
                }
                if (documentSnapshot.exists() && documentSnapshot.getMetadata().isFromCache() && source == Source.SERVER) {
                    taskCompletionSource.setException((Exception)((Object)new FirebaseFirestoreException("Failed to get document from server. (However, this document does exist in the local cache. Run again without setting source to SERVER to retrieve the cached document.)", FirebaseFirestoreException.Code.UNAVAILABLE)));
                    break block6;
                }
                taskCompletionSource.setResult((Object)documentSnapshot);
                return;
            }
            catch (ExecutionException executionException) {
                object = executionException;
                com.google.a.a.a.a.zza.zza(executionException, "Failed to register a listener for a single document", new Object[0]);
                return;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                com.google.a.a.a.a.zza.zza(interruptedException, "Failed to register a listener for a single document", new Object[0]);
            }
        }
    }

    final /* synthetic */ DocumentSnapshot zza(Task task) throws Exception {
        return new DocumentSnapshot(this.zzb, this.zza, (com.google.firebase.firestore.d.zzc)task.getResult(), true);
    }
}

