/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.common.base.Preconditions;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.SnapshotMetadata;
import com.google.firebase.firestore.d.b.zza;
import com.google.firebase.firestore.d.b.zze;
import com.google.firebase.firestore.d.b.zzf;
import com.google.firebase.firestore.d.b.zzk;
import com.google.firebase.firestore.d.b.zzl;
import com.google.firebase.firestore.d.zzb;
import com.google.firebase.firestore.d.zzc;
import com.google.firebase.firestore.d.zzi;
import com.google.firebase.firestore.g.zzg;
import com.google.firebase.firestore.g.zzq;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class DocumentSnapshot {
    private final FirebaseFirestore zza;
    private final com.google.firebase.firestore.d.zze zzb;
    @Nullable
    private final zzc zzc;
    private final SnapshotMetadata zzd;

    /*
     * WARNING - void declaration
     */
    DocumentSnapshot(FirebaseFirestore firestore, com.google.firebase.firestore.d.zze key, @Nullable zzc doc, boolean isFromCache) {
        void var3_4;
        void var2_3;
        void var1_1;
        this.zza = (FirebaseFirestore)Preconditions.checkNotNull((Object)var1_1);
        this.zzb = (com.google.firebase.firestore.d.zze)Preconditions.checkNotNull((Object)var2_3);
        this.zzc = var3_4;
        boolean bl = this.zzc != null && this.zzc.zzc();
        this.zzd = new SnapshotMetadata(bl, isFromCache);
    }

    static DocumentSnapshot zza(FirebaseFirestore firebaseFirestore, zzc zzc2, boolean bl) {
        return new DocumentSnapshot(firebaseFirestore, zzc2.zzd(), zzc2, bl);
    }

    static DocumentSnapshot zza(FirebaseFirestore firebaseFirestore, com.google.firebase.firestore.d.zze zze2, boolean bl) {
        return new DocumentSnapshot(firebaseFirestore, zze2, null, bl);
    }

    @NonNull
    public String getId() {
        return this.zzb.zzd().zzc();
    }

    @NonNull
    public SnapshotMetadata getMetadata() {
        return this.zzd;
    }

    public boolean exists() {
        return this.zzc != null;
    }

    @Nullable
    final zzc zza() {
        return this.zzc;
    }

    @Nullable
    public Map<String, Object> getData() {
        return this.getData(ServerTimestampBehavior.zza);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Map<String, Object> getData(@NonNull ServerTimestampBehavior serverTimestampBehavior) {
        void var1_1;
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        if (this.zzc == null) {
            return null;
        }
        DocumentSnapshot documentSnapshot = this;
        return documentSnapshot.zza(documentSnapshot.zzc.zzb(), zzf.zza((ServerTimestampBehavior)var1_1, this.zza.getFirestoreSettings().areTimestampsInSnapshotsEnabled()));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public <T> T toObject(@NonNull Class<T> valueType) {
        void var1_1;
        return this.toObject((Class<T>)var1_1, ServerTimestampBehavior.zza);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public <T> T toObject(@NonNull Class<T> valueType, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        void var1_1;
        Map<String, Object> map;
        Preconditions.checkNotNull(valueType, (Object)"Provided POJO type must not be null.");
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        map = this.getData((ServerTimestampBehavior)((Object)map));
        if (map == null) {
            return null;
        }
        return zzg.zza(map, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(@NonNull String field) {
        void var1_1;
        return this.contains(FieldPath.zza((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(@NonNull FieldPath fieldPath) {
        void var1_1;
        Preconditions.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zzc != null && this.zzc.zza(var1_1.zza()) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object get(@NonNull String field) {
        void var1_1;
        return this.get(FieldPath.zza((String)var1_1), ServerTimestampBehavior.zza);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object get(@NonNull String field, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        void var2_2;
        void var1_1;
        return this.get(FieldPath.zza((String)var1_1), (ServerTimestampBehavior)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object get(@NonNull FieldPath fieldPath) {
        void var1_1;
        return this.get((FieldPath)var1_1, ServerTimestampBehavior.zza);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object get(@NonNull FieldPath fieldPath, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        return this.zza(var1_1.zza(), zzf.zza((ServerTimestampBehavior)var2_2, this.zza.getFirestoreSettings().areTimestampsInSnapshotsEnabled()));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Boolean getBoolean(@NonNull String field) {
        void var1_1;
        return this.zza((String)var1_1, Boolean.class, ServerTimestampBehavior.zza);
    }

    @Nullable
    public Double getDouble(@NonNull String field) {
        Number number;
        if ((number = this.zza((String)((Object)number), Number.class, ServerTimestampBehavior.zza)) != null) {
            return number.doubleValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getString(@NonNull String field) {
        void var1_1;
        return this.zza((String)var1_1, String.class, ServerTimestampBehavior.zza);
    }

    @Nullable
    public Long getLong(@NonNull String field) {
        Number number;
        if ((number = this.zza((String)((Object)number), Number.class, ServerTimestampBehavior.zza)) != null) {
            return number.longValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Date getDate(@NonNull String field) {
        void var1_1;
        return this.getDate((String)var1_1, ServerTimestampBehavior.zza);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Date getDate(@NonNull String field, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        void var1_1;
        Object object;
        Preconditions.checkNotNull((Object)field, (Object)"Provided field path must not be null.");
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        object = this.zza(FieldPath.zza(field).zza(), zzf.zza((ServerTimestampBehavior)((Object)object), false));
        return DocumentSnapshot.zza(object, (String)var1_1, Date.class);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Timestamp getTimestamp(@NonNull String field) {
        void var1_1;
        return this.getTimestamp((String)var1_1, ServerTimestampBehavior.zza);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Timestamp getTimestamp(@NonNull String field, @NonNull ServerTimestampBehavior serverTimestampBehavior) {
        void var1_1;
        Object object;
        Preconditions.checkNotNull((Object)field, (Object)"Provided field path must not be null.");
        Preconditions.checkNotNull((Object)((Object)serverTimestampBehavior), (Object)"Provided serverTimestampBehavior value must not be null.");
        object = this.zza(FieldPath.zza(field).zza(), zzf.zza((ServerTimestampBehavior)((Object)object), true));
        return DocumentSnapshot.zza(object, (String)var1_1, Timestamp.class);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Blob getBlob(@NonNull String field) {
        void var1_1;
        return this.zza((String)var1_1, Blob.class, ServerTimestampBehavior.zza);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public GeoPoint getGeoPoint(@NonNull String field) {
        void var1_1;
        return this.zza((String)var1_1, GeoPoint.class, ServerTimestampBehavior.zza);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public DocumentReference getDocumentReference(@NonNull String field) {
        void var1_1;
        return this.zza((String)var1_1, DocumentReference.class, ServerTimestampBehavior.zza);
    }

    @NonNull
    public DocumentReference getReference() {
        return new DocumentReference(this.zzb, this.zza);
    }

    @Nullable
    private <T> T zza(String string, Class<T> clazz, ServerTimestampBehavior object) {
        Preconditions.checkNotNull((Object)string, (Object)"Provided field must not be null.");
        Preconditions.checkNotNull((Object)object, (Object)"Provided serverTimestampBehavior value must not be null.");
        object = this.get(string, (ServerTimestampBehavior)((Object)object));
        return DocumentSnapshot.zza(object, string, clazz);
    }

    @Nullable
    private static <T> T zza(Object object, String string, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (!clazz.isInstance(object)) {
            throw new RuntimeException("Field '" + string + "' is not a " + clazz.getName());
        }
        return clazz.cast(object);
    }

    @Nullable
    private Object zza(zze object, zzf iterator) {
        if (object instanceof zzk) {
            return this.zza((zzk)object, (zzf)((Object)iterator));
        }
        if (object instanceof zza) {
            zzf zzf2 = iterator;
            iterator = (zza)object;
            object = this;
            ArrayList<Object> arrayList = new ArrayList<Object>(((zza)((Object)iterator)).zzb().size());
            for (zze zze2 : ((zza)((Object)iterator)).zzb()) {
                arrayList.add(super.zza(zze2, zzf2));
            }
            return arrayList;
        }
        if (object instanceof zzl) {
            Comparable<zze> comparable = (zzl)object;
            iterator = (com.google.firebase.firestore.d.zze)((zze)comparable).zza((zzf)((Object)iterator));
            if (!((zzb)(object = ((zzl)object).zzb())).equals(comparable = this.zza.zzb())) {
                zzq.zza("DocumentSnapshot", String.format("Document %s contains a document reference within a different database (%s/%s) which is not supported. It will be treated as a reference in the current database (%s/%s) instead.", ((com.google.firebase.firestore.d.zze)((Object)iterator)).zzd(), ((zzb)object).zza(), ((zzb)object).zzb(), ((zzb)comparable).zza(), ((zzb)comparable).zzb()), new Object[0]);
            }
            return new DocumentReference((com.google.firebase.firestore.d.zze)((Object)iterator), this.zza);
        }
        return ((zze)object).zza((zzf)((Object)iterator));
    }

    private Map<String, Object> zza(zzk object, zzf zzf2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry entry : ((zzk)object).zzd()) {
            hashMap.put((String)entry.getKey(), this.zza((zze)entry.getValue(), zzf2));
        }
        return hashMap;
    }

    @Nullable
    private Object zza(@NonNull zzi comparable, @NonNull zzf zzf2) {
        if (this.zzc != null && (comparable = this.zzc.zza((zzi)comparable)) != null) {
            return this.zza((zze)comparable, zzf2);
        }
        return null;
    }

    public boolean equals(@Nullable Object obj) {
        DocumentSnapshot documentSnapshot;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DocumentSnapshot)) {
            return false;
        }
        documentSnapshot = documentSnapshot;
        return this.zza.equals(documentSnapshot.zza) && this.zzb.equals(documentSnapshot.zzb) && (this.zzc == null ? documentSnapshot.zzc == null : this.zzc.equals(documentSnapshot.zzc)) && this.zzd.equals(documentSnapshot.zzd);
    }

    public int hashCode() {
        int n = this.zza.hashCode();
        n = n * 31 + this.zzb.hashCode();
        n = n * 31 + (this.zzc != null ? this.zzc.hashCode() : 0);
        n = n * 31 + this.zzd.hashCode();
        return n;
    }

    public String toString() {
        return "DocumentSnapshot{key=" + this.zzb + ", metadata=" + this.zzd + ", doc=" + this.zzc + '}';
    }

    public static enum ServerTimestampBehavior {
        NONE,
        ESTIMATE,
        PREVIOUS;

        static final ServerTimestampBehavior zza;

        static {
            zza = NONE;
        }
    }
}

