/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.common.base.Preconditions;
import com.google.firebase.firestore.d.zzi;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public final class FieldPath {
    private static final Pattern zza = Pattern.compile("[~*/\\[\\]]");
    private final zzi zzb;
    private static final FieldPath zzc = new FieldPath(zzi.zzb);

    /*
     * WARNING - void declaration
     */
    private FieldPath(List<String> segments) {
        void var1_1;
        this.zzb = zzi.zzb((List<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private FieldPath(zzi internalPath) {
        void var1_1;
        this.zzb = var1_1;
    }

    final zzi zza() {
        return this.zzb;
    }

    public static FieldPath of(String ... fieldNames) {
        String[] stringArray;
        Preconditions.checkArgument((fieldNames.length > 0 ? 1 : 0) != 0, (Object)"Invalid field path. Provided path must not be empty.");
        for (int i = 0; i < fieldNames.length; ++i) {
            Preconditions.checkArgument((fieldNames[i] != null && !fieldNames[i].isEmpty() ? 1 : 0) != 0, (Object)("Invalid field name at argument " + (i + 1) + ". Field names must not be null or empty."));
        }
        return new FieldPath(Arrays.asList(stringArray));
    }

    @NonNull
    public static FieldPath documentId() {
        return zzc;
    }

    static FieldPath zza(@NonNull String string) {
        Preconditions.checkNotNull((Object)string, (Object)"Provided field path must not be null.");
        Preconditions.checkArgument((!zza.matcher(string).find() ? 1 : 0) != 0, (Object)("Invalid field path (" + string + "). Paths must not contain '~', '*', '/', '[', or ']'"));
        try {
            return FieldPath.of(string.split("\\.", -1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid field path (" + string + "). Paths must not be empty, begin with '.', end with '.', or contain '..'");
        }
    }

    public final String toString() {
        return this.zzb.toString();
    }

    public final boolean equals(Object o) {
        FieldPath fieldPath;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        fieldPath = fieldPath;
        return this.zzb.equals(fieldPath.zzb);
    }

    public final int hashCode() {
        return this.zzb.hashCode();
    }
}

