/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.firebase.firestore.g.zzs;

public class GeoPoint
implements Comparable<GeoPoint> {
    private final double zza;
    private final double zzb;

    /*
     * WARNING - void declaration
     */
    public GeoPoint(double latitude, double longitude) {
        void var3_2;
        void var1_1;
        if (Double.isNaN(latitude) || latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("Latitude must be in the range of [-90, 90]");
        }
        if (Double.isNaN(longitude) || longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("Longitude must be in the range of [-180, 180]");
        }
        this.zza = var1_1;
        this.zzb = var3_2;
    }

    public double getLatitude() {
        return this.zza;
    }

    public double getLongitude() {
        return this.zzb;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(@NonNull GeoPoint other) {
        int n = zzs.zza(this.zza, other.zza);
        if (n == 0) {
            void var1_1;
            return zzs.zza(this.zzb, var1_1.zzb);
        }
        return n;
    }

    @NonNull
    public String toString() {
        return "GeoPoint { latitude=" + this.zza + ", longitude=" + this.zzb + " }";
    }

    public boolean equals(@Nullable Object o) {
        GeoPoint geoPoint;
        if (!(o instanceof GeoPoint)) {
            return false;
        }
        geoPoint = geoPoint;
        return this.zza == geoPoint.zza && this.zzb == geoPoint.zzb;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.zza);
        int n = (int)(l ^ l >>> 32);
        long l2 = l = Double.doubleToLongBits(this.zzb);
        n = n * 31 + (int)(l2 ^ l2 >>> 32);
        return n;
    }
}

