/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import com.google.common.base.Preconditions;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FieldValue;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.d.a.zzc;
import com.google.firebase.firestore.d.a.zzd;
import com.google.firebase.firestore.d.a.zzh;
import com.google.firebase.firestore.d.a.zzj;
import com.google.firebase.firestore.d.b.zze;
import com.google.firebase.firestore.d.b.zzi;
import com.google.firebase.firestore.d.b.zzk;
import com.google.firebase.firestore.d.b.zzl;
import com.google.firebase.firestore.d.b.zzn;
import com.google.firebase.firestore.d.b.zzo;
import com.google.firebase.firestore.g.zzg;
import com.google.firebase.firestore.g.zzs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class UserDataConverter {
    private final com.google.firebase.firestore.d.zzb zza;

    private static boolean zzb(zzb zzb2) {
        switch (zzb2) {
            case zza: 
            case zzb: 
            case zzc: {
                return true;
            }
            case zzd: {
                return false;
            }
        }
        throw com.google.a.a.a.a.zza.zza("Unexpected case for UserDataSource: %s", zzb2.name());
    }

    /*
     * WARNING - void declaration
     */
    public UserDataConverter(com.google.firebase.firestore.d.zzb databaseId) {
        void var1_1;
        this.zza = var1_1;
    }

    public final ParsedDocumentData parseSetData(Map<String, Object> input) {
        zze zze2;
        zza zza2 = new zza(this, zzb.zza, com.google.firebase.firestore.d.zzi.zzc);
        zze2 = this.zza(zze2, zza2);
        com.google.a.a.a.a.zza.zza(zze2 instanceof zzk, "Parse result should be an object.", new Object[0]);
        return new ParsedDocumentData((zzk)zze2, null, Collections.unmodifiableList(zza2.zze));
    }

    /*
     * WARNING - void declaration
     */
    public final ParsedDocumentData parseMergeData(Map<String, Object> input, @Nullable com.google.firebase.firestore.d.a.zzb fieldMask) {
        void var2_2;
        ArrayList<zzc> arrayList;
        zze zze2;
        zza zza2 = new zza(this, zzb.zzb, com.google.firebase.firestore.d.zzi.zzc);
        zze2 = this.zza(zze2, zza2);
        com.google.a.a.a.a.zza.zza(zze2 instanceof zzk, "Parse result should be an object.", new Object[0]);
        if (fieldMask == null) {
            fieldMask = com.google.firebase.firestore.d.a.zzb.zza(zza2.zzf);
            arrayList = zza2.zze;
        } else {
            for (com.google.firebase.firestore.d.zzi object : fieldMask.zza()) {
                if (zza2.zzb(object)) continue;
                throw new IllegalArgumentException("Field '" + object.toString() + "' is specified in your field mask but not in your input data.");
            }
            arrayList = new ArrayList<zzc>();
            for (zzc zzc2 : zza2.zze) {
                if (!fieldMask.zza(zzc2.zza())) continue;
                arrayList.add(zzc2);
            }
        }
        return new ParsedDocumentData((zzk)zze2, (com.google.firebase.firestore.d.a.zzb)var2_2, arrayList);
    }

    public final ParsedUpdateData parseUpdateData(Map<String, Object> data) {
        com.google.firebase.firestore.d.a.zzb zzb2;
        Preconditions.checkNotNull(data, (Object)"Provided update data must not be null.");
        ArrayList<com.google.firebase.firestore.d.zzi> arrayList = new ArrayList<com.google.firebase.firestore.d.zzi>();
        zzk zzk2 = zzk.zzb();
        zza zza2 = new zza(this, zzb.zzc, com.google.firebase.firestore.d.zzi.zzc);
        for (Map.Entry entry : zzb2.entrySet()) {
            com.google.firebase.firestore.d.zzi zzi2 = FieldPath.zza((String)entry.getKey()).zza();
            Object v = entry.getValue();
            if (v instanceof FieldValue.zza) {
                arrayList.add(zzi2);
                continue;
            }
            zze zze2 = this.zza(v, zza2.zza(zzi2));
            if (zze2 == null) continue;
            arrayList.add(zzi2);
            zzk2 = zzk2.zza(zzi2, zze2);
        }
        zzb2 = com.google.firebase.firestore.d.a.zzb.zza(arrayList);
        return new ParsedUpdateData(zzk2, zzb2, Collections.unmodifiableList(zza2.zze));
    }

    public final ParsedUpdateData parseUpdateData(List<Object> fieldsAndValues) {
        Object object;
        Iterator iterator;
        zza zza2 = new zza(this, zzb.zzc, com.google.firebase.firestore.d.zzi.zzc);
        ArrayList<com.google.firebase.firestore.d.zzi> arrayList = new ArrayList<com.google.firebase.firestore.d.zzi>();
        zzk zzk2 = zzk.zzb();
        com.google.a.a.a.a.zza.zza(fieldsAndValues.size() % 2 == 0, "Expected fieldAndValues to contain an even number of elements", new Object[0]);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Object object2 = iterator.next();
            com.google.a.a.a.a.zza.zza(object instanceof String || object instanceof FieldPath, "Expected argument to be String or FieldPath.", new Object[0]);
            object = object instanceof String ? FieldPath.zza((String)object).zza() : ((FieldPath)object).zza();
            if (object2 instanceof FieldValue.zza) {
                arrayList.add((com.google.firebase.firestore.d.zzi)object);
                continue;
            }
            if ((object2 = this.zza(object2, zza2.zza((com.google.firebase.firestore.d.zzi)object))) == null) continue;
            arrayList.add((com.google.firebase.firestore.d.zzi)object);
            zzk2 = zzk2.zza((com.google.firebase.firestore.d.zzi)object, (zze)object2);
        }
        object = com.google.firebase.firestore.d.a.zzb.zza(arrayList);
        return new ParsedUpdateData(zzk2, (com.google.firebase.firestore.d.a.zzb)object, zza2.zze);
    }

    public final zze parseQueryValue(Object input) {
        zze zze2;
        zza zza2 = new zza(this, zzb.zzd, com.google.firebase.firestore.d.zzi.zzc);
        com.google.a.a.a.a.zza.zza((zze2 = this.zza(zze2, zza2)) != null, "Parsed data should not be null.", new Object[0]);
        com.google.a.a.a.a.zza.zza(zza2.zze.size() == 0, "Field transforms should have been disallowed.", new Object[0]);
        return zze2;
    }

    public final Map<String, Object> convertPOJO(Object pojo) {
        Map map;
        Preconditions.checkNotNull((Object)pojo, (Object)"Provided data must not be null.");
        String string = "Invalid data. Data must be a Map<String, Object> or a suitable POJO object, but it was ";
        if (pojo.getClass().isArray()) {
            throw new IllegalArgumentException(string + "an array");
        }
        Object object = zzg.zza(pojo);
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException(string + "of type: " + zzs.zza(map));
        }
        map = (Map)object;
        return map;
    }

    @Nullable
    private zze zza(Object object, zza zza2) {
        if (object instanceof List) {
            if (zza2.zzc) {
                throw zza2.zzb("Nested arrays are not supported");
            }
            if (zza2.zzb != null) {
                zza2.zzf.add(zza2.zzb);
            }
            return this.zza((List)object, zza2);
        }
        if (object instanceof Map) {
            return this.zza((Map)object, zza2);
        }
        if (zza2.zzb != null) {
            zza2.zzf.add(zza2.zzb);
        }
        return this.zzb(object, zza2);
    }

    private <T> com.google.firebase.firestore.d.b.zza zza(List<T> object, zza zza2) {
        ArrayList<zze> arrayList = new ArrayList<zze>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            if ((object2 = this.zza(object2, zza2.zza())) == null) {
                object2 = zzi.zzb();
            }
            arrayList.add((zze)object2);
        }
        return com.google.firebase.firestore.d.b.zza.zza(arrayList);
    }

    private <K, V> zzk zza(Map<K, V> object, zza zza2) {
        HashMap<String, zze> hashMap = new HashMap<String, zze>();
        for (Map.Entry entry : object.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw zza2.zzb(String.format("Non-String Map key (%s) is not allowed", entry.getValue()));
            }
            String string = (String)entry.getKey();
            zze object2 = this.zza(entry.getValue(), zza2.zza(string));
            if (object2 == null) continue;
            hashMap.put(string, object2);
        }
        return zzk.zza(hashMap);
    }

    @Nullable
    private zze zzb(Object object, zza zza2) {
        if (object == null) {
            return zzi.zzb();
        }
        if (object instanceof Integer) {
            return com.google.firebase.firestore.d.b.zzh.zza(((Integer)object).longValue());
        }
        if (object instanceof Long) {
            return com.google.firebase.firestore.d.b.zzh.zza((Long)object);
        }
        if (object instanceof Float) {
            return com.google.firebase.firestore.d.b.zzd.zza(((Float)object).doubleValue());
        }
        if (object instanceof Double) {
            return com.google.firebase.firestore.d.b.zzd.zza((Double)object);
        }
        if (object instanceof Boolean) {
            return com.google.firebase.firestore.d.b.zzc.zza((Boolean)object);
        }
        if (object instanceof String) {
            return zzn.zza((String)object);
        }
        if (object instanceof Date) {
            return zzo.zza(new Timestamp((Date)object));
        }
        if (object instanceof Timestamp) {
            object = (Timestamp)object;
            long l = ((Timestamp)object).getSeconds();
            int n = ((Timestamp)object).getNanoseconds() / 1000 * 1000;
            return zzo.zza(new Timestamp(l, n));
        }
        if (object instanceof GeoPoint) {
            return com.google.firebase.firestore.d.b.zzg.zza((GeoPoint)object);
        }
        if (object instanceof Blob) {
            return com.google.firebase.firestore.d.b.zzb.zza((Blob)object);
        }
        if (object instanceof DocumentReference) {
            com.google.firebase.firestore.d.zzb zzb2;
            if (((DocumentReference)(object = (DocumentReference)object)).getFirestore() != null && !(zzb2 = ((DocumentReference)object).getFirestore().zzb()).equals(this.zza)) {
                throw zza2.zzb(String.format("Document reference is for database %s/%s but should be for database %s/%s", zzb2.zza(), zzb2.zzb(), this.zza.zza(), this.zza.zzb()));
            }
            return zzl.zza(this.zza, ((DocumentReference)object).zza());
        }
        if (object instanceof FieldValue) {
            if (object instanceof FieldValue.zza) {
                if (zza2.zzd == zzb.zzb) {
                    return null;
                }
                if (zza2.zzd == zzb.zzc) {
                    com.google.a.a.a.a.zza.zza(zza2.zzb == null || zza2.zzb.zzg() > 0, "FieldValue.delete() at the top level should have already been handled.", new Object[0]);
                    throw zza2.zzb("FieldValue.delete() can only appear at the top level of your update data");
                }
                throw zza2.zzb("FieldValue.delete() can only be used with update() and set() with SetOptions.merge()");
            }
            if (object instanceof FieldValue.zzb) {
                if (!UserDataConverter.zzb(zza2.zzd)) {
                    throw zza2.zzb("FieldValue.serverTimestamp() can only be used with set() and update().");
                }
                if (zza2.zzb == null) {
                    throw zza2.zzb("FieldValue.serverTimestamp() is not currently supported inside arrays");
                }
                zza2.zze.add(new zzc(zza2.zzb, zzc.zzb.zza()));
                return null;
            }
            throw com.google.a.a.a.a.zza.zza("Unknown FieldValue type: %s", zzs.zza(object));
        }
        if (object.getClass().isArray()) {
            throw zza2.zzb("Arrays are not supported; use a List instead");
        }
        throw zza2.zzb("Unsupported type: " + zzs.zza(object));
    }

    class zza {
        private final Pattern zza = Pattern.compile("^__.*__$");
        @Nullable
        private final com.google.firebase.firestore.d.zzi zzb;
        private final boolean zzc;
        private final zzb zzd;
        private final ArrayList<zzc> zze;
        private final SortedSet<com.google.firebase.firestore.d.zzi> zzf;
        private /* synthetic */ UserDataConverter zzg;

        private zza(UserDataConverter userDataConverter, zzb zzb2, @Nullable com.google.firebase.firestore.d.zzi zzi2, boolean bl, ArrayList<zzc> arrayList, SortedSet<com.google.firebase.firestore.d.zzi> sortedSet) {
            this.zzg = userDataConverter;
            this.zzd = zzb2;
            this.zzb = zzi2;
            this.zzc = bl;
            this.zze = arrayList;
            this.zzf = sortedSet;
        }

        zza(UserDataConverter userDataConverter, zzb zzb2, @Nullable com.google.firebase.firestore.d.zzi zzi2) {
            this(userDataConverter, zzb2, zzi2, false, new ArrayList<zzc>(), new TreeSet<com.google.firebase.firestore.d.zzi>());
            this.zzb();
        }

        final zza zza(String string) {
            Object object = this.zzb == null ? null : (com.google.firebase.firestore.d.zzi)((Object)this.zzb.zza(string));
            object = new zza(this.zzg, this.zzd, (com.google.firebase.firestore.d.zzi)object, false, this.zze, this.zzf);
            ((zza)object).zzc(string);
            return object;
        }

        final zza zza(com.google.firebase.firestore.d.zzi object) {
            object = this.zzb == null ? null : this.zzb.zza(object);
            object = new zza(this.zzg, this.zzd, (com.google.firebase.firestore.d.zzi)object, false, this.zze, this.zzf);
            ((zza)object).zzb();
            return object;
        }

        final zza zza() {
            return new zza(this.zzg, this.zzd, null, true, this.zze, this.zzf);
        }

        final RuntimeException zzb(String string) {
            String string2 = this.zzb == null || this.zzb.zze() ? "" : " (found in field " + this.zzb.toString() + ")";
            return new IllegalArgumentException("Invalid data. " + string + string2);
        }

        final boolean zzb(com.google.firebase.firestore.d.zzi zzi2) {
            for (com.google.firebase.firestore.d.zzi object : this.zzf) {
                if (!zzi2.zzc(object)) continue;
                return true;
            }
            for (zzc zzc2 : this.zze) {
                if (!zzi2.zzc(zzc2.zza())) continue;
                return true;
            }
            return false;
        }

        private void zzb() {
            if (this.zzb == null) {
                return;
            }
            for (int i = 0; i < this.zzb.zzg(); ++i) {
                zza zza2 = this;
                zza2.zzc(zza2.zzb.zza(i));
            }
        }

        private void zzc(String string) {
            if (UserDataConverter.zzb(this.zzd) && this.zza.matcher(string).find()) {
                throw this.zzb("Document fields cannot begin and end with __");
            }
        }
    }

    static final class zzb
    extends Enum<zzb> {
        public static final /* enum */ zzb zza = new zzb();
        public static final /* enum */ zzb zzb = new zzb();
        public static final /* enum */ zzb zzc = new zzb();
        public static final /* enum */ zzb zzd = new zzb();
        private static final /* synthetic */ zzb[] zze;

        public static zzb[] values() {
            return (zzb[])zze.clone();
        }

        static {
            zze = new zzb[]{zza, zzb, zzc, zzd};
        }
    }

    public static class ParsedUpdateData {
        private final zzk zza;
        private final com.google.firebase.firestore.d.a.zzb zzb;
        private final List<zzc> zzc;

        /*
         * WARNING - void declaration
         */
        public ParsedUpdateData(zzk data, com.google.firebase.firestore.d.a.zzb fieldMask, List<zzc> fieldTransforms) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
            this.zzc = var3_3;
        }

        public zzk getData() {
            return this.zza;
        }

        public com.google.firebase.firestore.d.a.zzb getFieldMask() {
            return this.zzb;
        }

        public List<zzc> getFieldTransforms() {
            return this.zzc;
        }

        /*
         * WARNING - void declaration
         */
        public List<zzd> toMutationList(com.google.firebase.firestore.d.zze key, com.google.firebase.firestore.d.a.zzi precondition) {
            void var2_2;
            ArrayList<zzd> arrayList = new ArrayList<zzd>();
            arrayList.add(new zzh(key, this.zza, this.zzb, (com.google.firebase.firestore.d.a.zzi)var2_2));
            if (!this.zzc.isEmpty()) {
                void var1_1;
                arrayList.add(new com.google.firebase.firestore.d.a.zzk((com.google.firebase.firestore.d.zze)var1_1, this.zzc));
            }
            return arrayList;
        }
    }

    public static class ParsedDocumentData {
        private final zzk zza;
        @Nullable
        private final com.google.firebase.firestore.d.a.zzb zzb;
        private final List<zzc> zzc;

        /*
         * WARNING - void declaration
         */
        public ParsedDocumentData(zzk data, @Nullable com.google.firebase.firestore.d.a.zzb fieldMask, List<zzc> fieldTransforms) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var2_2;
            this.zzc = var3_3;
        }

        public zzk getData() {
            return this.zza;
        }

        public List<zzc> getFieldTransforms() {
            return this.zzc;
        }

        /*
         * WARNING - void declaration
         */
        public List<zzd> toMutationList(com.google.firebase.firestore.d.zze key, com.google.firebase.firestore.d.a.zzi precondition) {
            ArrayList<zzd> arrayList = new ArrayList<zzd>();
            if (this.zzb != null) {
                arrayList.add(new zzh(key, this.zza, this.zzb, precondition));
            } else {
                void var2_2;
                arrayList.add(new zzj(key, this.zza, (com.google.firebase.firestore.d.a.zzi)var2_2));
            }
            if (!this.zzc.isEmpty()) {
                void var1_1;
                arrayList.add(new com.google.firebase.firestore.d.a.zzk((com.google.firebase.firestore.d.zze)var1_1, this.zzc));
            }
            return arrayList;
        }
    }
}

