/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.g;

import com.google.firebase.Timestamp;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.Exclude;
import com.google.firebase.firestore.FieldValue;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.IgnoreExtraProperties;
import com.google.firebase.firestore.PropertyName;
import com.google.firebase.firestore.ServerTimestamp;
import com.google.firebase.firestore.ThrowOnExtraProperties;
import com.google.firebase.firestore.g.zzq;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class zzg {
    private static final ConcurrentMap<Class<?>, zza<?>> zza = new ConcurrentHashMap();

    private static void zzb(boolean bl, String string) {
        if (!bl) {
            throw new RuntimeException("Hard assert failed: " + string);
        }
    }

    public static Object zza(Object object) {
        return zzg.zzb(object, zzb.zza);
    }

    public static <T> T zza(Object object, Class<T> clazz) {
        return zzg.zza(object, clazz, zzb.zza);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> Object zzb(T object2, zzb zzb2) {
        void var1_5;
        if (var1_5.zza() > 500) {
            throw zzg.zzb((zzb)var1_5, "Exceeded maximum depth of 500, which likely indicates there's an object cycle");
        }
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof Number) {
            if (object2 instanceof Float) {
                return ((Float)object2).doubleValue();
            }
            if (object2 instanceof Short) {
                throw zzg.zzb((zzb)var1_5, "Shorts are not supported, please use int or long");
            }
            if (object2 instanceof Byte) {
                throw zzg.zzb((zzb)var1_5, "Bytes are not supported, please use int or long");
            }
            return object2;
        }
        if (object2 instanceof String) {
            return object2;
        }
        if (object2 instanceof Boolean) {
            return object2;
        }
        if (object2 instanceof Character) {
            throw zzg.zzb((zzb)var1_5, "Characters are not supported, please use Strings.");
        }
        if (object2 instanceof Map) {
            HashMap hashMap = new HashMap();
            for (Map.Entry entry : ((Map)object2).entrySet()) {
                Object object = entry.getKey();
                if (object instanceof String) {
                    object = (String)object;
                    hashMap.put(object, zzg.zzb(entry.getValue(), var1_5.zza((String)object)));
                    continue;
                }
                throw zzg.zzb((zzb)var1_5, "Maps with non-string keys are not supported");
            }
            return hashMap;
        }
        if (object2 instanceof Collection) {
            if (object2 instanceof List) {
                void var0_4;
                List list = (List)object2;
                ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
                boolean bl = false;
                while (var0_4 < list.size()) {
                    arrayList.add(zzg.zzb(list.get((int)var0_4), var1_5.zza("[" + (int)var0_4 + "]")));
                    ++var0_4;
                }
                return arrayList;
            }
            throw zzg.zzb((zzb)var1_5, "Serializing Collections is not supported, please use Lists instead");
        }
        if (object2.getClass().isArray()) {
            throw zzg.zzb((zzb)var1_5, "Serializing Arrays is not supported, please use Lists instead");
        }
        if (object2 instanceof Enum) {
            return ((Enum)object2).name();
        }
        if (object2 instanceof Date || object2 instanceof Timestamp || object2 instanceof GeoPoint || object2 instanceof Blob || object2 instanceof DocumentReference) {
            return object2;
        }
        Class<?> clazz = object2.getClass();
        zza<?> zza2 = zzg.zza(clazz);
        return zza2.zza(object2, (zzb)var1_5);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> T zzb(Object object, Type object2, zzb zzb2) {
        while (true) {
            Object object3;
            if (object == null) {
                return null;
            }
            if (object2 instanceof ParameterizedType) {
                void var6_12;
                object3 = (Type[])(object2 = (ParameterizedType)object2).getRawType();
                if (List.class.isAssignableFrom((Class<?>)object3)) {
                    Type type = object2.getActualTypeArguments()[0];
                    if (object instanceof List) {
                        object3 = (List)object;
                        object = new ArrayList(object3.size());
                        for (int i = 0; i < object3.size(); ++i) {
                            object.add(zzg.zzb(object3.get(i), type, zzb2.zza("[" + i + "]")));
                        }
                        return (T)object;
                    }
                    throw zzg.zzc(zzb2, "Expected a List, but got a " + object.getClass());
                }
                if (Map.class.isAssignableFrom((Class<?>)object3)) {
                    Type type = object2.getActualTypeArguments()[0];
                    object3 = object2.getActualTypeArguments()[1];
                    if (!type.equals(String.class)) {
                        throw zzg.zzc(zzb2, "Only Maps with string keys are supported, but found Map with key type " + type);
                    }
                    object = zzg.zzc(object, zzb2);
                    HashMap<String, T> hashMap = new HashMap<String, T>();
                    for (Map.Entry entry : object.entrySet()) {
                        hashMap.put((String)entry.getKey(), zzg.zzb(entry.getValue(), (Type)object3, zzb2.zza((String)entry.getKey())));
                    }
                    return (T)hashMap;
                }
                if (Collection.class.isAssignableFrom((Class<?>)object3)) {
                    throw zzg.zzc(zzb2, "Collections are not supported, please use Lists instead");
                }
                Map<String, Object> map = zzg.zzc(object, zzb2);
                object3 = zzg.zza(object3);
                object = new HashMap();
                TypeVariable<Class<T>>[] typeVariableArray = ((zza)object3).zza.getTypeParameters();
                if (((Type[])(object2 = object2.getActualTypeArguments())).length != typeVariableArray.length) {
                    throw new IllegalStateException("Mismatched lengths for type variables and actual types");
                }
                boolean i = false;
                while (var6_12 < typeVariableArray.length) {
                    ((HashMap)object).put(typeVariableArray[var6_12], object2[var6_12]);
                    ++var6_12;
                }
                return ((zza)object3).zza(map, object, zzb2);
            }
            if (object2 instanceof Class) {
                return zzg.zza(object, (Class)object2, zzb2);
            }
            if (object2 instanceof WildcardType) {
                object3 = ((WildcardType)object2).getLowerBounds();
                if (((Type[])object3).length > 0) {
                    throw zzg.zzc(zzb2, "Generic lower-bounded wildcard types are not supported");
                }
                object3 = ((WildcardType)object2).getUpperBounds();
                zzg.zzb(((Type[])object3).length > 0, "Unexpected type bounds on wildcard " + object2);
                object2 = object3[0];
                continue;
            }
            if (!(object2 instanceof TypeVariable)) break;
            object3 = ((TypeVariable)object2).getBounds();
            zzg.zzb(((Type[])object3).length > 0, "Unexpected type bounds on type variable " + object2);
            object2 = object3[0];
        }
        if (object2 instanceof GenericArrayType) {
            throw zzg.zzc(zzb2, "Generic Arrays are not supported, please use Lists instead");
        }
        throw zzg.zzc(zzb2, "Unknown type encountered: " + object2);
    }

    private static <T> T zza(Object object, Class<T> clazz, zzb zzb2) {
        if (object == null) {
            return null;
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            return zzg.zzb(object, clazz, zzb2);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (T)zzg.zzh(object, zzb2);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return (T)zzg.zzi(object, zzb2);
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return (T)zzg.zzj(object, zzb2);
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return (T)zzg.zzk(object, zzb2);
        }
        if (GeoPoint.class.isAssignableFrom(clazz)) {
            return (T)zzg.zzl(object, zzb2);
        }
        if (DocumentReference.class.isAssignableFrom(clazz)) {
            return (T)zzg.zzm(object, zzb2);
        }
        if (clazz.isArray()) {
            throw zzg.zzc(zzb2, "Converting to Arrays is not supported, please use Lists instead");
        }
        if (clazz.getTypeParameters().length > 0) {
            throw zzg.zzc(zzb2, "Class " + clazz.getName() + " has generic type parameters, please use GenericTypeIndicator instead");
        }
        if (clazz.equals(Object.class)) {
            return (T)object;
        }
        if (clazz.isEnum()) {
            return zzg.zzc(object, clazz, zzb2);
        }
        return zzg.zzd(object, clazz, zzb2);
    }

    private static <T> T zzb(Object object, Class<T> clazz, zzb zzb2) {
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return (T)zzg.zzd(object, zzb2);
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return (T)zzg.zzg(object, zzb2);
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return (T)zzg.zzf(object, zzb2);
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return (T)zzg.zze(object, zzb2);
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return (T)Float.valueOf(zzg.zzf(object, zzb2).floatValue());
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
            throw zzg.zzc(zzb2, "Deserializing to shorts is not supported");
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
            throw zzg.zzc(zzb2, "Deserializing to bytes is not supported");
        }
        if (Character.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz)) {
            throw zzg.zzc(zzb2, "Deserializing to chars is not supported");
        }
        throw new IllegalArgumentException("Unknown primitive type: " + clazz);
    }

    private static <T> T zzc(Object object, Class<T> clazz, zzb zzb2) {
        if (object instanceof String) {
            object = (String)object;
            try {
                return Enum.valueOf(clazz, (String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw zzg.zzc(zzb2, "Could not find enum value of " + clazz.getName() + " for value \"" + (String)object + "\"");
            }
        }
        throw zzg.zzc(zzb2, "Expected a String while deserializing to enum " + clazz + " but got a " + object.getClass());
    }

    private static <T> zza<T> zza(Class<T> clazz) {
        zza<T> zza2 = (zza<T>)zza.get(clazz);
        if (zza2 == null) {
            zza2 = new zza<T>(clazz);
            zza.put(clazz, zza2);
        }
        return zza2;
    }

    private static Map<String, Object> zzc(Object object, zzb zzb2) {
        if (object instanceof Map) {
            return (Map)object;
        }
        throw zzg.zzc(zzb2, "Expected a Map while deserializing, but got a " + object.getClass());
    }

    private static Integer zzd(Object object, zzb zzb2) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long || object instanceof Double) {
            double d;
            double d2 = ((Number)object).doubleValue();
            if (d >= -2.147483648E9 && d2 <= 2.147483647E9) {
                return ((Number)object).intValue();
            }
            throw zzg.zzc(zzb2, "Numeric value out of 32-bit integer range: " + d2 + ". Did you mean to use a long or double instead of an int?");
        }
        throw zzg.zzc(zzb2, "Failed to convert a value of type " + object.getClass().getName() + " to int");
    }

    private static Long zze(Object object, zzb zzb2) {
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Double) {
            Double d;
            object = (Double)object;
            if (d >= -9.223372036854776E18 && (Double)object <= 9.223372036854776E18) {
                return ((Double)object).longValue();
            }
            throw zzg.zzc(zzb2, "Numeric value out of 64-bit long range: " + object + ". Did you mean to use a double instead of a long?");
        }
        throw zzg.zzc(zzb2, "Failed to convert a value of type " + object.getClass().getName() + " to long");
    }

    private static Double zzf(Object object, zzb zzb2) {
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            Double d = ((Long)object).doubleValue();
            if (d.longValue() == l.longValue()) {
                return d;
            }
            throw zzg.zzc(zzb2, "Loss of precision while converting number to double: " + object + ". Did you mean to use a 64-bit long instead?");
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        throw zzg.zzc(zzb2, "Failed to convert a value of type " + object.getClass().getName() + " to double");
    }

    private static Boolean zzg(Object object, zzb zzb2) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw zzg.zzc(zzb2, "Failed to convert value of type " + object.getClass().getName() + " to boolean");
    }

    private static String zzh(Object object, zzb zzb2) {
        if (object instanceof String) {
            return (String)object;
        }
        throw zzg.zzc(zzb2, "Failed to convert value of type " + object.getClass().getName() + " to String");
    }

    private static Date zzi(Object object, zzb zzb2) {
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Timestamp) {
            return ((Timestamp)object).toDate();
        }
        throw zzg.zzc(zzb2, "Failed to convert value of type " + object.getClass().getName() + " to Date");
    }

    private static Timestamp zzj(Object object, zzb zzb2) {
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof Date) {
            return new Timestamp((Date)object);
        }
        throw zzg.zzc(zzb2, "Failed to convert value of type " + object.getClass().getName() + " to Timestamp");
    }

    private static Blob zzk(Object object, zzb zzb2) {
        if (object instanceof Blob) {
            return (Blob)object;
        }
        throw zzg.zzc(zzb2, "Failed to convert value of type " + object.getClass().getName() + " to Blob");
    }

    private static GeoPoint zzl(Object object, zzb zzb2) {
        if (object instanceof GeoPoint) {
            return (GeoPoint)object;
        }
        throw zzg.zzc(zzb2, "Failed to convert value of type " + object.getClass().getName() + " to GeoPoint");
    }

    private static DocumentReference zzm(Object object, zzb zzb2) {
        if (object instanceof DocumentReference) {
            return (DocumentReference)object;
        }
        throw zzg.zzc(zzb2, "Failed to convert value of type " + object.getClass().getName() + " to DocumentReference");
    }

    private static <T> T zzd(Object object, Class<T> clazz, zzb zzb2) {
        zza<T> zza2 = zzg.zza(clazz);
        if (object instanceof Map) {
            return zza2.zza(zzg.zzc(object, zzb2), zzb2);
        }
        throw zzg.zzc(zzb2, "Can't convert object of type " + object.getClass().getName() + " to type " + clazz.getName());
    }

    private static RuntimeException zzb(zzb zzb2, String string) {
        string = "Could not serialize object. " + string;
        if (zzb2.zza() > 0) {
            string = string + " (found in field '" + zzb2.toString() + "')";
        }
        return new RuntimeException(string);
    }

    private static RuntimeException zzc(zzb zzb2, String string) {
        string = "Could not deserialize object. " + string;
        if (zzb2.zza() > 0) {
            string = string + " (found in field '" + zzb2.toString() + "')";
        }
        return new RuntimeException(string);
    }

    static final class zzb {
        private final int zzb;
        private final zzb zzc;
        private final String zzd;
        static final zzb zza = new zzb(null, null, 0);

        private zzb(zzb zzb2, String string, int n) {
            this.zzc = zzb2;
            this.zzd = string;
            this.zzb = n;
        }

        final int zza() {
            return this.zzb;
        }

        public final zzb zza(String string) {
            return new zzb(this, string, this.zzb + 1);
        }

        public final String toString() {
            if (this.zzb == 0) {
                return "";
            }
            if (this.zzb == 1) {
                return this.zzd;
            }
            return this.zzc.toString() + "." + this.zzd;
        }
    }

    static final class zza<T> {
        private final Class<T> zza;
        private final Constructor<T> zzb;
        private final boolean zzc;
        private final boolean zzd;
        private final Map<String, String> zze;
        private final Map<String, Method> zzf;
        private final Map<String, Method> zzg;
        private final Map<String, Field> zzh;
        private final HashSet<String> zzi;

        /*
         * WARNING - void declaration
         */
        public zza(Class<T> clazz) {
            Class<?>[] classArray;
            Object object;
            Object object2;
            Object object4;
            this.zza = clazz;
            this.zzc = clazz.isAnnotationPresent(ThrowOnExtraProperties.class);
            this.zzd = !clazz.isAnnotationPresent(IgnoreExtraProperties.class);
            this.zze = new HashMap<String, String>();
            this.zzg = new HashMap<String, Method>();
            this.zzf = new HashMap<String, Method>();
            this.zzh = new HashMap<String, Field>();
            this.zzi = new HashSet();
            try {
                object4 = clazz.getDeclaredConstructor(new Class[0]);
                ((Constructor)object4).setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                object4 = null;
            }
            this.zzb = object4;
            for (Method accessibleObject : clazz.getMethods()) {
                object2 = accessibleObject;
                if (!(!accessibleObject.getName().startsWith("get") && !((Method)object2).getName().startsWith("is") ? false : (((Method)object2).getDeclaringClass().equals(Object.class) ? false : (!Modifier.isPublic(((Method)object2).getModifiers()) ? false : (Modifier.isStatic(((Method)object2).getModifiers()) ? false : (((Method)object2).getReturnType().equals(Void.TYPE) ? false : (((Method)object2).getParameterTypes().length != 0 ? false : !((AccessibleObject)object2).isAnnotationPresent(Exclude.class)))))))) continue;
                String string = com.google.firebase.firestore.g.zzg$zza.zza(accessibleObject);
                this.zza(string);
                accessibleObject.setAccessible(true);
                if (this.zzf.containsKey(string)) {
                    throw new RuntimeException("Found conflicting getters for name " + accessibleObject.getName() + " on class " + clazz.getName());
                }
                this.zzf.put(string, accessibleObject);
                object = accessibleObject;
                object2 = this;
                if (!((AccessibleObject)object).isAnnotationPresent(ServerTimestamp.class)) continue;
                classArray = ((Method)object).getReturnType();
                if (classArray != Date.class && classArray != Timestamp.class) {
                    throw new IllegalArgumentException("Method " + ((Method)object).getName() + " is annotated with @ServerTimestamp but returns " + classArray + " instead of Date or Timestamp.");
                }
                ((zza)object2).zzi.add(com.google.firebase.firestore.g.zzg$zza.zza((Method)object));
            }
            for (AccessibleObject accessibleObject : clazz.getFields()) {
                object2 = accessibleObject;
                if (!(((Field)accessibleObject).getDeclaringClass().equals(Object.class) ? false : (!Modifier.isPublic(((Field)object2).getModifiers()) ? false : (Modifier.isStatic(((Field)object2).getModifiers()) ? false : (Modifier.isTransient(((Field)object2).getModifiers()) ? false : !((AccessibleObject)object2).isAnnotationPresent(Exclude.class)))))) continue;
                String string = com.google.firebase.firestore.g.zzg$zza.zzb((Field)accessibleObject);
                this.zza(string);
                this.zza((Field)accessibleObject);
            }
            object4 = clazz;
            do {
                void var5_11;
                int n;
                AccessibleObject[] accessibleObjectArray = ((Class)object4).getDeclaredMethods();
                int n2 = accessibleObjectArray.length;
                boolean bl = false;
                while (n < n2) {
                    Object object3;
                    Method method = accessibleObjectArray[n];
                    object2 = method;
                    if ((!method.getName().startsWith("set") ? false : (((Method)object2).getDeclaringClass().equals(Object.class) ? false : (Modifier.isStatic(((Method)object2).getModifiers()) ? false : (!((Method)object2).getReturnType().equals(Void.TYPE) ? false : (((Method)object2).getParameterTypes().length != 1 ? false : !((AccessibleObject)object2).isAnnotationPresent(Exclude.class)))))) && (object3 = this.zze.get(((String)(object2 = com.google.firebase.firestore.g.zzg$zza.zza(method))).toLowerCase(Locale.US))) != null) {
                        if (!((String)object3).equals(object2)) {
                            throw new RuntimeException("Found setter on " + ((Class)object4).getName() + " with invalid case-sensitive name: " + method.getName());
                        }
                        object3 = this.zzg.get(object2);
                        if (object3 == null) {
                            method.setAccessible(true);
                            this.zzg.put((String)object2, method);
                            object2 = method;
                            if (((AccessibleObject)object2).isAnnotationPresent(ServerTimestamp.class)) {
                                throw new IllegalArgumentException("Method " + ((Method)object2).getName() + " is annotated with @ServerTimestamp but should not be. @ServerTimestamp can only be applied to fields and getters, not setters.");
                            }
                        } else {
                            object = object3;
                            object2 = method;
                            com.google.firebase.firestore.g.zzg.zzb(((Method)object2).getDeclaringClass().isAssignableFrom(((Method)object).getDeclaringClass()), "Expected override from a base class");
                            com.google.firebase.firestore.g.zzg.zzb(((Method)object2).getReturnType().equals(Void.TYPE), "Expected void return type");
                            com.google.firebase.firestore.g.zzg.zzb(((Method)object).getReturnType().equals(Void.TYPE), "Expected void return type");
                            classArray = ((Method)object2).getParameterTypes();
                            Class<?>[] classArray2 = ((Method)object).getParameterTypes();
                            com.google.firebase.firestore.g.zzg.zzb(classArray.length == 1, "Expected exactly one parameter");
                            com.google.firebase.firestore.g.zzg.zzb(classArray2.length == 1, "Expected exactly one parameter");
                            if (!(((Method)object2).getName().equals(((Method)object).getName()) && classArray[0].equals(classArray2[0]))) {
                                if (object4 == clazz) {
                                    throw new RuntimeException("Class " + clazz.getName() + " has multiple setter overloads with name " + method.getName());
                                }
                                throw new RuntimeException("Found conflicting setters with name: " + method.getName() + " (conflicts with " + ((Method)object3).getName() + " defined on " + ((Method)object3).getDeclaringClass().getName() + ")");
                            }
                        }
                    }
                    ++n;
                }
                accessibleObjectArray = ((Class)object4).getDeclaredFields();
                n2 = accessibleObjectArray.length;
                n = 0;
                while (var5_11 < n2) {
                    AccessibleObject accessibleObject = accessibleObjectArray[var5_11];
                    object2 = com.google.firebase.firestore.g.zzg$zza.zzb((Field)accessibleObject);
                    if (this.zze.containsKey(((String)object2).toLowerCase(Locale.US)) && !this.zzh.containsKey(object2)) {
                        ((Field)accessibleObject).setAccessible(true);
                        this.zzh.put((String)object2, (Field)accessibleObject);
                        this.zza((Field)accessibleObject);
                    }
                    ++var5_11;
                }
            } while ((object4 = ((Class)object4).getSuperclass()) != null && !object4.equals(Object.class));
            if (this.zze.isEmpty()) {
                throw new RuntimeException("No properties to serialize found on class " + clazz.getName());
            }
        }

        private void zza(String string) {
            String string2 = this.zze.put(string.toLowerCase(Locale.US), string);
            if (string2 != null && !string.equals(string2)) {
                throw new RuntimeException("Found two getters or fields with conflicting case sensitivity for property: " + string.toLowerCase(Locale.US));
            }
        }

        public final T zza(Map<String, Object> map, zzb zzb2) {
            return this.zza(map, Collections.emptyMap(), zzb2);
        }

        public final T zza(Map<String, Object> object, Map<TypeVariable<Class<T>>, Type> map, zzb zzb2) {
            T t;
            if (this.zzb == null) {
                throw com.google.firebase.firestore.g.zzg.zzc(zzb2, "Class " + this.zza.getName() + " does not define a no-argument constructor. If you are using ProGuard, make sure these constructors are not stripped");
            }
            try {
                t = this.zzb.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
            for (Map.Entry illegalAccessException : object.entrySet()) {
                Object object2;
                Object object3 = (Type[])illegalAccessException.getKey();
                zzb zzb3 = zzb2.zza((String)object3);
                if (this.zzg.containsKey(object3)) {
                    object2 = this.zzg.get(object3);
                    if (((Type[])(object3 = ((Method)object2).getGenericParameterTypes())).length != 1) {
                        throw com.google.firebase.firestore.g.zzg.zzc(zzb3, "Setter does not have exactly one parameter");
                    }
                    object3 = com.google.firebase.firestore.g.zzg$zza.zza(object3[0], map);
                    Object object4 = com.google.firebase.firestore.g.zzg.zzb(illegalAccessException.getValue(), (Type)object3, zzb3);
                    try {
                        ((Method)object2).invoke(t, object4);
                        continue;
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        throw new RuntimeException(reflectiveOperationException);
                    }
                }
                if (this.zzh.containsKey(object3)) {
                    object2 = this.zzh.get(object3);
                    object3 = com.google.firebase.firestore.g.zzg$zza.zza(((Field)object2).getGenericType(), map);
                    object3 = com.google.firebase.firestore.g.zzg.zzb(illegalAccessException.getValue(), (Type)object3, zzb3);
                    try {
                        ((Field)object2).set(t, object3);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException2) {
                        throw new RuntimeException(illegalAccessException2);
                    }
                }
                object2 = "No setter/field for " + (String)object3 + " found on class " + this.zza.getName();
                if (this.zze.containsKey(((String)object3).toLowerCase(Locale.US))) {
                    object2 = (String)object2 + " (fields/setters are case sensitive!)";
                }
                if (this.zzc) {
                    throw new RuntimeException((String)object2);
                }
                if (!this.zzd) continue;
                zzq.zza(zzg.class.getSimpleName(), (String)object2, new Object[0]);
            }
            return t;
        }

        private static Type zza(Type type, Map<TypeVariable<Class<T>>, Type> object) {
            if (type instanceof TypeVariable) {
                if ((object = object.get(type)) == null) {
                    throw new IllegalStateException("Could not resolve type " + type);
                }
                return object;
            }
            return type;
        }

        public final Map<String, Object> zza(T t, zzb zzb2) {
            if (!this.zza.isAssignableFrom(t.getClass())) {
                throw new IllegalArgumentException("Can't serialize object of class " + t.getClass() + " with BeanMapper for class " + this.zza);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String string : this.zze.values()) {
                Object object;
                if (this.zzf.containsKey(string)) {
                    object = this.zzf.get(string);
                    try {
                        object = ((Method)object).invoke(t, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                        throw new RuntimeException(reflectiveOperationException);
                    }
                }
                object = this.zzh.get(string);
                if (object == null) {
                    throw new IllegalStateException("Bean property without field or getter: " + string);
                }
                try {
                    object = ((Field)object).get(t);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                object = this.zzi.contains(string) && object == null ? FieldValue.serverTimestamp() : com.google.firebase.firestore.g.zzg.zzb(object, zzb2.zza(string));
                hashMap.put(string, object);
            }
            return hashMap;
        }

        private void zza(Field field) {
            if (field.isAnnotationPresent(ServerTimestamp.class)) {
                Class<?> clazz = field.getType();
                if (clazz != Date.class && clazz != Timestamp.class) {
                    throw new IllegalArgumentException("Field " + field.getName() + " is annotated with @ServerTimestamp but is " + clazz + " instead of Date or Timestamp.");
                }
                this.zzi.add(com.google.firebase.firestore.g.zzg$zza.zzb(field));
            }
        }

        private static String zzb(Field field) {
            String string = com.google.firebase.firestore.g.zzg$zza.zza(field);
            if (string != null) {
                return string;
            }
            return field.getName();
        }

        private static String zza(Method method) {
            String string = com.google.firebase.firestore.g.zzg$zza.zza((AccessibleObject)method);
            if (string != null) {
                return string;
            }
            return com.google.firebase.firestore.g.zzg$zza.zzb(method.getName());
        }

        private static String zza(AccessibleObject object) {
            if (((AccessibleObject)object).isAnnotationPresent(PropertyName.class)) {
                object = ((AccessibleObject)object).getAnnotation(PropertyName.class);
                return object.value();
            }
            return null;
        }

        private static String zzb(String object) {
            int n;
            Object object2 = new String[]{"get", "set", "is"};
            String string = null;
            for (n = 0; n < 3; ++n) {
                String string2 = object2[n];
                if (!((String)object).startsWith(string2)) continue;
                string = string2;
            }
            if (string == null) {
                throw new IllegalArgumentException("Unknown Bean prefix for method: " + (String)object);
            }
            object2 = ((String)object).substring(string.length());
            object = object2.toCharArray();
            for (n = 0; n < ((Object)object).length && Character.isUpperCase((char)object[n]); ++n) {
                object[n] = Character.toLowerCase((char)object[n]);
            }
            return new String((char[])object);
        }
    }
}

