/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.QueryDocumentSnapshot;
import com.google.firebase.firestore.obfuscated.zzba;
import com.google.firebase.firestore.obfuscated.zzdj;
import com.google.firebase.firestore.obfuscated.zzdn;
import com.google.firebase.firestore.obfuscated.zzge;
import com.google.firebase.firestore.obfuscated.zzi;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@PublicApi
public class DocumentChange {
    private final Type zza;
    private final QueryDocumentSnapshot zzb;
    private final int zzc;
    private final int zzd;

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    private DocumentChange(QueryDocumentSnapshot document, Type type, int oldIndex, int newIndex) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.zza = var2_2;
        this.zzb = var1_1;
        this.zzc = var3_3;
        this.zzd = newIndex;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof DocumentChange) {
            DocumentChange documentChange;
            documentChange = documentChange;
            return this.zza.equals((Object)documentChange.zza) && this.zzb.equals(documentChange.zzb) && this.zzc == documentChange.zzc && this.zzd == documentChange.zzd;
        }
        return false;
    }

    public int hashCode() {
        int n = this.zza.hashCode();
        n = n * 31 + this.zzb.hashCode();
        n = n * 31 + this.zzc;
        n = n * 31 + this.zzd;
        return n;
    }

    @NonNull
    @PublicApi
    public Type getType() {
        return this.zza;
    }

    @NonNull
    @PublicApi
    public QueryDocumentSnapshot getDocument() {
        return this.zzb;
    }

    @PublicApi
    public int getOldIndex() {
        return this.zzc;
    }

    @PublicApi
    public int getNewIndex() {
        return this.zzd;
    }

    static List<DocumentChange> zza(FirebaseFirestore firebaseFirestore, MetadataChanges metadataChanges, zzba zzba2) {
        ArrayList<DocumentChange> arrayList = new ArrayList<DocumentChange>();
        if (zzba2.zzc().zzb()) {
            int n = 0;
            zzdj zzdj2 = null;
            for (zzi zzi2 : zzba2.zzd()) {
                zzdj zzdj3 = zzi2.zza();
                QueryDocumentSnapshot queryDocumentSnapshot = QueryDocumentSnapshot.zzb(firebaseFirestore, zzdj3, zzba2.zze());
                zzge.zza(zzi2.zzb() == zzi.zza.zzb, "Invalid added event for first snapshot", new Object[0]);
                zzge.zza(zzdj2 == null || zzba2.zza().zzm().compare(zzdj2, zzdj3) < 0, "Got added events in wrong order", new Object[0]);
                arrayList.add(new DocumentChange(queryDocumentSnapshot, Type.ADDED, -1, n++));
                zzdj2 = zzdj3;
            }
        } else {
            zzdn zzdn2 = zzba2.zzc();
            for (zzi zzi3 : zzba2.zzd()) {
                int n;
                int n2;
                Type type;
                if (metadataChanges == MetadataChanges.EXCLUDE && zzi3.zzb() == zzi.zza.zzd) continue;
                zzdj zzdj4 = zzi3.zza();
                QueryDocumentSnapshot queryDocumentSnapshot = QueryDocumentSnapshot.zzb(firebaseFirestore, zzdj4, zzba2.zze());
                switch (1.zza[zzi3.zzb().ordinal()]) {
                    case 1: {
                        type = Type.ADDED;
                        break;
                    }
                    case 2: 
                    case 3: {
                        type = Type.MODIFIED;
                        break;
                    }
                    case 4: {
                        type = Type.REMOVED;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown view change type: " + (Object)((Object)zzi3.zzb()));
                    }
                }
                Type type2 = type;
                if (type != Type.ADDED) {
                    n2 = zzdn2.zzb(zzdj4.zzd());
                    zzge.zza(n2 >= 0, "Index for document not found", new Object[0]);
                    zzdn2 = zzdn2.zzc(zzdj4.zzd());
                } else {
                    n2 = -1;
                }
                if (type2 != Type.REMOVED) {
                    n = (zzdn2 = zzdn2.zza(zzdj4)).zzb(zzdj4.zzd());
                    zzge.zza(n >= 0, "Index for document not found", new Object[0]);
                } else {
                    n = -1;
                }
                arrayList.add(new DocumentChange(queryDocumentSnapshot, type2, n2, n));
            }
        }
        return arrayList;
    }

    @PublicApi
    public static enum Type {
        ADDED,
        MODIFIED,
        REMOVED;

    }
}

