/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import android.support.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Preconditions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.Source;
import com.google.firebase.firestore.obfuscated.zzag;
import com.google.firebase.firestore.obfuscated.zzah;
import com.google.firebase.firestore.obfuscated.zzau;
import com.google.firebase.firestore.obfuscated.zzav;
import com.google.firebase.firestore.obfuscated.zzba;
import com.google.firebase.firestore.obfuscated.zzdj;
import com.google.firebase.firestore.obfuscated.zzdl;
import com.google.firebase.firestore.obfuscated.zzds;
import com.google.firebase.firestore.obfuscated.zzdv;
import com.google.firebase.firestore.obfuscated.zzed;
import com.google.firebase.firestore.obfuscated.zzge;
import com.google.firebase.firestore.obfuscated.zzgp;
import com.google.firebase.firestore.obfuscated.zzgr;
import com.google.firebase.firestore.obfuscated.zzgy;
import com.google.firebase.firestore.obfuscated.zzhc;
import com.google.firebase.firestore.zzb;
import com.google.firebase.firestore.zzc;
import com.google.firebase.firestore.zzd;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@PublicApi
public class DocumentReference {
    private final zzdl zza;
    private final FirebaseFirestore zzb;

    /*
     * WARNING - void declaration
     */
    DocumentReference(zzdl key, FirebaseFirestore firestore) {
        void var2_2;
        void var1_1;
        this.zza = (zzdl)Preconditions.checkNotNull((Object)var1_1);
        this.zzb = var2_2;
    }

    public static DocumentReference zza(zzds zzds2, FirebaseFirestore firebaseFirestore) {
        if (zzds2.zzg() % 2 != 0) {
            throw new IllegalArgumentException("Invalid document reference. Document references must have an even number of segments, but " + zzds2.zzf() + " has " + zzds2.zzg());
        }
        return new DocumentReference(zzdl.zza(zzds2), firebaseFirestore);
    }

    final zzdl zza() {
        return this.zza;
    }

    @NonNull
    @PublicApi
    public FirebaseFirestore getFirestore() {
        return this.zzb;
    }

    @NonNull
    @PublicApi
    public String getId() {
        return this.zza.zzd().zzc();
    }

    @NonNull
    @PublicApi
    public CollectionReference getParent() {
        return new CollectionReference((zzds)this.zza.zzd().zzb(), this.zzb);
    }

    @NonNull
    @PublicApi
    public String getPath() {
        return this.zza.zzd().zzf();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public CollectionReference collection(@NonNull String collectionPath) {
        void var1_1;
        Preconditions.checkNotNull((Object)collectionPath, (Object)"Provided collection path must not be null.");
        return new CollectionReference(this.zza.zzd().zza(zzds.zzb((String)var1_1)), this.zzb);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Task<Void> set(@NonNull Map<String, Object> data) {
        void var1_1;
        return this.set((Map<String, Object>)var1_1, SetOptions.zza);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Task<Void> set(@NonNull Map<String, Object> data, @NonNull SetOptions options) {
        zzau zzau2;
        void var2_2;
        Preconditions.checkNotNull(data, (Object)"Provided data must not be null.");
        Preconditions.checkNotNull((Object)options, (Object)"Provided options must not be null.");
        zzau2 = options.zza() ? this.zzb.zzc().zza(data, var2_2.zzb()) : this.zzb.zzc().zza((Map<String, Object>)((Object)zzau2));
        return this.zzb.zza().zza(zzau2.zza(this.zza, zzed.zza)).continueWith(zzgr.zzb, zzhc.zzc());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Task<Void> set(@NonNull Object pojo) {
        void var1_1;
        return this.set(FirebaseFirestoreSettings.1.zzb(var1_1), SetOptions.zza);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Task<Void> set(@NonNull Object pojo, @NonNull SetOptions options) {
        void var2_2;
        void var1_1;
        return this.set(FirebaseFirestoreSettings.1.zzb(var1_1), (SetOptions)var2_2);
    }

    @NonNull
    @PublicApi
    public Task<Void> update(@NonNull Map<String, Object> data) {
        zzav zzav2;
        zzav2 = this.zzb.zzc().zzb((Map<String, Object>)((Object)zzav2));
        return this.zza(zzav2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Task<Void> update(@NonNull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        void var3_3;
        void var2_2;
        zzav zzav2;
        zzav2 = this.zzb.zzc().zza(zzhc.zza(1, zzav2, var2_2, (Object[])var3_3));
        return this.zza(zzav2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Task<Void> update(@NonNull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        void var3_3;
        void var2_2;
        zzav zzav2;
        zzav2 = this.zzb.zzc().zza(zzhc.zza(1, zzav2, var2_2, (Object[])var3_3));
        return this.zza(zzav2);
    }

    private Task<Void> zza(@NonNull zzav zzav2) {
        return this.zzb.zza().zza(zzav2.zza(this.zza, zzed.zza(true))).continueWith(zzgr.zzb, zzhc.zzc());
    }

    @NonNull
    @PublicApi
    public Task<Void> delete() {
        return this.zzb.zza().zza(Collections.singletonList(new zzdv(this.zza, zzed.zza))).continueWith(zzgr.zzb, zzhc.zzc());
    }

    @NonNull
    @PublicApi
    public Task<DocumentSnapshot> get() {
        return this.get(Source.DEFAULT);
    }

    @NonNull
    @PublicApi
    public Task<DocumentSnapshot> get(Source source) {
        Object object;
        if (source == Source.CACHE) {
            return this.zzb.zza().zza(this.zza).continueWith(zzgr.zzb, com.google.firebase.firestore.zzb.zza(this));
        }
        void var2_2 = object;
        object = this;
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        TaskCompletionSource taskCompletionSource2 = new TaskCompletionSource();
        zzge zzge2 = new zzge();
        new zzge().zza = true;
        zzge2.zzb = true;
        zzge2.zzc = true;
        object = ((DocumentReference)object).zza(zzgr.zzb, zzge2, null, zzc.zza(taskCompletionSource, taskCompletionSource2, (Source)var2_2));
        taskCompletionSource2.setResult(object);
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull EventListener<DocumentSnapshot> listener) {
        void var1_1;
        return this.addSnapshotListener(MetadataChanges.EXCLUDE, (EventListener<DocumentSnapshot>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull EventListener<DocumentSnapshot> listener) {
        void var2_2;
        void var1_1;
        return this.addSnapshotListener((Executor)var1_1, MetadataChanges.EXCLUDE, (EventListener<DocumentSnapshot>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull EventListener<DocumentSnapshot> listener) {
        void var2_2;
        void var1_1;
        return this.addSnapshotListener((Activity)var1_1, MetadataChanges.EXCLUDE, (EventListener<DocumentSnapshot>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull MetadataChanges metadataChanges, @NonNull EventListener<DocumentSnapshot> listener) {
        void var2_2;
        void var1_1;
        return this.addSnapshotListener(zzgr.zza, (MetadataChanges)var1_1, (EventListener<DocumentSnapshot>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull MetadataChanges metadataChanges, @NonNull EventListener<DocumentSnapshot> listener) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)executor, (Object)"Provided executor must not be null.");
        Preconditions.checkNotNull((Object)((Object)metadataChanges), (Object)"Provided MetadataChanges value must not be null.");
        Preconditions.checkNotNull(listener, (Object)"Provided EventListener must not be null.");
        return this.zza((Executor)var1_1, DocumentReference.zza((MetadataChanges)var2_2), null, (EventListener<DocumentSnapshot>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull MetadataChanges metadataChanges, @NonNull EventListener<DocumentSnapshot> listener) {
        void var3_3;
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull((Object)activity, (Object)"Provided activity must not be null.");
        Preconditions.checkNotNull((Object)((Object)metadataChanges), (Object)"Provided MetadataChanges value must not be null.");
        Preconditions.checkNotNull(listener, (Object)"Provided EventListener must not be null.");
        return this.zza(zzgr.zza, DocumentReference.zza((MetadataChanges)var2_2), (Activity)var1_1, (EventListener<DocumentSnapshot>)var3_3);
    }

    private ListenerRegistration zza(Executor object, zzge object2, @Nullable Activity activity, EventListener<DocumentSnapshot> object3) {
        object = new zzgp((Executor)object, zzd.zza(this, object3));
        object3 = this;
        object3 = zzag.zza(((DocumentReference)object3).zza.zzd());
        object2 = this.zzb.zza().zza((zzag)object3, (zzge)object2, (EventListener<zzba>)object);
        return new zzgy(this.zzb.zza(), (zzah)object2, activity, (zzgp<zzba>)object);
    }

    public boolean equals(Object o) {
        DocumentReference documentReference;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        documentReference = documentReference;
        return this.zza.equals(documentReference.zza) && this.zzb.equals(documentReference.zzb);
    }

    public int hashCode() {
        int n = this.zza.hashCode();
        n = n * 31 + this.zzb.hashCode();
        return n;
    }

    private static zzge zza(MetadataChanges metadataChanges) {
        zzge zzge2 = new zzge();
        new zzge().zza = metadataChanges == MetadataChanges.INCLUDE;
        zzge2.zzb = metadataChanges == MetadataChanges.INCLUDE;
        zzge2.zzc = false;
        return zzge2;
    }

    static /* synthetic */ void zza(DocumentReference object, EventListener eventListener, zzba zzba2, FirebaseFirestoreException object2) {
        if (zzba2 != null) {
            zzge.zza(zzba2.zzb().zza() <= 1, "Too many documents returned on a document query", new Object[0]);
            object2 = zzba2.zzb().zza(((DocumentReference)object).zza);
            object = object2 != null ? DocumentSnapshot.zza(((DocumentReference)object).zzb, (zzdj)object2, zzba2.zze()) : DocumentSnapshot.zza(((DocumentReference)object).zzb, ((DocumentReference)object).zza, zzba2.zze());
            eventListener.onEvent(object, null);
            return;
        }
        zzge.zza(object2 != null, "Got event without value or error set", new Object[0]);
        eventListener.onEvent(null, (FirebaseFirestoreException)((Object)object2));
    }

    static /* synthetic */ void zza(TaskCompletionSource taskCompletionSource, TaskCompletionSource object, Source source, DocumentSnapshot documentSnapshot, FirebaseFirestoreException firebaseFirestoreException) {
        block6: {
            if (firebaseFirestoreException != null) {
                taskCompletionSource.setException((Exception)((Object)firebaseFirestoreException));
                return;
            }
            try {
                object = (ListenerRegistration)Tasks.await((Task)object.getTask());
                object.remove();
                if (!documentSnapshot.exists() && documentSnapshot.getMetadata().isFromCache()) {
                    taskCompletionSource.setException((Exception)((Object)new FirebaseFirestoreException("Failed to get document because the client is offline.", FirebaseFirestoreException.Code.UNAVAILABLE)));
                    break block6;
                }
                if (documentSnapshot.exists() && documentSnapshot.getMetadata().isFromCache() && source == Source.SERVER) {
                    taskCompletionSource.setException((Exception)((Object)new FirebaseFirestoreException("Failed to get document from server. (However, this document does exist in the local cache. Run again without setting source to SERVER to retrieve the cached document.)", FirebaseFirestoreException.Code.UNAVAILABLE)));
                    break block6;
                }
                taskCompletionSource.setResult((Object)documentSnapshot);
                return;
            }
            catch (ExecutionException executionException) {
                object = executionException;
                throw zzge.zza(executionException, "Failed to register a listener for a single document", new Object[0]);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw zzge.zza(interruptedException, "Failed to register a listener for a single document", new Object[0]);
            }
        }
    }

    static /* synthetic */ DocumentSnapshot zza(DocumentReference documentReference, Task task) throws Exception {
        return new DocumentSnapshot(documentReference.zzb, documentReference.zza, (zzdj)task.getResult(), true);
    }
}

