/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Preconditions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.QuerySnapshot;
import com.google.firebase.firestore.Source;
import com.google.firebase.firestore.obfuscated.zzaf;
import com.google.firebase.firestore.obfuscated.zzag;
import com.google.firebase.firestore.obfuscated.zzah;
import com.google.firebase.firestore.obfuscated.zzaj;
import com.google.firebase.firestore.obfuscated.zzba;
import com.google.firebase.firestore.obfuscated.zzdh;
import com.google.firebase.firestore.obfuscated.zzdj;
import com.google.firebase.firestore.obfuscated.zzdl;
import com.google.firebase.firestore.obfuscated.zzdp;
import com.google.firebase.firestore.obfuscated.zzdq;
import com.google.firebase.firestore.obfuscated.zzds;
import com.google.firebase.firestore.obfuscated.zzem;
import com.google.firebase.firestore.obfuscated.zzet;
import com.google.firebase.firestore.obfuscated.zzg;
import com.google.firebase.firestore.obfuscated.zzge;
import com.google.firebase.firestore.obfuscated.zzgp;
import com.google.firebase.firestore.obfuscated.zzgr;
import com.google.firebase.firestore.obfuscated.zzgy;
import com.google.firebase.firestore.obfuscated.zzhc;
import com.google.firebase.firestore.obfuscated.zzl;
import com.google.firebase.firestore.zzj;
import com.google.firebase.firestore.zzk;
import com.google.firebase.firestore.zzl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@PublicApi
public class Query {
    final zzag zza;
    final FirebaseFirestore zzb;

    /*
     * WARNING - void declaration
     */
    Query(zzag query, FirebaseFirestore firestore) {
        void var2_2;
        void var1_1;
        this.zza = (zzag)Preconditions.checkNotNull((Object)var1_1);
        this.zzb = (FirebaseFirestore)Preconditions.checkNotNull((Object)var2_2);
    }

    @NonNull
    @PublicApi
    public FirebaseFirestore getFirestore() {
        return this.zzb;
    }

    private static void zza(zzdp zzdp2, zzdp object) {
        if (!zzdp2.equals(object)) {
            object = ((zzdp)object).zzf();
            throw new IllegalArgumentException(String.format("Invalid query. You have an inequality where filter (whereLessThan(), whereGreaterThan(), etc.) on field '%s' and so you must also have '%s' as your first orderBy() field, but your first orderBy() is currently on field '%s' instead.", object, object, zzdp2.zzf()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query whereEqualTo(@NonNull String field, @Nullable Object value) {
        void var2_2;
        void var1_1;
        return this.zza(FieldPath.zza((String)var1_1), zzl.zza.zzc, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query whereEqualTo(@NonNull FieldPath fieldPath, @Nullable Object value) {
        void var2_2;
        void var1_1;
        return this.zza((FieldPath)var1_1, zzl.zza.zzc, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query whereLessThan(@NonNull String field, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza(FieldPath.zza((String)var1_1), zzl.zza.zza, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query whereLessThan(@NonNull FieldPath fieldPath, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza((FieldPath)var1_1, zzl.zza.zza, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query whereLessThanOrEqualTo(@NonNull String field, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza(FieldPath.zza((String)var1_1), zzl.zza.zzb, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query whereLessThanOrEqualTo(@NonNull FieldPath fieldPath, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza((FieldPath)var1_1, zzl.zza.zzb, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query whereGreaterThan(@NonNull String field, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza(FieldPath.zza((String)var1_1), zzl.zza.zzd, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query whereGreaterThan(@NonNull FieldPath fieldPath, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza((FieldPath)var1_1, zzl.zza.zzd, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query whereGreaterThanOrEqualTo(@NonNull String field, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza(FieldPath.zza((String)var1_1), zzl.zza.zze, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query whereGreaterThanOrEqualTo(@NonNull FieldPath fieldPath, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza((FieldPath)var1_1, zzl.zza.zze, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query whereArrayContains(@NonNull String field, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza(FieldPath.zza((String)var1_1), zzl.zza.zzf, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query whereArrayContains(@NonNull FieldPath fieldPath, @NonNull Object value) {
        void var2_2;
        void var1_1;
        return this.zza((FieldPath)var1_1, zzl.zza.zzf, var2_2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Query zza(@NonNull FieldPath object, zzl.zza object2, Object object3) {
        zzdp zzdp2;
        Preconditions.checkNotNull((Object)object, (Object)"Provided field path must not be null.");
        Preconditions.checkNotNull((Object)object2, (Object)"Provided op must not be null.");
        Object object4 = ((FieldPath)object).zza();
        object4 = object4;
        if (zzdp2.equals(zzdp.zzb)) {
            if (object2 == zzl.zza.zzf) {
                throw new IllegalArgumentException("Invalid query. You can't perform array-contains queries on FieldPath.documentId() since document IDs are not arrays.");
            }
            if (object3 instanceof String) {
                if (((String)(object3 = (String)object3)).contains("/")) {
                    throw new IllegalArgumentException("Invalid query. When querying with FieldPath.documentId() you must provide a valid document ID, but '" + (String)object3 + "' contains a '/' character.");
                }
                if (((String)object3).isEmpty()) {
                    throw new IllegalArgumentException("Invalid query. When querying with FieldPath.documentId() you must provide a valid document ID, but it was an empty string.");
                }
                object3 = (zzds)this.zza.zza().zza(object3);
                zzge.zza(((zzdh)object3).zzg() % 2 == 0, "Path should be a document key", new Object[0]);
                object3 = zzet.zza(this.getFirestore().zzb(), zzdl.zza((zzds)object3));
            } else {
                if (!(object3 instanceof DocumentReference)) throw new IllegalArgumentException("Invalid query. When querying with FieldPath.documentId() you must provide a valid String or DocumentReference, but it was of type: " + zzhc.zza(object3));
                object3 = (DocumentReference)object3;
                object3 = zzet.zza(this.getFirestore().zzb(), ((DocumentReference)object3).zza());
            }
        } else {
            object3 = this.zzb.zzc().zza(object3);
        }
        object2 = object3 = com.google.firebase.firestore.obfuscated.zzl.zza(((FieldPath)object).zza(), (zzl.zza)((Object)object2), (zzem)object3);
        object = this;
        if (!(object2 instanceof zzaj)) return new Query(this.zza.zza((com.google.firebase.firestore.obfuscated.zzl)object3), this.zzb);
        object4 = (zzaj)object2;
        if (((zzaj)object4).zze()) {
            object4 = ((Query)object).zza.zzi();
            object2 = ((com.google.firebase.firestore.obfuscated.zzl)object2).zza();
            if (object4 != null && !((zzdh)object4).equals(object2)) {
                throw new IllegalArgumentException(String.format("All where filters other than whereEqualTo() must be on the same field. But you have filters on '%s' and '%s'", ((zzdp)object4).zzf(), ((zzdp)object2).zzf()));
            }
            object = ((Query)object).zza.zzh();
            if (object == null) return new Query(this.zza.zza((com.google.firebase.firestore.obfuscated.zzl)object3), this.zzb);
            Query.zza((zzdp)object, (zzdp)object2);
            return new Query(this.zza.zza((com.google.firebase.firestore.obfuscated.zzl)object3), this.zzb);
        } else {
            if (((zzaj)object4).zzc() != zzl.zza.zzf || !((Query)object).zza.zzj()) return new Query(this.zza.zza((com.google.firebase.firestore.obfuscated.zzl)object3), this.zzb);
            throw new IllegalArgumentException("Invalid Query. Queries only support having a single array-contains filter.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query orderBy(@NonNull String field) {
        void var1_1;
        return this.orderBy(FieldPath.zza((String)var1_1), Direction.ASCENDING);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query orderBy(@NonNull FieldPath fieldPath) {
        void var1_1;
        Preconditions.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zza(var1_1.zza(), Direction.ASCENDING);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query orderBy(@NonNull String field, @NonNull Direction direction) {
        void var2_2;
        void var1_1;
        return this.orderBy(FieldPath.zza((String)var1_1), (Direction)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query orderBy(@NonNull FieldPath fieldPath, @NonNull Direction direction) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zza(var1_1.zza(), (Direction)var2_2);
    }

    private Query zza(@NonNull zzdp zzdp2, @NonNull Direction enum_) {
        Preconditions.checkNotNull((Object)enum_, (Object)"Provided direction must not be null.");
        if (this.zza.zzf() != null) {
            throw new IllegalArgumentException("Invalid query. You must not call Query.startAt() or Query.startAfter() before calling Query.orderBy().");
        }
        if (this.zza.zzg() != null) {
            throw new IllegalArgumentException("Invalid query. You must not call Query.endAt() or Query.endAfter() before calling Query.orderBy().");
        }
        zzdp zzdp3 = zzdp2;
        Query query = this;
        zzdp zzdp4 = query.zza.zzi();
        if (query.zza.zzh() == null && zzdp4 != null) {
            Query.zza(zzdp3, zzdp4);
        }
        enum_ = enum_ == Direction.ASCENDING ? zzaf.zza.zza : zzaf.zza.zzb;
        return new Query(this.zza.zza(zzaf.zza((zzaf.zza)enum_, zzdp2)), this.zzb);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public Query limit(long limit) {
        void var1_1;
        if (limit <= 0L) {
            throw new IllegalArgumentException("Invalid Query. Query limit (" + limit + ") is invalid. Limit must be positive.");
        }
        return new Query(this.zza.zza((long)var1_1), this.zzb);
    }

    @NonNull
    @PublicApi
    public Query startAt(@NonNull DocumentSnapshot snapshot) {
        zzg zzg2;
        zzg2 = this.zza("startAt", (DocumentSnapshot)((Object)zzg2), true);
        return new Query(this.zza.zza(zzg2), this.zzb);
    }

    @NonNull
    @PublicApi
    public Query startAt(Object ... fieldValues) {
        zzg zzg2;
        zzg2 = this.zza("startAt", (Object[])zzg2, true);
        return new Query(this.zza.zza(zzg2), this.zzb);
    }

    @NonNull
    @PublicApi
    public Query startAfter(@NonNull DocumentSnapshot snapshot) {
        zzg zzg2;
        zzg2 = this.zza("startAfter", (DocumentSnapshot)((Object)zzg2), false);
        return new Query(this.zza.zza(zzg2), this.zzb);
    }

    @NonNull
    @PublicApi
    public Query startAfter(Object ... fieldValues) {
        zzg zzg2;
        zzg2 = this.zza("startAfter", (Object[])zzg2, false);
        return new Query(this.zza.zza(zzg2), this.zzb);
    }

    @NonNull
    @PublicApi
    public Query endBefore(@NonNull DocumentSnapshot snapshot) {
        zzg zzg2;
        zzg2 = this.zza("endBefore", (DocumentSnapshot)((Object)zzg2), true);
        return new Query(this.zza.zzb(zzg2), this.zzb);
    }

    @NonNull
    @PublicApi
    public Query endBefore(Object ... fieldValues) {
        zzg zzg2;
        zzg2 = this.zza("endBefore", (Object[])zzg2, true);
        return new Query(this.zza.zzb(zzg2), this.zzb);
    }

    @NonNull
    @PublicApi
    public Query endAt(@NonNull DocumentSnapshot snapshot) {
        zzg zzg2;
        zzg2 = this.zza("endAt", (DocumentSnapshot)((Object)zzg2), false);
        return new Query(this.zza.zzb(zzg2), this.zzb);
    }

    @NonNull
    @PublicApi
    public Query endAt(Object ... fieldValues) {
        zzg zzg2;
        zzg2 = this.zza("endAt", (Object[])zzg2, false);
        return new Query(this.zza.zzb(zzg2), this.zzb);
    }

    private zzg zza(String object, DocumentSnapshot object2, boolean bl) {
        Preconditions.checkNotNull((Object)object2, (Object)"Provided snapshot must not be null.");
        if (!((DocumentSnapshot)object2).exists()) {
            throw new IllegalArgumentException("Can't use a DocumentSnapshot for a document that doesn't exist for " + (String)object + "().");
        }
        object = ((DocumentSnapshot)object2).zza();
        object2 = new ArrayList();
        for (zzaf zzaf2 : this.zza.zzl()) {
            if (zzaf2.zzb().equals(zzdp.zzb)) {
                object2.add(zzet.zza(this.zzb.zzb(), ((zzdq)object).zzd()));
                continue;
            }
            zzem zzem2 = ((zzdj)object).zza(zzaf2.zzb());
            if (zzem2 != null) {
                object2.add(zzem2);
                continue;
            }
            throw new IllegalArgumentException("Invalid query. You are trying to start or end a query using a document for which the field '" + zzaf2.zzb() + "' (used as the orderBy) does not exist.");
        }
        return new zzg((List<zzem>)object2, bl);
    }

    private zzg zza(String string, Object[] objectArray, boolean bl) {
        List<zzaf> list = this.zza.zzk();
        if (objectArray.length > list.size()) {
            throw new IllegalArgumentException("Too many arguments provided to " + string + "(). The number of arguments must be less than or equal to the number of orderBy() clauses.");
        }
        ArrayList<zzem> arrayList = new ArrayList<zzem>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            zzaf zzaf2 = list.get(i);
            if (zzaf2.zzb().equals(zzdp.zzb)) {
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException("Invalid query. Expected a string for document ID in " + string + "(), but got " + object + ".");
                }
                if (((String)(object = (String)object)).contains("/")) {
                    throw new IllegalArgumentException("Invalid query. Document ID '" + (String)object + "' contains a slash in " + string + "().");
                }
                object = zzdl.zza((zzds)this.zza.zza().zza(object));
                arrayList.add(zzet.zza(this.zzb.zzb(), (zzdl)object));
                continue;
            }
            object = this.zzb.zzc().zza(object);
            arrayList.add((zzem)object);
        }
        return new zzg(arrayList, bl);
    }

    @NonNull
    @PublicApi
    public Task<QuerySnapshot> get() {
        return this.get(Source.DEFAULT);
    }

    @NonNull
    @PublicApi
    public Task<QuerySnapshot> get(Source source) {
        Object object;
        if (source == Source.CACHE) {
            return this.zzb.zza().zza(this.zza).continueWith(zzgr.zzb, zzj.zza(this));
        }
        void var2_2 = object;
        object = this;
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        TaskCompletionSource taskCompletionSource2 = new TaskCompletionSource();
        zzge zzge2 = new zzge();
        new zzge().zza = true;
        zzge2.zzb = true;
        zzge2.zzc = true;
        object = ((Query)object).zza(zzgr.zzb, zzge2, null, zzk.zza(taskCompletionSource, taskCompletionSource2, (Source)var2_2));
        taskCompletionSource2.setResult(object);
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull EventListener<QuerySnapshot> listener) {
        void var1_1;
        return this.addSnapshotListener(MetadataChanges.EXCLUDE, (EventListener<QuerySnapshot>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull EventListener<QuerySnapshot> listener) {
        void var2_2;
        void var1_1;
        return this.addSnapshotListener((Executor)var1_1, MetadataChanges.EXCLUDE, (EventListener<QuerySnapshot>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull EventListener<QuerySnapshot> listener) {
        void var2_2;
        void var1_1;
        return this.addSnapshotListener((Activity)var1_1, MetadataChanges.EXCLUDE, (EventListener<QuerySnapshot>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull MetadataChanges metadataChanges, @NonNull EventListener<QuerySnapshot> listener) {
        void var2_2;
        void var1_1;
        return this.addSnapshotListener(zzgr.zza, (MetadataChanges)var1_1, (EventListener<QuerySnapshot>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull MetadataChanges metadataChanges, @NonNull EventListener<QuerySnapshot> listener) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull((Object)executor, (Object)"Provided executor must not be null.");
        Preconditions.checkNotNull((Object)((Object)metadataChanges), (Object)"Provided MetadataChanges value must not be null.");
        Preconditions.checkNotNull(listener, (Object)"Provided EventListener must not be null.");
        return this.zza((Executor)var1_1, Query.zza((MetadataChanges)var2_2), null, (EventListener<QuerySnapshot>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull MetadataChanges metadataChanges, @NonNull EventListener<QuerySnapshot> listener) {
        void var3_3;
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull((Object)activity, (Object)"Provided activity must not be null.");
        Preconditions.checkNotNull((Object)((Object)metadataChanges), (Object)"Provided MetadataChanges value must not be null.");
        Preconditions.checkNotNull(listener, (Object)"Provided EventListener must not be null.");
        return this.zza(zzgr.zza, Query.zza((MetadataChanges)var2_2), (Activity)var1_1, (EventListener<QuerySnapshot>)var3_3);
    }

    private ListenerRegistration zza(Executor object, zzge object2, @Nullable Activity activity, EventListener<QuerySnapshot> eventListener) {
        object = new zzgp((Executor)object, zzl.zza(this, eventListener));
        object2 = this.zzb.zza().zza(this.zza, (zzge)object2, (EventListener<zzba>)object);
        return new zzgy(this.zzb.zza(), (zzah)object2, activity, (zzgp<zzba>)object);
    }

    public boolean equals(Object o) {
        Query query;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        query = query;
        return this.zza.equals(query.zza) && this.zzb.equals(query.zzb);
    }

    public int hashCode() {
        int n = this.zza.hashCode();
        n = n * 31 + this.zzb.hashCode();
        return n;
    }

    private static zzge zza(MetadataChanges metadataChanges) {
        zzge zzge2 = new zzge();
        new zzge().zza = metadataChanges == MetadataChanges.INCLUDE;
        zzge2.zzb = metadataChanges == MetadataChanges.INCLUDE;
        zzge2.zzc = false;
        return zzge2;
    }

    static /* synthetic */ void zza(Query object, EventListener eventListener, zzba zzba2, FirebaseFirestoreException firebaseFirestoreException) {
        if (zzba2 != null) {
            object = new QuerySnapshot((Query)object, zzba2, ((Query)object).zzb);
            eventListener.onEvent(object, null);
            return;
        }
        zzge.zza(firebaseFirestoreException != null, "Got event without value or error set", new Object[0]);
        eventListener.onEvent(null, firebaseFirestoreException);
    }

    static /* synthetic */ void zza(TaskCompletionSource taskCompletionSource, TaskCompletionSource object, Source source, QuerySnapshot querySnapshot, FirebaseFirestoreException firebaseFirestoreException) {
        if (firebaseFirestoreException != null) {
            taskCompletionSource.setException((Exception)((Object)firebaseFirestoreException));
            return;
        }
        try {
            object = (ListenerRegistration)Tasks.await((Task)object.getTask());
            object.remove();
            if (!querySnapshot.getMetadata().isFromCache() || source != Source.SERVER) {
                taskCompletionSource.setResult((Object)querySnapshot);
                return;
            }
            taskCompletionSource.setException((Exception)((Object)new FirebaseFirestoreException("Failed to get documents from server. (However, these documents may exist in the local cache. Run again without setting source to SERVER to retrieve the cached documents.)", FirebaseFirestoreException.Code.UNAVAILABLE)));
        }
        catch (ExecutionException executionException) {
            object = executionException;
            throw zzge.zza(executionException, "Failed to register a listener for a query result", new Object[0]);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw zzge.zza(interruptedException, "Failed to register a listener for a query result", new Object[0]);
        }
    }

    static /* synthetic */ QuerySnapshot zza(Query query, Task task) throws Exception {
        return new QuerySnapshot(new Query(query.zza, query.zzb), (zzba)task.getResult(), query.zzb);
    }

    @Keep
    public static enum Direction {
        ASCENDING,
        DESCENDING;

    }
}

