/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.obfuscated;

import com.google.common.base.Preconditions;
import com.google.firebase.Timestamp;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.obfuscated.zzag;
import com.google.firebase.firestore.obfuscated.zzbb;
import com.google.firebase.firestore.obfuscated.zzbw;
import com.google.firebase.firestore.obfuscated.zzbz;
import com.google.firebase.firestore.obfuscated.zzdh;
import com.google.firebase.firestore.obfuscated.zzdl;
import com.google.firebase.firestore.obfuscated.zzds;
import com.google.firebase.firestore.obfuscated.zzdy;
import com.google.firebase.firestore.obfuscated.zzdz;
import com.google.firebase.firestore.obfuscated.zzgd;
import com.google.firebase.firestore.obfuscated.zzge;
import com.google.firebase.firestore.obfuscated.zzhc;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class zzbv
implements zzbz {
    private final List<zzdz> zza;
    private ImmutableSortedSet<zzbb> zzb;
    private int zzc;
    private int zzd;
    private ByteString zze;
    private final zzbw zzf;

    zzbv(zzbw zzbw2) {
        this.zzf = zzbw2;
        this.zza = new ArrayList<zzdz>();
        this.zzb = new ImmutableSortedSet(Collections.emptyList(), zzbb.zza);
        this.zzc = 1;
        this.zzd = -1;
        this.zze = zzgd.zzc;
    }

    @Override
    public final void zza() {
        zzbv zzbv2 = this;
        if (zzbv2.zza.isEmpty()) {
            this.zzc = 1;
            this.zzd = -1;
        }
        zzge.zza(this.zzd < this.zzc, "highestAcknowledgedBatchId must be less than the nextBatchId", new Object[0]);
    }

    @Override
    public final int zzb() {
        return this.zzd;
    }

    @Override
    public final void zza(zzdz zzdz2, ByteString byteString) {
        int n = zzdz2.zzb();
        zzge.zza(n > this.zzd, "Mutation batchIds must be acknowledged in order", new Object[0]);
        int n2 = this.zza(n, "acknowledged");
        zzdz zzdz3 = this.zza.get(n2);
        zzge.zza(n == zzdz3.zzb(), "Queue ordering failure: expected batch %d, got batch %d", n, zzdz3.zzb());
        zzge.zza(!zzdz3.zzd(), "Can't acknowledge a previously removed batch", new Object[0]);
        this.zzd = n;
        this.zze = (ByteString)Preconditions.checkNotNull((Object)byteString);
    }

    @Override
    public final ByteString zzc() {
        return this.zze;
    }

    @Override
    public final void zza(ByteString byteString) {
        this.zze = (ByteString)Preconditions.checkNotNull((Object)byteString);
    }

    @Override
    public final zzdz zza(Timestamp object, List<zzdy> object2) {
        zzge.zza(!object2.isEmpty(), "Mutation batches should not be empty", new Object[0]);
        int n = this.zzc++;
        int n2 = this.zza.size();
        if (n2 > 0) {
            zzdz zzdz2 = this.zza.get(n2 - 1);
            zzge.zza(zzdz2.zzb() < n, "Mutation batchIds must be monotonically increasing order", new Object[0]);
        }
        zzdz zzdz3 = new zzdz(n, (Timestamp)object, (List<zzdy>)object2);
        this.zza.add(zzdz3);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (zzdy)object.next();
            this.zzb = this.zzb.insert((Object)new zzbb(((zzdy)object2).zza(), n));
        }
        return zzdz3;
    }

    @Override
    @Nullable
    public final zzdz zza(int n) {
        int n2 = this.zze(n);
        if (n2 < 0 || n2 >= this.zza.size()) {
            return null;
        }
        zzdz zzdz2 = this.zza.get(n2);
        zzge.zza(zzdz2.zzb() == n, "If found batch must match", new Object[0]);
        if (zzdz2.zzd()) {
            return null;
        }
        return zzdz2;
    }

    @Override
    @Nullable
    public final zzdz zzb(int n) {
        int n2 = this.zza.size();
        n = Math.max(n, this.zzd) + 1;
        int n3 = n = (n = this.zze(n)) < 0 ? 0 : n;
        while (n < n2) {
            zzdz zzdz2 = this.zza.get(n);
            if (!zzdz2.zzd()) {
                return zzdz2;
            }
            ++n;
        }
        return null;
    }

    @Override
    public final List<zzdz> zzd() {
        return this.zzd(this.zza.size());
    }

    @Override
    public final List<zzdz> zzc(int n) {
        int n2 = this.zza.size();
        n = (n = this.zze(n)) < 0 ? 0 : (n >= n2 ? n2 : ++n);
        return this.zzd(n);
    }

    @Override
    public final List<zzdz> zza(zzdl zzdl2) {
        Object object;
        Object object2 = new zzbb(zzdl2, 0);
        ArrayList<zzdz> arrayList = new ArrayList<zzdz>();
        object2 = this.zzb.iteratorFrom(object2);
        while (object2.hasNext() && zzdl2.equals(((zzbb)(object = (zzbb)object2.next())).zza())) {
            zzge.zza((object = this.zza(((zzbb)object).zzb())) != null, "Batches in the index must exist in the main table", new Object[0]);
            arrayList.add((zzdz)object);
        }
        return arrayList;
    }

    @Override
    public final List<zzdz> zza(Iterable<zzdl> object) {
        ImmutableSortedSet immutableSortedSet = new ImmutableSortedSet(Collections.emptyList(), zzhc.zzb());
        object = object.iterator();
        while (object.hasNext()) {
            zzbb zzbb2;
            zzdl zzdl2 = (zzdl)object.next();
            Object object2 = new zzbb(zzdl2, 0);
            object2 = this.zzb.iteratorFrom(object2);
            while (object2.hasNext() && zzdl2.equals((zzbb2 = (zzbb)object2.next()).zza())) {
                immutableSortedSet = immutableSortedSet.insert((Object)zzbb2.zzb());
            }
        }
        return this.zza((ImmutableSortedSet<Integer>)immutableSortedSet);
    }

    @Override
    public final List<zzdz> zza(zzag object) {
        zzbb zzbb2;
        zzds zzds2;
        object = ((zzag)object).zza();
        int n = ((zzdh)object).zzg() + 1;
        Object object2 = object;
        if (!zzdl.zzb((zzds)object2)) {
            object2 = (zzds)((Object)((zzdh)object2).zza(""));
        }
        object2 = new zzbb(zzdl.zza((zzds)object2), 0);
        ImmutableSortedSet immutableSortedSet = new ImmutableSortedSet(Collections.emptyList(), zzhc.zzb());
        object2 = this.zzb.iteratorFrom(object2);
        while (object2.hasNext() && ((zzdh)object).zzc(zzds2 = (zzbb2 = (zzbb)object2.next()).zza().zzd())) {
            if (zzds2.zzg() != n) continue;
            immutableSortedSet = immutableSortedSet.insert((Object)zzbb2.zzb());
        }
        return this.zza((ImmutableSortedSet<Integer>)immutableSortedSet);
    }

    private List<zzdz> zza(ImmutableSortedSet<Integer> object) {
        ArrayList<zzdz> arrayList = new ArrayList<zzdz>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Integer)object.next();
            if ((object2 = this.zza((Integer)object2)) == null) continue;
            arrayList.add((zzdz)object2);
        }
        return arrayList;
    }

    @Override
    public final void zza(List<zzdz> object) {
        zzdz immutableSortedSet;
        int n = object.size();
        zzge.zza(n > 0, "Should not remove mutations when none exist.", new Object[0]);
        int n2 = ((zzdz)object.get(0)).zzb();
        int n3 = this.zza.size();
        int n4 = this.zza(n2, "removed");
        zzge.zza(this.zza.get(n4).zzb() == n2, "Removed batches must exist in the queue", new Object[0]);
        n2 = 1;
        int n5 = n4 + 1;
        while (n2 < n && n5 < n3) {
            immutableSortedSet = this.zza.get(n5);
            if (immutableSortedSet.zzd()) {
                ++n5;
                continue;
            }
            zzge.zza(immutableSortedSet.zzb() == ((zzdz)object.get(n2)).zzb(), "Removed batches must be contiguous in the queue", new Object[0]);
            ++n2;
            ++n5;
        }
        if (n4 == 0) {
            while (n5 < n3 && (immutableSortedSet = this.zza.get(n5)).zzd()) {
                ++n5;
            }
            this.zza.subList(n4, n5).clear();
        } else {
            for (int i = n4; i < n5; ++i) {
                this.zza.set(i, this.zza.get(i).zze());
            }
        }
        ImmutableSortedSet immutableSortedSet2 = this.zzb;
        object = object.iterator();
        while (object.hasNext()) {
            zzdz zzdz3 = (zzdz)object.next();
            n2 = zzdz3.zzb();
            for (zzdy object2 : zzdz3.zzf()) {
                zzdl zzdl2 = object2.zza();
                this.zzf.zzd().zzc(zzdl2);
                zzbb zzbb2 = new zzbb(zzdl2, n2);
                immutableSortedSet2 = immutableSortedSet2.remove((Object)zzbb2);
            }
        }
        this.zzb = immutableSortedSet2;
    }

    @Override
    public final void zze() {
        if (this.zza.isEmpty()) {
            zzge.zza(this.zzb.isEmpty(), "Document leak -- detected dangling mutation references when queue is empty.", new Object[0]);
        }
    }

    final boolean zzb(zzdl zzdl2) {
        Object object = new zzbb(zzdl2, 0);
        if (!(object = this.zzb.iteratorFrom(object)).hasNext()) {
            return false;
        }
        object = ((zzbb)object.next()).zza();
        return ((zzdl)object).equals(zzdl2);
    }

    private List<zzdz> zzd(int n) {
        ArrayList<zzdz> arrayList = new ArrayList<zzdz>(n);
        for (int i = 0; i < n; ++i) {
            zzdz zzdz2 = this.zza.get(i);
            if (zzdz2.zzd()) continue;
            arrayList.add(zzdz2);
        }
        return arrayList;
    }

    private int zze(int n) {
        if (this.zza.isEmpty()) {
            return 0;
        }
        zzdz zzdz2 = this.zza.get(0);
        int n2 = zzdz2.zzb();
        return n - n2;
    }

    private int zza(int n, String string) {
        zzge.zza((n = this.zze(n)) >= 0 && n < this.zza.size(), "Batches must exist to be %s", string);
        return n;
    }
}

