/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.obfuscated;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.firestore.obfuscated.zzge;
import com.google.firebase.firestore.obfuscated.zzgg;
import com.google.firebase.firestore.obfuscated.zzgh;
import com.google.firebase.firestore.obfuscated.zzgi;
import com.google.firebase.firestore.obfuscated.zzgj;
import com.google.firebase.firestore.obfuscated.zzgk;
import com.google.firebase.firestore.obfuscated.zzgl;
import com.google.firebase.firestore.obfuscated.zzgm;
import com.google.firebase.firestore.obfuscated.zzha;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;

public class zzgf {
    private final Thread zza;
    private final ScheduledThreadPoolExecutor zzb;
    private final ArrayList<zzb> zzc = new ArrayList();

    public static <TResult> Task<TResult> zza(Executor executor, Callable<Task<TResult>> callable) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        executor.execute(zzgg.zza(callable, executor, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    public zzgf() {
        zza zza2 = new zza(this, 0);
        this.zza = Executors.defaultThreadFactory().newThread(zza2);
        this.zza.setName("FirestoreWorker");
        this.zza.setDaemon(true);
        this.zza.setUncaughtExceptionHandler(zzgh.zza(this));
        this.zzb = new ScheduledThreadPoolExecutor(this, 1, zza2){
            private /* synthetic */ zzgf zza;
            {
                this.zza = zzgf2;
                super(1, threadFactory);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                if (t == null && r instanceof Future) {
                    Object object;
                    object = (Future)object;
                    try {
                        if (object.isDone()) {
                            object.get();
                        }
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (ExecutionException executionException) {
                        object = executionException;
                        t = executionException.getCause();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (t != null) {
                    void var2_2;
                    this.zza.zza((Throwable)var2_2);
                }
            }
        };
        this.zzb.setKeepAliveTime(3L, TimeUnit.SECONDS);
    }

    public final Executor zza() {
        return this.zzb;
    }

    public final void zzb() {
        Thread thread = Thread.currentThread();
        if (this.zza != thread) {
            throw zzge.zza("We are running on the wrong thread. Expected to be on the AsyncQueue thread %s/%d but was %s/%d", this.zza.getName(), this.zza.getId(), thread.getName(), thread.getId());
        }
    }

    @CheckReturnValue
    public final <T> Task<T> zza(Callable<T> callable) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        try {
            this.zzb.execute(zzgi.zza(taskCompletionSource, callable));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            zzha.zza(zzgf.class.getSimpleName(), "Refused to enqueue task after panic", new Object[0]);
        }
        return taskCompletionSource.getTask();
    }

    @CheckReturnValue
    public final Task<Void> zza(Runnable runnable) {
        return this.zza(zzgj.zza(runnable));
    }

    public final void zzb(Runnable runnable) {
        this.zza(runnable);
    }

    public final zzb zza(zzc object, long l, Runnable runnable) {
        boolean bl;
        zzgf zzgf2;
        zzc zzc2;
        block1: {
            zzc2 = object;
            zzgf2 = this;
            for (zzb zzb2 : zzgf2.zzc) {
                if (zzb2.zza != zzc2) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        zzge.zza(!bl, "Attempted to schedule multiple operations with timer id %s.", object);
        zzc zzc3 = object;
        object = runnable;
        long l2 = l;
        zzc2 = zzc3;
        zzgf2 = this;
        long l3 = System.currentTimeMillis() + l2;
        object = new zzb(zzgf2, zzc2, l3, (Runnable)object, 0);
        com.google.firebase.firestore.obfuscated.zzgf$zzb.zza((zzb)object, l2);
        this.zzc.add((zzb)object);
        return object;
    }

    public final void zza(Throwable throwable) {
        this.zzb.shutdownNow();
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(zzgk.zza(throwable));
    }

    static /* synthetic */ void zzb(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            OutOfMemoryError outOfMemoryError = new OutOfMemoryError("Firestore (0.6.6-dev) ran out of memory. Check your queries to make sure they are not loading an excessive amount of data.");
            outOfMemoryError.initCause(throwable);
            throw outOfMemoryError;
        }
        throw new RuntimeException("Internal error in Firestore (0.6.6-dev).", throwable);
    }

    static /* synthetic */ Void zzc(Runnable runnable) throws Exception {
        runnable.run();
        return null;
    }

    static /* synthetic */ void zza(TaskCompletionSource taskCompletionSource, Callable callable) {
        try {
            taskCompletionSource.setResult(callable.call());
            return;
        }
        catch (Exception exception) {
            taskCompletionSource.setException(exception);
            throw new RuntimeException(exception);
        }
    }

    static /* synthetic */ void zza(zzgf zzgf2, Throwable throwable) {
        zzgf2.zza(throwable);
    }

    static /* synthetic */ void zza(Callable callable, Executor executor, TaskCompletionSource taskCompletionSource) {
        try {
            ((Task)callable.call()).continueWith(executor, zzgl.zza(taskCompletionSource));
            return;
        }
        catch (Exception exception) {
            taskCompletionSource.setException(exception);
            return;
        }
        catch (Throwable throwable) {
            IllegalStateException illegalStateException = new IllegalStateException("Unhandled throwable in callTask.", throwable);
            taskCompletionSource.setException((Exception)illegalStateException);
            return;
        }
    }

    static /* synthetic */ Void zza(TaskCompletionSource taskCompletionSource, Task task) throws Exception {
        if (task.isSuccessful()) {
            taskCompletionSource.setResult(task.getResult());
        } else {
            taskCompletionSource.setException(task.getException());
        }
        return null;
    }

    static /* synthetic */ void zza(zzgf zzgf2, zzb zzb2) {
        boolean bl = zzgf2.zzc.remove(zzb2);
        zzge.zza(bl, "Delayed task not found.", new Object[0]);
    }

    final class zza
    implements Runnable,
    ThreadFactory {
        private final CountDownLatch zza = new CountDownLatch(1);
        private Runnable zzb;
        private /* synthetic */ zzgf zzc;

        private zza(zzgf zzgf2) {
            this.zzc = zzgf2;
        }

        @Override
        public final void run() {
            try {
                this.zza.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            this.zzb.run();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Thread newThread(@NonNull Runnable runnable) {
            void var1_1;
            zzge.zza(this.zzb == null, "Only one thread may be created in an AsyncQueue.", new Object[0]);
            this.zzb = var1_1;
            this.zza.countDown();
            return this.zzc.zza;
        }

        /* synthetic */ zza(zzgf zzgf2, byte by) {
            this(zzgf2);
        }
    }

    public final class zzb {
        private final zzc zza;
        private final Runnable zzb;
        private ScheduledFuture zzc;
        private /* synthetic */ zzgf zzd;

        private zzb(zzgf zzgf2, zzc zzc2, long l, Runnable runnable) {
            this.zzd = zzgf2;
            this.zza = zzc2;
            this.zzb = runnable;
        }

        public final void zza() {
            this.zzd.zzb();
            if (this.zzc != null) {
                this.zzc.cancel(false);
                this.zzb();
            }
        }

        private void zzb() {
            zzge.zza(this.zzc != null, "Caller should have verified scheduledFuture is non-null.", new Object[0]);
            this.zzc = null;
            zzgf.zza(this.zzd, this);
        }

        /* synthetic */ zzb(zzgf zzgf2, zzc zzc2, long l, Runnable runnable, byte by) {
            this(zzgf2, zzc2, l, runnable);
        }

        static /* synthetic */ void zza(zzb zzb2, long l) {
            long l2 = l;
            v0.zzc = zzb2.zzd.zzb.schedule(zzgm.zza(zzb2), l2, TimeUnit.MILLISECONDS);
        }

        static /* synthetic */ void zzb(zzb zzb2) {
            zzb2.zzd.zzb();
            if (zzb2.zzc != null) {
                zzb2.zzb();
                zzb2.zzb.run();
            }
        }
    }

    public static final class zzc
    extends Enum<zzc> {
        private static /* enum */ zzc zzf = new zzc();
        public static final /* enum */ zzc zza = new zzc();
        public static final /* enum */ zzc zzb = new zzc();
        public static final /* enum */ zzc zzc = new zzc();
        public static final /* enum */ zzc zzd = new zzc();
        public static final /* enum */ zzc zze = new zzc();

        static {
            zzc[] zzcArray = new zzc[]{zzf, zza, zzb, zzc, zzd, zze};
        }
    }
}

