/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.mutation.FieldMask;
import com.google.firebase.firestore.model.mutation.FieldTransform;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.PatchMutation;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firebase.firestore.model.mutation.SetMutation;
import com.google.firebase.firestore.model.mutation.TransformMutation;
import com.google.firebase.firestore.model.mutation.TransformOperation;
import com.google.firebase.firestore.model.value.ObjectValue;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class UserData {
    private UserData() {
    }

    public static class ParsedUpdateData {
        private final ObjectValue data;
        private final FieldMask fieldMask;
        private final List<FieldTransform> fieldTransforms;

        ParsedUpdateData(ObjectValue data, FieldMask fieldMask, List<FieldTransform> fieldTransforms) {
            this.data = data;
            this.fieldMask = fieldMask;
            this.fieldTransforms = fieldTransforms;
        }

        public List<FieldTransform> getFieldTransforms() {
            return this.fieldTransforms;
        }

        public List<Mutation> toMutationList(DocumentKey key, Precondition precondition) {
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(new PatchMutation(key, this.data, this.fieldMask, precondition));
            if (!this.fieldTransforms.isEmpty()) {
                mutations.add(new TransformMutation(key, this.fieldTransforms));
            }
            return mutations;
        }
    }

    public static class ParsedSetData {
        private final ObjectValue data;
        @Nullable
        private final FieldMask fieldMask;
        private final List<FieldTransform> fieldTransforms;

        ParsedSetData(ObjectValue data, @Nullable FieldMask fieldMask, List<FieldTransform> fieldTransforms) {
            this.data = data;
            this.fieldMask = fieldMask;
            this.fieldTransforms = fieldTransforms;
        }

        public List<Mutation> toMutationList(DocumentKey key, Precondition precondition) {
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            if (this.fieldMask != null) {
                mutations.add(new PatchMutation(key, this.data, this.fieldMask, precondition));
            } else {
                mutations.add(new SetMutation(key, this.data, precondition));
            }
            if (!this.fieldTransforms.isEmpty()) {
                mutations.add(new TransformMutation(key, this.fieldTransforms));
            }
            return mutations;
        }
    }

    public static class ParseContext {
        private final Pattern reservedFieldRegex = Pattern.compile("^__.*__$");
        private final ParseAccumulator accumulator;
        @Nullable
        private final FieldPath path;
        private final boolean arrayElement;

        private ParseContext(ParseAccumulator accumulator, @Nullable FieldPath path, boolean arrayElement) {
            this.accumulator = accumulator;
            this.path = path;
            this.arrayElement = arrayElement;
        }

        public boolean isArrayElement() {
            return this.arrayElement;
        }

        public Source getDataSource() {
            return this.accumulator.dataSource;
        }

        public FieldPath getPath() {
            return this.path;
        }

        public boolean isWrite() {
            switch (this.accumulator.dataSource) {
                case Set: 
                case MergeSet: 
                case Update: {
                    return true;
                }
                case Argument: {
                    return false;
                }
            }
            throw Assert.fail("Unexpected case for UserDataSource: %s", this.accumulator.dataSource.name());
        }

        public ParseContext childContext(String fieldName) {
            FieldPath childPath = this.path == null ? null : (FieldPath)((Object)this.path.append(fieldName));
            ParseContext context = new ParseContext(this.accumulator, childPath, false);
            context.validatePathSegment(fieldName);
            return context;
        }

        public ParseContext childContext(FieldPath fieldPath) {
            FieldPath childPath = this.path == null ? null : this.path.append(fieldPath);
            ParseContext context = new ParseContext(this.accumulator, childPath, false);
            context.validatePath();
            return context;
        }

        public ParseContext childContext(int arrayIndex) {
            return new ParseContext(this.accumulator, null, true);
        }

        public void addToFieldMask(FieldPath fieldPath) {
            this.accumulator.addToFieldMask(fieldPath);
        }

        public void addToFieldTransforms(FieldPath fieldPath, TransformOperation transformOperation) {
            this.accumulator.addToFieldTransforms(fieldPath, transformOperation);
        }

        public RuntimeException createError(String reason) {
            String fieldDescription = this.path == null || this.path.isEmpty() ? "" : " (found in field " + this.path.toString() + ")";
            return new IllegalArgumentException("Invalid data. " + reason + fieldDescription);
        }

        private void validatePath() {
            if (this.path == null) {
                return;
            }
            for (int i = 0; i < this.path.length(); ++i) {
                this.validatePathSegment(this.path.getSegment(i));
            }
        }

        private void validatePathSegment(String segment) {
            if (this.isWrite() && this.reservedFieldRegex.matcher(segment).find()) {
                throw this.createError("Document fields cannot begin and end with __");
            }
        }
    }

    public static class ParseAccumulator {
        private final Source dataSource;
        private final Set<FieldPath> fieldMask;
        private final ArrayList<FieldTransform> fieldTransforms;

        public ParseAccumulator(Source dataSource) {
            this.dataSource = dataSource;
            this.fieldMask = new HashSet<FieldPath>();
            this.fieldTransforms = new ArrayList();
        }

        public Source getDataSource() {
            return this.dataSource;
        }

        public List<FieldTransform> getFieldTransforms() {
            return this.fieldTransforms;
        }

        public ParseContext rootContext() {
            return new ParseContext(this, FieldPath.EMPTY_PATH, false);
        }

        public boolean contains(FieldPath fieldPath) {
            for (FieldPath field : this.fieldMask) {
                if (!fieldPath.isPrefixOf(field)) continue;
                return true;
            }
            for (FieldTransform fieldTransform : this.fieldTransforms) {
                if (!fieldPath.isPrefixOf(fieldTransform.getFieldPath())) continue;
                return true;
            }
            return false;
        }

        void addToFieldMask(FieldPath fieldPath) {
            this.fieldMask.add(fieldPath);
        }

        void addToFieldTransforms(FieldPath fieldPath, TransformOperation transformOperation) {
            this.fieldTransforms.add(new FieldTransform(fieldPath, transformOperation));
        }

        public ParsedSetData toMergeData(ObjectValue data) {
            return new ParsedSetData(data, FieldMask.fromSet(this.fieldMask), Collections.unmodifiableList(this.fieldTransforms));
        }

        public ParsedSetData toMergeData(ObjectValue data, FieldMask userFieldMask) {
            ArrayList<FieldTransform> coveredFieldTransforms = new ArrayList<FieldTransform>();
            for (FieldTransform parsedTransform : this.fieldTransforms) {
                if (!userFieldMask.covers(parsedTransform.getFieldPath())) continue;
                coveredFieldTransforms.add(parsedTransform);
            }
            return new ParsedSetData(data, userFieldMask, Collections.unmodifiableList(coveredFieldTransforms));
        }

        public ParsedSetData toSetData(ObjectValue data) {
            return new ParsedSetData(data, null, Collections.unmodifiableList(this.fieldTransforms));
        }

        public ParsedUpdateData toUpdateData(ObjectValue data) {
            return new ParsedUpdateData(data, FieldMask.fromSet(this.fieldMask), Collections.unmodifiableList(this.fieldTransforms));
        }
    }

    public static enum Source {
        Set,
        MergeSet,
        Update,
        Argument;

    }
}

