/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import com.google.common.base.Preconditions;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.remote.AbstractStream;
import com.google.firebase.firestore.remote.FirestoreChannel;
import com.google.firebase.firestore.remote.RemoteSerializer;
import com.google.firebase.firestore.remote.Stream;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firestore.v1.FirestoreGrpc;
import com.google.firestore.v1.WriteRequest;
import com.google.firestore.v1.WriteResponse;
import com.google.firestore.v1.WriteResult;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WriteStream
extends AbstractStream<WriteRequest, WriteResponse, Callback> {
    public static final ByteString EMPTY_STREAM_TOKEN = ByteString.EMPTY;
    private final RemoteSerializer serializer;
    protected boolean handshakeComplete = false;
    private ByteString lastStreamToken = EMPTY_STREAM_TOKEN;

    WriteStream(FirestoreChannel channel, AsyncQueue workerQueue, RemoteSerializer serializer, Callback listener) {
        super(channel, FirestoreGrpc.getWriteMethod(), workerQueue, AsyncQueue.TimerId.WRITE_STREAM_CONNECTION_BACKOFF, AsyncQueue.TimerId.WRITE_STREAM_IDLE, listener);
        this.serializer = serializer;
    }

    @Override
    public void start() {
        this.handshakeComplete = false;
        super.start();
    }

    @Override
    protected void tearDown() {
        if (this.handshakeComplete) {
            this.writeMutations(Collections.<Mutation>emptyList());
        }
    }

    boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    ByteString getLastStreamToken() {
        return this.lastStreamToken;
    }

    void setLastStreamToken(ByteString streamToken) {
        this.lastStreamToken = (ByteString)Preconditions.checkNotNull((Object)streamToken);
    }

    void writeHandshake() {
        Assert.hardAssert(this.isOpen(), "Writing handshake requires an opened stream", new Object[0]);
        Assert.hardAssert(!this.handshakeComplete, "Handshake already completed", new Object[0]);
        WriteRequest.Builder request = WriteRequest.newBuilder().setDatabase(this.serializer.databaseName());
        this.writeRequest((WriteRequest)request.build());
    }

    void writeMutations(List<Mutation> mutations) {
        Assert.hardAssert(this.isOpen(), "Writing mutations requires an opened stream", new Object[0]);
        Assert.hardAssert(this.handshakeComplete, "Handshake must be complete before writing mutations", new Object[0]);
        WriteRequest.Builder request = WriteRequest.newBuilder();
        for (Mutation mutation : mutations) {
            request.addWrites(this.serializer.encodeMutation(mutation));
        }
        request.setStreamToken(this.lastStreamToken);
        this.writeRequest((WriteRequest)request.build());
    }

    @Override
    public void onNext(WriteResponse response) {
        this.lastStreamToken = response.getStreamToken();
        if (!this.handshakeComplete) {
            this.handshakeComplete = true;
            ((Callback)this.listener).onHandshakeComplete();
        } else {
            this.backoff.reset();
            SnapshotVersion commitVersion = this.serializer.decodeVersion(response.getCommitTime());
            int count = response.getWriteResultsCount();
            ArrayList<MutationResult> results = new ArrayList<MutationResult>(count);
            for (int i = 0; i < count; ++i) {
                WriteResult result = response.getWriteResults(i);
                results.add(this.serializer.decodeMutationResult(result, commitVersion));
            }
            ((Callback)this.listener).onWriteResponse(commitVersion, results);
        }
    }

    public static interface Callback
    extends Stream.StreamCallback {
        public void onHandshakeComplete();

        public void onWriteResponse(SnapshotVersion var1, List<MutationResult> var2);
    }
}

