/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.bundle;

import androidx.annotation.Nullable;
import com.google.firebase.firestore.bundle.BundleDocument;
import com.google.firebase.firestore.bundle.BundleElement;
import com.google.firebase.firestore.bundle.BundleMetadata;
import com.google.firebase.firestore.bundle.BundleSerializer;
import com.google.firebase.firestore.bundle.BundledDocumentMetadata;
import com.google.firebase.firestore.bundle.NamedQuery;
import com.google.firebase.firestore.util.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.json.JSONException;
import org.json.JSONObject;

public class BundleReader {
    protected static final int BUFFER_CAPACITY = 1024;
    private final BundleSerializer serializer;
    private final InputStreamReader dataReader;
    private final Charset charset = Charset.forName("UTF-8");
    @Nullable
    BundleMetadata metadata;
    private CharBuffer buffer;
    long bytesRead;

    public BundleReader(BundleSerializer serializer, InputStream data) {
        this.serializer = serializer;
        this.dataReader = new InputStreamReader(data, this.charset);
        this.buffer = CharBuffer.allocate(1024);
        this.buffer.flip();
    }

    public BundleMetadata getBundleMetadata() throws IOException, JSONException {
        if (this.metadata != null) {
            return this.metadata;
        }
        BundleElement element = this.readNextElement();
        if (!(element instanceof BundleMetadata)) {
            throw this.abort("Expected first element in bundle to be a metadata object");
        }
        this.metadata = (BundleMetadata)element;
        this.bytesRead = 0L;
        return this.metadata;
    }

    public BundleElement getNextElement() throws IOException, JSONException {
        this.getBundleMetadata();
        return this.readNextElement();
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void close() throws IOException {
        this.dataReader.close();
    }

    @Nullable
    private BundleElement readNextElement() throws IOException, JSONException {
        String lengthPrefix = this.readLengthPrefix();
        if (lengthPrefix == null) {
            return null;
        }
        String json = this.readJsonString(Integer.parseInt(lengthPrefix));
        this.bytesRead += (long)(lengthPrefix.length() + json.getBytes(this.charset).length);
        return this.decodeBundleElement(json);
    }

    @Nullable
    private String readLengthPrefix() throws IOException {
        int nextOpenBracket;
        while ((nextOpenBracket = this.indexOfOpenBracket()) == -1 && this.pullMoreData()) {
        }
        if (this.buffer.remaining() == 0) {
            return null;
        }
        if (nextOpenBracket == -1) {
            throw this.abort("Reached the end of bundle when a length string is expected.");
        }
        char[] c = new char[nextOpenBracket];
        this.buffer.get(c);
        return new String(c);
    }

    private int indexOfOpenBracket() {
        this.buffer.mark();
        try {
            for (int i = 0; i < this.buffer.remaining(); ++i) {
                if (this.buffer.get() != '{') continue;
                int n = i;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.buffer.reset();
        }
    }

    private String readJsonString(int length) throws IOException {
        int read;
        StringBuilder json = new StringBuilder(length);
        for (int remaining = length; remaining > 0; remaining -= read) {
            if (this.buffer.remaining() == 0 && !this.pullMoreData()) {
                throw this.abort("Reached the end of bundle when more data was expected.");
            }
            read = Math.min(remaining, this.buffer.remaining());
            json.append(this.buffer, 0, read);
            this.buffer.position(this.buffer.position() + read);
        }
        return json.toString();
    }

    private boolean pullMoreData() throws IOException {
        this.buffer.compact();
        int read = this.dataReader.read(this.buffer);
        this.buffer.flip();
        return read > 0;
    }

    private BundleElement decodeBundleElement(String json) throws JSONException, IOException {
        JSONObject object = new JSONObject(json);
        if (object.has("metadata")) {
            BundleMetadata metadata = this.serializer.decodeBundleMetadata(object.getJSONObject("metadata"));
            Logger.debug("BundleElement", "BundleMetadata element loaded", new Object[0]);
            return metadata;
        }
        if (object.has("namedQuery")) {
            NamedQuery namedQuery = this.serializer.decodeNamedQuery(object.getJSONObject("namedQuery"));
            Logger.debug("BundleElement", "Query loaded: " + namedQuery.getName(), new Object[0]);
            return namedQuery;
        }
        if (object.has("documentMetadata")) {
            BundledDocumentMetadata documentMetadata = this.serializer.decodeBundledDocumentMetadata(object.getJSONObject("documentMetadata"));
            Logger.debug("BundleElement", "Document metadata loaded: " + documentMetadata.getKey(), new Object[0]);
            return documentMetadata;
        }
        if (object.has("document")) {
            BundleDocument document = this.serializer.decodeDocument(object.getJSONObject("document"));
            Logger.debug("BundleElement", "Document loaded: " + document.getKey(), new Object[0]);
            return document;
        }
        throw this.abort("Cannot decode unknown Bundle element: " + json);
    }

    private IllegalArgumentException abort(String message) throws IOException {
        this.close();
        throw new IllegalArgumentException("Invalid bundle: " + message);
    }
}

