/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.ComponentProvider;
import com.google.firebase.firestore.core.MemoryComponentProvider;
import com.google.firebase.firestore.local.GarbageCollectionScheduler;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.LruGarbageCollector;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.SQLiteLruReferenceDelegate;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.remote.RemoteSerializer;

public class SQLiteComponentProvider
extends MemoryComponentProvider {
    @Override
    protected GarbageCollectionScheduler createGarbageCollectionScheduler(ComponentProvider.Configuration configuration) {
        SQLiteLruReferenceDelegate lruDelegate = ((SQLitePersistence)this.getPersistence()).getReferenceDelegate();
        LruGarbageCollector gc = lruDelegate.getGarbageCollector();
        return gc.newScheduler(configuration.getAsyncQueue(), this.getLocalStore());
    }

    @Override
    protected Persistence createPersistence(ComponentProvider.Configuration configuration) {
        LocalSerializer serializer = new LocalSerializer(new RemoteSerializer(configuration.getDatabaseInfo().getDatabaseId()));
        LruGarbageCollector.Params params = LruGarbageCollector.Params.WithCacheSizeBytes(configuration.getSettings().getCacheSizeBytes());
        return new SQLitePersistence(configuration.getContext(), configuration.getDatabaseInfo().getPersistenceKey(), configuration.getDatabaseInfo().getDatabaseId(), serializer, params);
    }
}

