/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import androidx.annotation.Nullable;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FirebaseFirestoreException;
import java.util.concurrent.Executor;

public class AsyncEventListener<T>
implements EventListener<T> {
    private final Executor executor;
    private final EventListener<T> eventListener;
    private volatile boolean muted = false;

    public AsyncEventListener(Executor executor, EventListener<T> eventListener) {
        this.executor = executor;
        this.eventListener = eventListener;
    }

    @Override
    public void onEvent(@Nullable T value, @Nullable FirebaseFirestoreException error) {
        this.executor.execute(() -> {
            if (!this.muted) {
                this.eventListener.onEvent(value, error);
            }
        });
    }

    public void mute() {
        this.muted = true;
    }
}

