/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import androidx.annotation.Nullable;
import com.google.firebase.firestore.core.Bound;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.Values;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.Value;
import java.util.ArrayList;
import java.util.List;

public final class Target {
    public static final long NO_LIMIT = -1L;
    @Nullable
    private String memoizedCannonicalId;
    private final List<OrderBy> orderBys;
    private final List<Filter> filters;
    private final ResourcePath path;
    @Nullable
    private final String collectionGroup;
    private final long limit;
    @Nullable
    private final Bound startAt;
    @Nullable
    private final Bound endAt;

    public Target(ResourcePath path, @Nullable String collectionGroup, List<Filter> filters, List<OrderBy> orderBys, long limit, @Nullable Bound startAt, @Nullable Bound endAt) {
        this.path = path;
        this.collectionGroup = collectionGroup;
        this.orderBys = orderBys;
        this.filters = filters;
        this.limit = limit;
        this.startAt = startAt;
        this.endAt = endAt;
    }

    public ResourcePath getPath() {
        return this.path;
    }

    @Nullable
    public String getCollectionGroup() {
        return this.collectionGroup;
    }

    public boolean isDocumentQuery() {
        return DocumentKey.isDocumentKey(this.path) && this.collectionGroup == null && this.filters.isEmpty();
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean hasLimit() {
        return this.limit != -1L;
    }

    @Nullable
    public Bound getStartAt() {
        return this.startAt;
    }

    @Nullable
    public Bound getEndAt() {
        return this.endAt;
    }

    public Bound getLowerBound(FieldIndex fieldIndex) {
        ArrayList<Value> values = new ArrayList<Value>();
        boolean inclusive = true;
        for (FieldIndex.Segment segment : fieldIndex) {
            Value segmentValue = Values.NULL_VALUE;
            boolean segmentInclusive = true;
            for (Filter filter : this.filters) {
                if (!filter.getField().equals(segment.getFieldPath())) continue;
                FieldFilter fieldFilter = (FieldFilter)filter;
                Value filterValue = null;
                boolean filterInclusive = true;
                switch (fieldFilter.getOperator()) {
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: {
                        filterValue = Values.getLowerBound(fieldFilter.getValue().getValueTypeCase());
                        break;
                    }
                    case NOT_EQUAL: {
                        filterValue = Values.NULL_VALUE;
                        break;
                    }
                    case NOT_IN: {
                        filterValue = (Value)Value.newBuilder().setArrayValue(ArrayValue.newBuilder().addValues(Values.NULL_VALUE)).build();
                        break;
                    }
                    case EQUAL: 
                    case IN: 
                    case ARRAY_CONTAINS_ANY: 
                    case ARRAY_CONTAINS: 
                    case GREATER_THAN_OR_EQUAL: {
                        filterValue = fieldFilter.getValue();
                        break;
                    }
                    case GREATER_THAN: {
                        filterValue = fieldFilter.getValue();
                        filterInclusive = false;
                    }
                }
                if (Values.max(segmentValue, filterValue) != filterValue) continue;
                segmentValue = filterValue;
                segmentInclusive = filterInclusive;
            }
            if (this.startAt != null) {
                for (int i = 0; i < this.orderBys.size(); ++i) {
                    OrderBy orderBy = this.orderBys.get(i);
                    if (!orderBy.getField().equals(segment.getFieldPath())) continue;
                    Value cursorValue = this.startAt.getPosition().get(i);
                    if (Values.max(segmentValue, cursorValue) != cursorValue) break;
                    segmentValue = cursorValue;
                    segmentInclusive = this.startAt.isInclusive();
                    break;
                }
            }
            values.add(segmentValue);
            inclusive &= segmentInclusive;
        }
        return new Bound(values, inclusive);
    }

    @Nullable
    public Bound getUpperBound(FieldIndex fieldIndex) {
        ArrayList<Value> values = new ArrayList<Value>();
        boolean inclusive = true;
        for (FieldIndex.Segment segment : fieldIndex) {
            Value segmentValue = null;
            boolean segmentInclusive = true;
            for (Filter filter : this.filters) {
                if (!filter.getField().equals(segment.getFieldPath())) continue;
                FieldFilter fieldFilter = (FieldFilter)filter;
                Value filterValue = null;
                boolean filterInclusive = true;
                switch (fieldFilter.getOperator()) {
                    case NOT_EQUAL: 
                    case NOT_IN: {
                        break;
                    }
                    case GREATER_THAN_OR_EQUAL: 
                    case GREATER_THAN: {
                        filterValue = Values.getUpperBound(fieldFilter.getValue().getValueTypeCase());
                        filterInclusive = false;
                        break;
                    }
                    case LESS_THAN_OR_EQUAL: 
                    case EQUAL: 
                    case IN: 
                    case ARRAY_CONTAINS_ANY: 
                    case ARRAY_CONTAINS: {
                        filterValue = fieldFilter.getValue();
                        break;
                    }
                    case LESS_THAN: {
                        filterValue = fieldFilter.getValue();
                        filterInclusive = false;
                    }
                }
                if (Values.min(segmentValue, filterValue) != filterValue) continue;
                segmentValue = filterValue;
                segmentInclusive = filterInclusive;
            }
            if (this.endAt != null) {
                for (int i = 0; i < this.orderBys.size(); ++i) {
                    OrderBy orderBy = this.orderBys.get(i);
                    if (!orderBy.getField().equals(segment.getFieldPath())) continue;
                    Value cursorValue = this.endAt.getPosition().get(i);
                    if (Values.min(segmentValue, cursorValue) != cursorValue) break;
                    segmentValue = cursorValue;
                    segmentInclusive = this.endAt.isInclusive();
                    break;
                }
            }
            if (segmentValue == null) {
                return null;
            }
            values.add(segmentValue);
            inclusive &= segmentInclusive;
        }
        if (values.isEmpty()) {
            return null;
        }
        return new Bound(values, inclusive);
    }

    public List<OrderBy> getOrderBy() {
        return this.orderBys;
    }

    public String getCanonicalId() {
        if (this.memoizedCannonicalId != null) {
            return this.memoizedCannonicalId;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getPath().canonicalString());
        if (this.collectionGroup != null) {
            builder.append("|cg:");
            builder.append(this.collectionGroup);
        }
        builder.append("|f:");
        for (Filter filter : this.getFilters()) {
            builder.append(filter.getCanonicalId());
        }
        builder.append("|ob:");
        for (OrderBy orderBy : this.getOrderBy()) {
            builder.append(orderBy.getField().canonicalString());
            builder.append(orderBy.getDirection().equals((Object)OrderBy.Direction.ASCENDING) ? "asc" : "desc");
        }
        if (this.hasLimit()) {
            builder.append("|l:");
            builder.append(this.getLimit());
        }
        if (this.startAt != null) {
            builder.append("|lb:");
            builder.append(this.startAt.isInclusive() ? "b:" : "a:");
            builder.append(this.startAt.positionString());
        }
        if (this.endAt != null) {
            builder.append("|ub:");
            builder.append(this.endAt.isInclusive() ? "a:" : "b:");
            builder.append(this.endAt.positionString());
        }
        this.memoizedCannonicalId = builder.toString();
        return this.memoizedCannonicalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Target target = (Target)o;
        if (this.collectionGroup != null ? !this.collectionGroup.equals(target.collectionGroup) : target.collectionGroup != null) {
            return false;
        }
        if (this.limit != target.limit) {
            return false;
        }
        if (!this.orderBys.equals(target.orderBys)) {
            return false;
        }
        if (!this.filters.equals(target.filters)) {
            return false;
        }
        if (!this.path.equals(target.path)) {
            return false;
        }
        if (this.startAt != null ? !this.startAt.equals(target.startAt) : target.startAt != null) {
            return false;
        }
        return this.endAt != null ? this.endAt.equals(target.endAt) : target.endAt == null;
    }

    public int hashCode() {
        int result = this.orderBys.hashCode();
        result = 31 * result + (this.collectionGroup != null ? this.collectionGroup.hashCode() : 0);
        result = 31 * result + this.filters.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + (int)(this.limit ^ this.limit >>> 32);
        result = 31 * result + (this.startAt != null ? this.startAt.hashCode() : 0);
        result = 31 * result + (this.endAt != null ? this.endAt.hashCode() : 0);
        return result;
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("Query(");
        builder.append(this.path.canonicalString());
        if (this.collectionGroup != null) {
            builder.append(" collectionGroup=");
            builder.append(this.collectionGroup);
        }
        if (!this.filters.isEmpty()) {
            builder.append(" where ");
            for (i = 0; i < this.filters.size(); ++i) {
                if (i > 0) {
                    builder.append(" and ");
                }
                builder.append(this.filters.get(i));
            }
        }
        if (!this.orderBys.isEmpty()) {
            builder.append(" order by ");
            for (i = 0; i < this.orderBys.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.orderBys.get(i));
            }
        }
        builder.append(")");
        return builder.toString();
    }
}

