/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.index;

import com.google.firebase.firestore.index.DirectionalIndexByteEncoder;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.Value;
import com.google.protobuf.Timestamp;
import com.google.type.LatLng;
import java.util.Map;

public class FirestoreIndexValueWriter {
    public static final int DOCUMENT_NAME_OFFSET = 5;
    public static final int INDEX_TYPE_NULL = 5;
    public static final int INDEX_TYPE_BOOLEAN = 10;
    public static final int INDEX_TYPE_NAN = 13;
    public static final int INDEX_TYPE_NUMBER = 15;
    public static final int INDEX_TYPE_TIMESTAMP = 20;
    public static final int INDEX_TYPE_STRING = 25;
    public static final int INDEX_TYPE_BLOB = 30;
    public static final int INDEX_TYPE_REFERENCE = 37;
    public static final int INDEX_TYPE_GEOPOINT = 45;
    public static final int INDEX_TYPE_ARRAY = 50;
    public static final int INDEX_TYPE_MAP = 55;
    public static final int INDEX_TYPE_REFERENCE_SEGMENT = 60;
    public static final FirestoreIndexValueWriter INSTANCE = new FirestoreIndexValueWriter();

    private FirestoreIndexValueWriter() {
    }

    public void writeIndexValue(Value value, DirectionalIndexByteEncoder encoder) {
        this.writeIndexValueAux(value, encoder);
    }

    private void writeIndexValueAux(Value indexValue, DirectionalIndexByteEncoder encoder) {
        switch (indexValue.getValueTypeCase()) {
            case NULL_VALUE: {
                this.writeValueTypeLabel(encoder, 5);
                break;
            }
            case BOOLEAN_VALUE: {
                this.writeValueTypeLabel(encoder, 10);
                encoder.writeLong(indexValue.getBooleanValue() ? 1L : 0L);
                break;
            }
            case DOUBLE_VALUE: {
                double number = indexValue.getDoubleValue();
                if (Double.isNaN(number)) {
                    this.writeValueTypeLabel(encoder, 13);
                    break;
                }
                this.writeValueTypeLabel(encoder, 15);
                encoder.writeDouble(number);
                break;
            }
            case INTEGER_VALUE: {
                this.writeValueTypeLabel(encoder, 15);
                encoder.writeDouble(indexValue.getIntegerValue());
                break;
            }
            case TIMESTAMP_VALUE: {
                Timestamp timestamp = indexValue.getTimestampValue();
                this.writeValueTypeLabel(encoder, 20);
                encoder.writeLong(timestamp.getSeconds());
                encoder.writeLong(timestamp.getNanos());
                break;
            }
            case STRING_VALUE: {
                this.writeIndexString(indexValue.getStringValue(), encoder);
                break;
            }
            case BYTES_VALUE: {
                this.writeValueTypeLabel(encoder, 30);
                encoder.writeBytes(indexValue.getBytesValue());
                break;
            }
            case REFERENCE_VALUE: {
                this.writeIndexEntityRef(indexValue.getReferenceValue(), encoder);
                break;
            }
            case GEO_POINT_VALUE: {
                LatLng geoPoint = indexValue.getGeoPointValue();
                this.writeValueTypeLabel(encoder, 45);
                encoder.writeDouble(geoPoint.getLatitude());
                encoder.writeDouble(geoPoint.getLongitude());
                break;
            }
            case MAP_VALUE: {
                this.writeIndexMap(indexValue.getMapValue(), encoder);
                break;
            }
            case ARRAY_VALUE: {
                this.writeIndexArray(indexValue.getArrayValue(), encoder);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown index value type " + (Object)((Object)indexValue.getValueTypeCase()));
            }
        }
    }

    private void writeIndexString(String stringIndexValue, DirectionalIndexByteEncoder encoder) {
        this.writeValueTypeLabel(encoder, 25);
        this.writeUnlabeledIndexString(stringIndexValue, encoder);
    }

    private void writeUnlabeledIndexString(String stringIndexValue, DirectionalIndexByteEncoder encoder) {
        encoder.writeString(stringIndexValue);
    }

    private void writeIndexMap(MapValue mapIndexValue, DirectionalIndexByteEncoder encoder) {
        this.writeValueTypeLabel(encoder, 55);
        for (Map.Entry<String, Value> entry : mapIndexValue.getFieldsMap().entrySet()) {
            String key = entry.getKey();
            Value value = entry.getValue();
            this.writeIndexString(key, encoder);
            this.writeIndexValueAux(value, encoder);
        }
    }

    private void writeIndexArray(ArrayValue arrayIndexValue, DirectionalIndexByteEncoder encoder) {
        this.writeValueTypeLabel(encoder, 50);
        for (Value element : arrayIndexValue.getValuesList()) {
            this.writeIndexValueAux(element, encoder);
        }
    }

    private void writeIndexEntityRef(String referenceValue, DirectionalIndexByteEncoder encoder) {
        this.writeValueTypeLabel(encoder, 37);
        ResourcePath path = ResourcePath.fromString(referenceValue);
        int numSegments = path.length();
        for (int index = 5; index < numSegments; ++index) {
            String segment = path.getSegment(index);
            this.writeValueTypeLabel(encoder, 60);
            this.writeUnlabeledIndexString(segment, encoder);
        }
    }

    private void writeValueTypeLabel(DirectionalIndexByteEncoder encoder, int typeOrder) {
        encoder.writeLong(typeOrder);
    }
}

