/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.firestore.index.IndexEntry;
import com.google.firebase.firestore.local.LocalStore;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.local.Scheduler;
import com.google.firebase.firestore.util.AsyncQueue;
import java.util.concurrent.TimeUnit;

public class IndexBackfiller {
    private static final long INITIAL_BACKFILL_DELAY_MS = TimeUnit.SECONDS.toMillis(15L);
    private static final long REGULAR_BACKFILL_DELAY_MS = TimeUnit.MINUTES.toMillis(1L);
    private final SQLitePersistence persistence;

    public IndexBackfiller(SQLitePersistence sqLitePersistence) {
        this.persistence = sqLitePersistence;
    }

    public BackfillScheduler newScheduler(AsyncQueue asyncQueue, LocalStore localStore) {
        return new BackfillScheduler(asyncQueue, localStore);
    }

    public Results backfill() {
        int numIndexesWritten = 0;
        int numIndexesRemoved = 0;
        return new Results(true, numIndexesWritten, numIndexesRemoved);
    }

    @VisibleForTesting
    void addIndexEntry(IndexEntry entry) {
        this.persistence.execute("INSERT OR IGNORE INTO index_entries (index_id, index_value, uid, document_name) VALUES(?, ?, ?, ?)", entry.getIndexId(), entry.getIndexValue(), entry.getUid(), entry.getDocumentName());
    }

    @VisibleForTesting
    void removeIndexEntry(int indexId, String uid, String documentName) {
        this.persistence.execute("DELETE FROM index_entries WHERE index_id = ? AND uid = ?AND document_name = ?", indexId, uid, documentName);
    }

    @Nullable
    @VisibleForTesting
    IndexEntry getIndexEntry(int indexId) {
        return (IndexEntry)this.persistence.query("SELECT index_value, uid, document_name FROM index_entries WHERE index_id = ?").binding(indexId).firstValue(row -> row == null ? null : new IndexEntry(indexId, row.getBlob(0), row.getString(1), row.getString(2)));
    }

    public class BackfillScheduler
    implements Scheduler {
        private final AsyncQueue asyncQueue;
        private final LocalStore localStore;
        private boolean hasRun = false;
        @Nullable
        private AsyncQueue.DelayedTask backfillTask;

        public BackfillScheduler(AsyncQueue asyncQueue, LocalStore localStore) {
            this.asyncQueue = asyncQueue;
            this.localStore = localStore;
        }

        @Override
        public void start() {
            this.scheduleBackfill();
        }

        @Override
        public void stop() {
            if (this.backfillTask != null) {
                this.backfillTask.cancel();
            }
        }

        private void scheduleBackfill() {
            long delay = this.hasRun ? REGULAR_BACKFILL_DELAY_MS : INITIAL_BACKFILL_DELAY_MS;
            this.backfillTask = this.asyncQueue.enqueueAfterDelay(AsyncQueue.TimerId.INDEX_BACKFILL, delay, () -> {
                this.localStore.backfillIndexes(IndexBackfiller.this);
                this.hasRun = true;
                this.scheduleBackfill();
            });
        }
    }

    public static class Results {
        private final boolean hasRun;
        private final int entriesAdded;
        private final int entriesRemoved;

        static Results DidNotRun() {
            return new Results(false, 0, 0);
        }

        Results(boolean hasRun, int entriesAdded, int entriesRemoved) {
            this.hasRun = hasRun;
            this.entriesAdded = entriesAdded;
            this.entriesRemoved = entriesRemoved;
        }

        public boolean hasRun() {
            return this.hasRun;
        }

        public int getEntriesAdded() {
            return this.entriesAdded;
        }

        public int getEntriesRemoved() {
            return this.entriesRemoved;
        }
    }
}

