/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.local.DocumentOverlay;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.util.Assert;
import com.google.firestore.v1.Write;
import com.google.protobuf.InvalidProtocolBufferException;

public class SQLiteDocumentOverlay
implements DocumentOverlay {
    private final SQLitePersistence db;
    private final LocalSerializer serializer;
    private final String uid;

    public SQLiteDocumentOverlay(SQLitePersistence db, LocalSerializer serializer, User user) {
        this.db = db;
        this.serializer = serializer;
        this.uid = user.isAuthenticated() ? user.getUid() : "";
    }

    @Override
    @Nullable
    public Mutation getOverlay(DocumentKey key) {
        String path = EncodedPath.encode(key.getPath());
        return (Mutation)this.db.query("SELECT overlay_mutation FROM document_overlays WHERE uid = ? AND path = ?").binding(this.uid, path).firstValue(row -> {
            if (row != null) {
                try {
                    Write mutation = Write.parseFrom(row.getBlob(0));
                    return this.serializer.decodeMutation(mutation);
                }
                catch (InvalidProtocolBufferException e) {
                    throw Assert.fail("Overlay failed to parse: %s", new Object[]{e});
                }
            }
            return null;
        });
    }

    @Override
    public void saveOverlay(DocumentKey key, Mutation mutation) {
        this.db.execute("INSERT OR REPLACE INTO document_overlays (uid, path, overlay_mutation) VALUES (?, ?, ?)", this.uid, EncodedPath.encode(key.getPath()), this.serializer.encodeMutation(mutation).toByteArray());
    }

    @Override
    public void removeOverlay(DocumentKey key) {
        this.db.execute("DELETE FROM document_overlays WHERE uid = ? AND path = ?", this.uid, EncodedPath.encode(key.getPath()));
    }
}

