/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import com.google.firebase.firestore.core.Bound;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.index.FirestoreIndexValueWriter;
import com.google.firebase.firestore.index.IndexByteEncoder;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.MemoryIndexManager;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.TargetIndexMatcher;
import com.google.firebase.firestore.model.Values;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Util;
import com.google.firestore.admin.v1.Index;
import com.google.firestore.v1.Value;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

final class SQLiteIndexManager
implements IndexManager {
    private static final String TAG = SQLiteIndexManager.class.getSimpleName();
    private final MemoryIndexManager.MemoryCollectionParentIndex collectionParentsCache = new MemoryIndexManager.MemoryCollectionParentIndex();
    private final SQLitePersistence db;
    private final LocalSerializer serializer;

    SQLiteIndexManager(SQLitePersistence persistence, LocalSerializer serializer) {
        this.db = persistence;
        this.serializer = serializer;
    }

    @Override
    public void addToCollectionParentIndex(ResourcePath collectionPath) {
        Assert.hardAssert(collectionPath.length() % 2 == 1, "Expected a collection path.", new Object[0]);
        if (this.collectionParentsCache.add(collectionPath)) {
            String collectionId = collectionPath.getLastSegment();
            ResourcePath parentPath = (ResourcePath)collectionPath.popLast();
            this.db.execute("INSERT OR REPLACE INTO collection_parents (collection_id, parent) VALUES (?, ?)", collectionId, EncodedPath.encode(parentPath));
        }
    }

    @Override
    public List<ResourcePath> getCollectionParents(String collectionId) {
        ArrayList<ResourcePath> parentPaths = new ArrayList<ResourcePath>();
        this.db.query("SELECT parent FROM collection_parents WHERE collection_id = ?").binding(collectionId).forEach(row -> parentPaths.add(EncodedPath.decodeResourcePath(row.getString(0))));
        return parentPaths;
    }

    @Override
    public void addFieldIndex(FieldIndex index) {
        int currentMax = (Integer)this.db.query("SELECT MAX(index_id) FROM index_configuration").firstValue(input -> input.isNull(0) ? 0 : input.getInt(0));
        this.db.execute("INSERT INTO index_configuration (index_id, collection_group, index_proto, active, update_time_seconds, update_time_nanos) VALUES(?, ?, ?, ?, ?, ?)", currentMax + 1, index.getCollectionGroup(), this.encodeFieldIndex(index), true, index.getVersion().getTimestamp().getSeconds(), index.getVersion().getTimestamp().getNanoseconds());
    }

    @Override
    public void addIndexEntries(Document document) {
        DocumentKey documentKey = document.getKey();
        String collectionGroup = documentKey.getCollectionGroup();
        this.db.query("SELECT index_id, index_proto, update_time_seconds, update_time_nanos FROM index_configuration WHERE collection_group = ? AND active = 1").binding(collectionGroup).forEach(row -> {
            try {
                void var9_13;
                int indexId = row.getInt(0);
                FieldIndex fieldIndex = this.serializer.decodeFieldIndex(collectionGroup, row.getInt(0), Index.parseFrom(row.getBlob(1)), row.getInt(2), row.getInt(3));
                ArrayList<Value> arrayValues = new ArrayList<Value>();
                for (FieldIndex.Segment segment : fieldIndex.getArraySegments()) {
                    Value value = document.getField(segment.getFieldPath());
                    if (!Values.isArray(value)) {
                        return;
                    }
                    arrayValues.addAll(value.getArrayValue().getValuesList());
                }
                ArrayList<Value> directionalValues = new ArrayList<Value>();
                for (FieldIndex.Segment segment : fieldIndex.getDirectionalSegments()) {
                    Value field = document.getField(segment.getFieldPath());
                    if (field == null) {
                        return;
                    }
                    directionalValues.add(field);
                }
                if (Logger.isDebugEnabled()) {
                    Logger.debug(TAG, "Adding index values for document '%s' to index '%s'", documentKey, fieldIndex);
                }
                boolean bl = false;
                while (var9_13 < Math.max(arrayValues.size(), 1)) {
                    this.addSingleEntry(documentKey, indexId, this.encode(var9_13 < arrayValues.size() ? (Value)arrayValues.get((int)var9_13) : null), this.encode(directionalValues));
                    ++var9_13;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw Assert.fail("Invalid index: " + (Object)((Object)e), new Object[0]);
            }
        });
    }

    private void addSingleEntry(DocumentKey documentKey, int indexId, @Nullable Object arrayIndex, Object directionalIndex) {
        this.db.execute("INSERT INTO index_entries (index_id, array_value, directional_value, document_name) VALUES(?, ?, ?, ?)", indexId, arrayIndex, directionalIndex, documentKey.toString());
    }

    @Override
    @Nullable
    public Set<DocumentKey> getDocumentsMatchingTarget(Target target) {
        FieldIndex fieldIndex = this.getMatchingIndex(target);
        if (fieldIndex == null) {
            return null;
        }
        List<Value> arrayValues = target.getArrayValues(fieldIndex);
        Bound lowerBound = target.getLowerBound(fieldIndex);
        Bound upperBound = target.getUpperBound(fieldIndex);
        if (Logger.isDebugEnabled()) {
            Logger.debug(TAG, "Using index '%s' to execute '%s' (Arrays: %s, Lower bound: %s, Upper bound: %s)", fieldIndex, target, arrayValues, lowerBound, upperBound);
        }
        Object[] lowerBoundValues = this.encodeBound(fieldIndex, target, lowerBound);
        String lowerBoundOp = lowerBound.isInclusive() ? ">=" : ">";
        Object[] upperBoundValues = this.encodeBound(fieldIndex, target, upperBound);
        String upperBoundOp = upperBound != null && upperBound.isInclusive() ? "<=" : "<";
        SQLitePersistence.Query query = this.generateQuery(target, fieldIndex.getIndexId(), arrayValues, lowerBoundValues, lowerBoundOp, upperBoundValues, upperBoundOp);
        HashSet<DocumentKey> result = new HashSet<DocumentKey>();
        query.forEach(row -> result.add(DocumentKey.fromPath(ResourcePath.fromString(row.getString(0)))));
        Logger.debug(TAG, "Index scan returned %s documents", result.size());
        return result;
    }

    private SQLitePersistence.Query generateQuery(Target target, int indexId, List<Value> arrayValues, Object[] lowerBounds, String lowerBoundOp, @Nullable Object[] upperBounds, String upperBoundOp) {
        int statementCount = Math.max(arrayValues.size(), 1) * lowerBounds.length;
        int bindsPerStatement = 2 + (arrayValues.isEmpty() ? 0 : 1) + (upperBounds != null ? 1 : 0);
        Object[] bindArgs = new Object[statementCount * bindsPerStatement];
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT document_name, directional_value FROM index_entries WHERE index_id = ? ");
        if (!arrayValues.isEmpty()) {
            statement.append("AND array_value = ? ");
        }
        statement.append("AND directional_value ").append(lowerBoundOp).append(" ? ");
        if (upperBounds != null) {
            statement.append("AND directional_value ").append(upperBoundOp).append(" ? ");
        }
        String sql = Util.repeatSequence(statement, statementCount, " UNION ");
        if (target.getLimit() != -1L) {
            String direction = target.getFirstOrderBy().getDirection().canonicalString();
            sql = sql + "ORDER BY directional_value " + direction + ", document_name " + direction + " ";
            sql = sql + "LIMIT " + target.getLimit() + " ";
        }
        Iterator<Value> arrayValueIterator = arrayValues.iterator();
        int offset = 0;
        while (offset < bindArgs.length) {
            Object arrayValue = this.encode(arrayValueIterator.hasNext() ? arrayValueIterator.next() : null);
            offset = this.fillBounds(bindArgs, offset, indexId, arrayValue, lowerBounds, upperBounds);
        }
        return this.db.query(sql).binding(bindArgs);
    }

    private int fillBounds(Object[] bindArgs, int offset, int indexId, @Nullable Object arrayValue, Object[] lowerBounds, @Nullable Object[] upperBounds) {
        Assert.hardAssert(upperBounds == null || upperBounds.length == lowerBounds.length, "Length of upper and lower bound should match", new Object[0]);
        for (int i = 0; i < lowerBounds.length; ++i) {
            bindArgs[offset++] = indexId;
            if (arrayValue != null) {
                bindArgs[offset++] = arrayValue;
            }
            bindArgs[offset++] = lowerBounds[i];
            if (upperBounds == null) continue;
            bindArgs[offset++] = upperBounds[i];
        }
        return offset;
    }

    @Nullable
    private FieldIndex getMatchingIndex(Target target) {
        TargetIndexMatcher targetIndexMatcher = new TargetIndexMatcher(target);
        String collectionGroup = target.getCollectionGroup() != null ? target.getCollectionGroup() : target.getPath().getLastSegment();
        ArrayList activeIndices = new ArrayList();
        this.db.query("SELECT index_id, index_proto, update_time_seconds, update_time_nanos FROM index_configuration WHERE collection_group = ? AND active = 1").binding(collectionGroup).forEach(row -> {
            try {
                FieldIndex fieldIndex = this.serializer.decodeFieldIndex(collectionGroup, row.getInt(0), Index.parseFrom(row.getBlob(1)), row.getInt(2), row.getInt(3));
                boolean matches = targetIndexMatcher.servedByIndex(fieldIndex);
                if (matches) {
                    activeIndices.add(fieldIndex);
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw Assert.fail("Failed to decode index: " + (Object)((Object)e), new Object[0]);
            }
        });
        if (activeIndices.isEmpty()) {
            return null;
        }
        return (FieldIndex)Collections.max(activeIndices, (l, r) -> Integer.compare(l.segmentCount(), r.segmentCount()));
    }

    private Object encode(List<Value> values) {
        IndexByteEncoder encoder = new IndexByteEncoder();
        for (Value value : values) {
            FirestoreIndexValueWriter.INSTANCE.writeIndexValue(value, encoder);
        }
        return encoder.getEncodedBytes();
    }

    @Nullable
    private Object encode(@Nullable Value value) {
        return value != null ? this.encode(Collections.singletonList(value)) : null;
    }

    @Nullable
    private Object[] encodeBound(FieldIndex fieldIndex, Target target, @Nullable Bound bound) {
        if (bound == null) {
            return null;
        }
        List<IndexByteEncoder> encoders = new ArrayList<IndexByteEncoder>();
        encoders.add(new IndexByteEncoder());
        Iterator<Value> position = bound.getPosition().iterator();
        for (FieldIndex.Segment segment : fieldIndex.getDirectionalSegments()) {
            Value value = position.next();
            for (IndexByteEncoder encoder : encoders) {
                if (this.isInFilter(target, segment.getFieldPath()) && Values.isArray(value)) {
                    encoders = this.expandIndexValues(encoders, value);
                    continue;
                }
                FirestoreIndexValueWriter.INSTANCE.writeIndexValue(value, encoder);
            }
        }
        return this.getEncodedBytes(encoders);
    }

    private Object[] getEncodedBytes(List<IndexByteEncoder> encoders) {
        Object[] result = new Object[encoders.size()];
        for (int i = 0; i < encoders.size(); ++i) {
            result[i] = encoders.get(i).getEncodedBytes();
        }
        return result;
    }

    private List<IndexByteEncoder> expandIndexValues(List<IndexByteEncoder> encoders, Value value) {
        ArrayList<IndexByteEncoder> prefixes = new ArrayList<IndexByteEncoder>(encoders);
        ArrayList<IndexByteEncoder> results = new ArrayList<IndexByteEncoder>();
        for (Value arrayElement : value.getArrayValue().getValuesList()) {
            for (IndexByteEncoder prefix : prefixes) {
                IndexByteEncoder clonedEncoder = new IndexByteEncoder();
                clonedEncoder.seed(prefix.getEncodedBytes());
                FirestoreIndexValueWriter.INSTANCE.writeIndexValue(arrayElement, clonedEncoder);
                results.add(clonedEncoder);
            }
        }
        return results;
    }

    private boolean isInFilter(Target target, FieldPath fieldPath) {
        for (Filter filter : target.getFilters()) {
            if (!filter.getField().equals(fieldPath)) continue;
            Filter.Operator operator = ((FieldFilter)filter).getOperator();
            return operator.equals((Object)Filter.Operator.IN) || operator.equals((Object)Filter.Operator.NOT_IN);
        }
        return false;
    }

    private byte[] encodeFieldIndex(FieldIndex fieldIndex) {
        return this.serializer.encodeFieldIndex(fieldIndex).toByteArray();
    }

    public List<FieldIndex> getFieldIndexes() {
        ArrayList<FieldIndex> allIndexes = new ArrayList<FieldIndex>();
        this.db.query("SELECT index_id, collection_group, index_proto, update_time_seconds, update_time_nanos FROM index_configuration WHERE active = 1").forEach(row -> {
            try {
                allIndexes.add(this.serializer.decodeFieldIndex(row.getString(1), row.getInt(0), Index.parseFrom(row.getBlob(2)), row.getInt(3), row.getInt(4)));
            }
            catch (InvalidProtocolBufferException e) {
                throw Assert.fail("Failed to decode index: " + (Object)((Object)e), new Object[0]);
            }
        });
        return allIndexes;
    }
}

