/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.firebase.Timestamp;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.DocumentCollections;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MutableDocument;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.proto.MaybeDocument;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.BackgroundQueue;
import com.google.firebase.firestore.util.Executors;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

final class SQLiteRemoteDocumentCache
implements RemoteDocumentCache {
    private final SQLitePersistence db;
    private final LocalSerializer serializer;

    SQLiteRemoteDocumentCache(SQLitePersistence persistence, LocalSerializer serializer) {
        this.db = persistence;
        this.serializer = serializer;
    }

    @Override
    public void add(MutableDocument document, SnapshotVersion readTime) {
        Assert.hardAssert(!readTime.equals(SnapshotVersion.NONE), "Cannot add document to the RemoteDocumentCache with a read time of zero", new Object[0]);
        String path = this.pathForKey(document.getKey());
        Timestamp timestamp = readTime.getTimestamp();
        MaybeDocument message = this.serializer.encodeMaybeDocument(document);
        this.db.execute("INSERT OR REPLACE INTO remote_documents (path, read_time_seconds, read_time_nanos, contents) VALUES (?, ?, ?, ?)", path, timestamp.getSeconds(), timestamp.getNanoseconds(), message.toByteArray());
        this.db.getIndexManager().addToCollectionParentIndex((ResourcePath)document.getKey().getPath().popLast());
    }

    @Override
    public void remove(DocumentKey documentKey) {
        String path = this.pathForKey(documentKey);
        this.db.execute("DELETE FROM remote_documents WHERE path = ?", path);
    }

    @Override
    public MutableDocument get(DocumentKey documentKey) {
        String path = this.pathForKey(documentKey);
        MutableDocument document = (MutableDocument)this.db.query("SELECT contents FROM remote_documents WHERE path = ?").binding(path).firstValue(row -> this.decodeMaybeDocument(row.getBlob(0)));
        return document != null ? document : MutableDocument.newInvalidDocument(documentKey);
    }

    @Override
    public Map<DocumentKey, MutableDocument> getAll(Iterable<DocumentKey> documentKeys) {
        ArrayList<Object> args = new ArrayList<Object>();
        for (DocumentKey documentKey : documentKeys) {
            args.add(EncodedPath.encode(documentKey.getPath()));
        }
        HashMap<DocumentKey, MutableDocument> results = new HashMap<DocumentKey, MutableDocument>();
        for (DocumentKey key : documentKeys) {
            results.put(key, MutableDocument.newInvalidDocument(key));
        }
        SQLitePersistence.LongQuery longQuery = new SQLitePersistence.LongQuery(this.db, "SELECT contents FROM remote_documents WHERE path IN (", args, ") ORDER BY path");
        while (longQuery.hasMoreSubqueries()) {
            longQuery.performNextSubquery().forEach(row -> {
                MutableDocument decoded = this.decodeMaybeDocument(row.getBlob(0));
                results.put(decoded.getKey(), decoded);
            });
        }
        return results;
    }

    @Override
    public ImmutableSortedMap<DocumentKey, MutableDocument> getAllDocumentsMatchingQuery(Query query, SnapshotVersion sinceReadTime) {
        Assert.hardAssert(!query.isCollectionGroupQuery(), "CollectionGroup queries should be handled in LocalDocumentsView", new Object[0]);
        ResourcePath prefix = query.getPath();
        int immediateChildrenPathLength = prefix.length() + 1;
        String prefixPath = EncodedPath.encode(prefix);
        String prefixSuccessorPath = EncodedPath.prefixSuccessor(prefixPath);
        Timestamp readTime = sinceReadTime.getTimestamp();
        BackgroundQueue backgroundQueue = new BackgroundQueue();
        ImmutableSortedMap[] matchingDocuments = new ImmutableSortedMap[]{DocumentCollections.emptyMutableDocumentMap()};
        SQLitePersistence.Query sqlQuery = sinceReadTime.equals(SnapshotVersion.NONE) ? this.db.query("SELECT path, contents FROM remote_documents WHERE path >= ? AND path < ?").binding(prefixPath, prefixSuccessorPath) : this.db.query("SELECT path, contents FROM remote_documents WHERE path >= ? AND path < ?AND (read_time_seconds > ? OR (read_time_seconds = ? AND read_time_nanos > ?))").binding(prefixPath, prefixSuccessorPath, readTime.getSeconds(), readTime.getSeconds(), readTime.getNanoseconds());
        sqlQuery.forEach(row -> {
            ResourcePath path = EncodedPath.decodeResourcePath(row.getString(0));
            if (path.length() != immediateChildrenPathLength) {
                return;
            }
            byte[] rawDocument = row.getBlob(1);
            Executor executor = row.isLast() ? Executors.DIRECT_EXECUTOR : backgroundQueue;
            executor.execute(() -> {
                MutableDocument document = this.decodeMaybeDocument(rawDocument);
                if (document.isFoundDocument() && query.matches(document)) {
                    SQLiteRemoteDocumentCache sQLiteRemoteDocumentCache = this;
                    synchronized (sQLiteRemoteDocumentCache) {
                        matchingDocuments[0] = matchingDocuments[0].insert((Object)document.getKey(), (Object)document);
                    }
                }
            });
        });
        try {
            backgroundQueue.drain();
        }
        catch (InterruptedException e) {
            Assert.fail("Interrupted while deserializing documents", e);
        }
        return matchingDocuments[0];
    }

    private String pathForKey(DocumentKey key) {
        return EncodedPath.encode(key.getPath());
    }

    private MutableDocument decodeMaybeDocument(byte[] bytes) {
        try {
            return this.serializer.decodeMaybeDocument(MaybeDocument.parseFrom(bytes));
        }
        catch (InvalidProtocolBufferException e) {
            throw Assert.fail("MaybeDocument failed to parse: %s", new Object[]{e});
        }
    }
}

