/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.model.FieldIndex;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TargetIndexMatcher {
    private final String collectionId;
    private final Map<FieldPath, List<FieldFilter>> fieldFilterFields = new HashMap<FieldPath, List<FieldFilter>>();
    private final Set<FieldPath> orderByFields = new HashSet<FieldPath>();

    public TargetIndexMatcher(Target target) {
        this.collectionId = target.getCollectionGroup() != null ? target.getCollectionGroup() : target.getPath().getLastSegment();
        for (Filter filter : target.getFilters()) {
            Assert.hardAssert(filter instanceof FieldFilter, "Only FieldFilters are supported", new Object[0]);
            List<FieldFilter> currentFilters = this.fieldFilterFields.get(filter.getField());
            if (currentFilters == null) {
                currentFilters = new ArrayList<FieldFilter>();
                this.fieldFilterFields.put(filter.getField(), currentFilters);
            }
            currentFilters.add((FieldFilter)filter);
        }
        for (OrderBy orderBy : target.getOrderBy()) {
            this.orderByFields.add(orderBy.getField());
        }
    }

    public boolean servedByIndex(FieldIndex index) {
        Assert.hardAssert(index.getCollectionGroup().equals(this.collectionId), "Collection IDs do not match", new Object[0]);
        for (int i = 0; i < index.segmentCount(); ++i) {
            if (this.canUseSegment(index.getSegment(i))) continue;
            return false;
        }
        return true;
    }

    private boolean canUseSegment(FieldIndex.Segment segment) {
        List<FieldFilter> filters = this.fieldFilterFields.get(segment.getFieldPath());
        if (filters != null) {
            block3: for (FieldFilter filter : filters) {
                switch (filter.getOperator()) {
                    case ARRAY_CONTAINS: 
                    case ARRAY_CONTAINS_ANY: {
                        if (!segment.getKind().equals((Object)FieldIndex.Segment.Kind.CONTAINS)) continue block3;
                        return true;
                    }
                }
                if (!segment.getKind().equals((Object)FieldIndex.Segment.Kind.ORDERED)) continue;
                return true;
            }
        }
        return this.orderByFields.contains(segment.getFieldPath()) && segment.getKind().equals((Object)FieldIndex.Segment.Kind.ORDERED);
    }
}

