/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import androidx.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.Value;

public final class ServerTimestamps {
    private static final String SERVER_TIMESTAMP_SENTINEL = "server_timestamp";
    private static final String TYPE_KEY = "__type__";
    private static final String PREVIOUS_VALUE_KEY = "__previous_value__";
    private static final String LOCAL_WRITE_TIME_KEY = "__local_write_time__";

    private ServerTimestamps() {
    }

    public static boolean isServerTimestamp(@Nullable Value value) {
        Value type = value == null ? null : value.getMapValue().getFieldsOrDefault(TYPE_KEY, null);
        return type != null && SERVER_TIMESTAMP_SENTINEL.equals(type.getStringValue());
    }

    public static Value valueOf(Timestamp localWriteTime, @Nullable Value previousValue) {
        Value encodedType = (Value)Value.newBuilder().setStringValue(SERVER_TIMESTAMP_SENTINEL).build();
        Value encodeWriteTime = (Value)Value.newBuilder().setTimestampValue(com.google.protobuf.Timestamp.newBuilder().setSeconds(localWriteTime.getSeconds()).setNanos(localWriteTime.getNanoseconds())).build();
        MapValue.Builder mapRepresentation = MapValue.newBuilder().putFields(TYPE_KEY, encodedType).putFields(LOCAL_WRITE_TIME_KEY, encodeWriteTime);
        if (previousValue != null) {
            mapRepresentation.putFields(PREVIOUS_VALUE_KEY, previousValue);
        }
        return (Value)Value.newBuilder().setMapValue(mapRepresentation).build();
    }

    @Nullable
    public static Value getPreviousValue(Value serverTimestampValue) {
        Value previousValue = serverTimestampValue.getMapValue().getFieldsOrDefault(PREVIOUS_VALUE_KEY, null);
        if (ServerTimestamps.isServerTimestamp(previousValue)) {
            return ServerTimestamps.getPreviousValue(previousValue);
        }
        return previousValue;
    }

    public static com.google.protobuf.Timestamp getLocalWriteTime(Value serverTimestampValue) {
        return serverTimestampValue.getMapValue().getFieldsOrThrow(LOCAL_WRITE_TIME_KEY).getTimestampValue();
    }
}

