/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.firebase.firestore.model.BasePath;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class EncodedPath {
    private static final char ESCAPE = '\u0001';
    private static final char ENCODED_SEPARATOR = '\u0001';
    private static final char ENCODED_NUL = '\u0010';
    private static final char ENCODED_ESCAPE = '\u0011';

    EncodedPath() {
    }

    static <B extends BasePath<B>> String encode(B path) {
        StringBuilder result = new StringBuilder();
        int length = path.length();
        for (int i = 0; i < length; ++i) {
            if (result.length() > 0) {
                EncodedPath.encodeSeparator(result);
            }
            EncodedPath.encodeSegment(path.getSegment(i), result);
        }
        EncodedPath.encodeSeparator(result);
        return result.toString();
    }

    private static void encodeSegment(String segment, StringBuilder result) {
        int length = segment.length();
        block4: for (int i = 0; i < length; ++i) {
            char c = segment.charAt(i);
            switch (c) {
                case '\u0000': {
                    result.append('\u0001').append('\u0010');
                    continue block4;
                }
                case '\u0001': {
                    result.append('\u0001').append('\u0011');
                    continue block4;
                }
                default: {
                    result.append(c);
                }
            }
        }
    }

    private static void encodeSeparator(StringBuilder result) {
        result.append('\u0001').append('\u0001');
    }

    static ResourcePath decodeResourcePath(String path) {
        return ResourcePath.fromSegments(EncodedPath.decode(path));
    }

    static FieldPath decodeFieldPath(String path) {
        return FieldPath.fromSegments(EncodedPath.decode(path));
    }

    private static List<String> decode(String path) {
        int length = path.length();
        Assert.hardAssert(length >= 2, "Invalid path \"%s\"", path);
        if (length == 2) {
            Assert.hardAssert(path.charAt(0) == '\u0001' && path.charAt(1) == '\u0001', "Non-empty path \"%s\" had length 2", path);
            return Collections.emptyList();
        }
        int lastReasonableEscapeIndex = path.length() - 2;
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder segmentBuilder = new StringBuilder();
        int start = 0;
        while (start < length) {
            int end = path.indexOf(1, start);
            if (end < 0 || end > lastReasonableEscapeIndex) {
                throw new IllegalArgumentException("Invalid encoded resource path: \"" + path + "\"");
            }
            char next = path.charAt(end + 1);
            switch (next) {
                case '\u0001': {
                    String segment;
                    String currentPiece = path.substring(start, end);
                    if (segmentBuilder.length() == 0) {
                        segment = currentPiece;
                    } else {
                        segmentBuilder.append(currentPiece);
                        segment = segmentBuilder.toString();
                        segmentBuilder.setLength(0);
                    }
                    segments.add(segment);
                    break;
                }
                case '\u0010': {
                    segmentBuilder.append(path.substring(start, end));
                    segmentBuilder.append('\u0000');
                    break;
                }
                case '\u0011': {
                    segmentBuilder.append(path.substring(start, end + 1));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid encoded resource path: \"" + path + "\"");
                }
            }
            start = end + 2;
        }
        return segments;
    }

    static String prefixSuccessor(String path) {
        StringBuilder result = new StringBuilder(path);
        int pos = result.length() - 1;
        char c = result.charAt(pos);
        Assert.hardAssert(c == '\u0001', "successor may only operate on paths generated by encode", new Object[0]);
        result.setCharAt(pos, (char)(c + '\u0001'));
        return result.toString();
    }
}

