/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import androidx.annotation.Nullable;
import com.google.firebase.firestore.bundle.BundleMetadata;
import com.google.firebase.firestore.bundle.NamedQuery;
import com.google.firebase.firestore.local.BundleCache;
import java.util.HashMap;
import java.util.Map;

class MemoryBundleCache
implements BundleCache {
    private final Map<String, BundleMetadata> bundles = new HashMap<String, BundleMetadata>();
    private final Map<String, NamedQuery> namedQueries = new HashMap<String, NamedQuery>();

    MemoryBundleCache() {
    }

    @Override
    @Nullable
    public BundleMetadata getBundleMetadata(String bundleId) {
        return this.bundles.get(bundleId);
    }

    @Override
    public void saveBundleMetadata(BundleMetadata metadata) {
        this.bundles.put(metadata.getBundleId(), metadata);
    }

    @Override
    @Nullable
    public NamedQuery getNamedQuery(String queryName) {
        return this.namedQueries.get(queryName);
    }

    @Override
    public void saveNamedQuery(NamedQuery query) {
        this.namedQueries.put(query.getName(), query);
    }
}

